/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.tokenizer;

import ai.grazie.model.llm.profile.LLMProfileID;
import com.intellij.ml.llm.tokenizer.Models;
import com.intellij.ml.llm.tokenizer.TokenizerModelConfig;
import com.intellij.openapi.util.registry.Registry;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000f\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\u0005J\b\u0010\u0011\u001a\u00020\u0005H\u0007J\u0006\u0010\u0012\u001a\u00020\u0005J\u0006\u0010\u0013\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0015\u001a\u00020\u0005J\u0006\u0010\u0016\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0005J\u0006\u0010\u0018\u001a\u00020\u0005J\u0006\u0010\u0019\u001a\u00020\u0005J\u0006\u0010\u001a\u001a\u00020\u0005R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/tokenizer/TokenQuota;", "", "<init>", "()V", "getHardTokenLimit", "", "id", "Lai/grazie/model/llm/profile/LLMProfileID;", "getMessageSoftTokenLimit", "llmProfileId", "getMessageSoftTokenLimit2", "MODELS_WITH_EXPERIMENTAL_MULTIPLIER", "", "getMODELS_WITH_EXPERIMENTAL_MULTIPLIER", "()Ljava/util/List;", "getCodeDependencyTokenLimit", "getCodeDependencyDepthLimit", "getFunctionResponseTokenLimit", "getMaxFileSize", "getMaxFileLengthWithoutSummarization", "getCommitChatMessageTokenLimit", "getCommitMessageCompletionTokenLimit", "getChatMessageCompletionTokenLimit", "getChatSessionSummaryTokenLimit", "getExperimentalHardLimitMultiplyer", "getExperimentalSoftLimitMultiplyer", "getCodeGenerationTokenLimitMultiplier", "intellij.ml.llm.tokenizer"})
@SourceDebugExtension(value={"SMAP\nTokenQuota.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenQuota.kt\ncom/intellij/ml/llm/tokenizer/TokenQuota\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class TokenQuota {
    @NotNull
    public static final TokenQuota INSTANCE = new TokenQuota();
    @NotNull
    private static final List<LLMProfileID> MODELS_WITH_EXPERIMENTAL_MULTIPLIER = CollectionsKt.emptyList();

    private TokenQuota() {
    }

    public final int getHardTokenLimit(@NotNull LLMProfileID id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = Models.INSTANCE.getAll();
            for (Object t : iterable) {
                TokenizerModelConfig it = (TokenizerModelConfig)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProfile(), (Object)id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        TokenizerModelConfig tokenizerModelConfig = v0;
        return tokenizerModelConfig != null ? tokenizerModelConfig.getHardLimit() : Models.INSTANCE.getDEFAULT_HARD_LIMIT();
    }

    public final int getMessageSoftTokenLimit(@NotNull LLMProfileID llmProfileId) {
        Intrinsics.checkNotNullParameter((Object)llmProfileId, (String)"llmProfileId");
        return this.getHardTokenLimit(llmProfileId) / 4;
    }

    public final int getMessageSoftTokenLimit2() {
        return 2000;
    }

    @NotNull
    public final List<LLMProfileID> getMODELS_WITH_EXPERIMENTAL_MULTIPLIER() {
        return MODELS_WITH_EXPERIMENTAL_MULTIPLIER;
    }

    public final int getCodeDependencyTokenLimit() {
        return Registry.Companion.intValue("llm.chat.context.code.items.token.limit");
    }

    public final int getCodeDependencyDepthLimit() {
        return Registry.Companion.intValue("llm.chat.context.dependencies.depth");
    }

    @Deprecated(message="Use ChatTokenLimits#getTokenLimitPerToolCall instead")
    public final int getFunctionResponseTokenLimit() {
        return Registry.Companion.intValue("llm.smartChat.function.response.token.limit");
    }

    public final int getMaxFileSize() {
        return 204800;
    }

    public final int getMaxFileLengthWithoutSummarization() {
        return 10000;
    }

    public final int getCommitChatMessageTokenLimit() {
        return 8192;
    }

    public final int getCommitMessageCompletionTokenLimit() {
        return 2048;
    }

    public final int getChatMessageCompletionTokenLimit() {
        return 1024;
    }

    public final int getChatSessionSummaryTokenLimit() {
        return 32768;
    }

    public final int getExperimentalHardLimitMultiplyer() {
        return 4;
    }

    public final int getExperimentalSoftLimitMultiplyer() {
        return 4;
    }

    public final int getCodeGenerationTokenLimitMultiplier() {
        return 4;
    }
}

