/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.diff.groupedDiff.commit;

import com.intellij.ml.llm.vcs.diff.groupedDiff.ChangesGroup;
import com.intellij.ml.llm.vcs.diff.groupedDiff.FileChangeSubset;
import com.intellij.ml.llm.vcs.diff.groupedDiff.GroupedRange;
import com.intellij.ml.llm.vcs.diff.groupedDiff.commit.AIChangeListsGroupedDiffData;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerSerialization;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@State(name="AIDiffStorage", storages={@Storage(value="$WORKSPACE_FILE$")})
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/commit/AIDiffStateStorage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "state", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/commit/AIChangeListsGroupedDiffData;", "getState", "()Lcom/intellij/ml/llm/vcs/diff/groupedDiff/commit/AIChangeListsGroupedDiffData;", "setState", "(Lcom/intellij/ml/llm/vcs/diff/groupedDiff/commit/AIChangeListsGroupedDiffData;)V", "writeDiffData", "currentState", "loadState", "", "readDiffData", "Companion", "intellij.ml.llm.vcs.diff"})
public final class AIDiffStateStorage
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private AIChangeListsGroupedDiffData state;
    @NotNull
    private static final String EL_ROOT = "AIDiffStorage";
    @NotNull
    private static final String EL_GROUPS = "groups";
    @NotNull
    private static final String EL_GROUP = "group";
    @NotNull
    private static final String EL_FILES = "files";
    @NotNull
    private static final String EL_FILE = "file";
    @NotNull
    private static final String EL_RANGES = "ranges";
    @NotNull
    private static final String EL_RANGE = "range";
    @NotNull
    private static final String EL_CHANGE = "change";
    @NotNull
    private static final String ATTR_CHANGE_LIST_ID = "changeListId";
    @NotNull
    private static final String ATTR_ID = "id";
    @NotNull
    private static final String ATTR_NAME = "name";
    @NotNull
    private static final String ATTR_DESCRIPTION = "description";
    @NotNull
    private static final String ATTR_IMPORTANCE = "importance";
    @NotNull
    private static final String ATTR_SUMMARY = "summary";
    @NotNull
    private static final String ATTR_IS_PENDING = "isPending";
    @NotNull
    private static final String ATTR_AFTER_LINE1 = "afterLine1";
    @NotNull
    private static final String ATTR_AFTER_LINE2 = "afterLine2";
    @NotNull
    private static final String ATTR_BEFORE_LINE1 = "beforeLine1";
    @NotNull
    private static final String ATTR_BEFORE_LINE2 = "beforeLine2";
    @NotNull
    private static final String ATTR_GROUP_ID = "groupId";

    public AIDiffStateStorage(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Nullable
    public final AIChangeListsGroupedDiffData getState() {
        return this.state;
    }

    public final void setState(@Nullable AIChangeListsGroupedDiffData aIChangeListsGroupedDiffData) {
        this.state = aIChangeListsGroupedDiffData;
    }

    @NotNull
    public Element getState() {
        Element root = new Element(EL_ROOT);
        AIChangeListsGroupedDiffData currentState = this.state;
        if (currentState != null) {
            root.setAttribute(ATTR_ID, String.valueOf(currentState.getId()));
            Element groupsEl = this.writeDiffData(currentState);
            root.addContent(groupsEl);
        }
        return root;
    }

    private final Element writeDiffData(AIChangeListsGroupedDiffData currentState) {
        Element groupsEl = new Element(EL_GROUPS);
        for (Map.Entry<String, ChangesGroup> entry : currentState.getGroups().entrySet()) {
            String changeListId = entry.getKey();
            ChangesGroup group = entry.getValue();
            Element groupEl = new Element(EL_GROUP);
            groupEl.setAttribute(ATTR_CHANGE_LIST_ID, changeListId);
            groupEl.setAttribute(ATTR_ID, String.valueOf(group.getId()));
            groupEl.setAttribute(ATTR_NAME, group.getName());
            groupEl.setAttribute(ATTR_DESCRIPTION, group.getDescription());
            groupEl.setAttribute(ATTR_IMPORTANCE, String.valueOf(group.getImportance()));
            Element filesEl = new Element(EL_FILES);
            for (FileChangeSubset fileSubset : group.getFiles()) {
                Element changeEl;
                Element fileEl = new Element(EL_FILE);
                fileEl.setAttribute(ATTR_SUMMARY, fileSubset.getSummary());
                fileEl.setAttribute(ATTR_IMPORTANCE, String.valueOf(fileSubset.getImportance()));
                fileEl.setAttribute(ATTR_IS_PENDING, String.valueOf(fileSubset.isPending()));
                Intrinsics.checkNotNullExpressionValue((Object)ChangeListManagerSerialization.writeChange((Change)fileSubset.getChange()), (String)"writeChange(...)");
                fileEl.addContent(changeEl);
                List<GroupedRange> ranges2 = fileSubset.getChanges();
                if (ranges2 != null) {
                    Element rangesEl = new Element(EL_RANGES);
                    for (GroupedRange r : ranges2) {
                        Element rEl = new Element(EL_RANGE);
                        rEl.setAttribute(ATTR_AFTER_LINE1, String.valueOf(r.getAfterLine1()));
                        rEl.setAttribute(ATTR_AFTER_LINE2, String.valueOf(r.getAfterLine2()));
                        rEl.setAttribute(ATTR_BEFORE_LINE1, String.valueOf(r.getBeforeLine1()));
                        rEl.setAttribute(ATTR_BEFORE_LINE2, String.valueOf(r.getBeforeLine2()));
                        rEl.setAttribute(ATTR_GROUP_ID, r.getGroupId());
                        rangesEl.addContent(rEl);
                    }
                    fileEl.addContent(rangesEl);
                }
                filesEl.addContent(fileEl);
            }
            groupEl.addContent(filesEl);
            groupsEl.addContent(groupEl);
        }
        return groupsEl;
    }

    public void loadState(@NotNull Element state2) {
        AIChangeListsGroupedDiffData diffData;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.state = diffData = this.readDiffData(state2);
    }

    private final AIChangeListsGroupedDiffData readDiffData(Element state2) {
        Element element2 = state2.getChild(EL_GROUPS);
        if (element2 == null) {
            AIDiffStateStorage $this$readDiffData_u24lambda_u240 = this;
            boolean bl = false;
            return null;
        }
        Element groupsEl = element2;
        Object object = state2.getAttributeValue(ATTR_ID);
        long stateId = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 0L;
        LinkedHashMap groupsById = new LinkedHashMap();
        for (Element groupEl : groupsEl.getChildren(EL_GROUP)) {
            String changeListId;
            String string;
            String name;
            if (groupEl.getAttributeValue(ATTR_CHANGE_LIST_ID) == null) continue;
            Object object2 = groupEl.getAttributeValue(ATTR_ID);
            if (object2 == null || (object2 = StringsKt.toIntOrNull((String)object2)) == null) {
                continue;
            }
            int groupId = (Integer)object2;
            String string2 = groupEl.getAttributeValue(ATTR_NAME);
            if (string2 == null) {
                string2 = name = "";
            }
            if ((string = groupEl.getAttributeValue(ATTR_DESCRIPTION)) == null) {
                string = "";
            }
            String description = string;
            Object object3 = groupEl.getAttributeValue(ATTR_IMPORTANCE);
            double importance = object3 != null && (object3 = StringsKt.toDoubleOrNull((String)object3)) != null ? (Double)object3 : 0.0;
            ArrayList<FileChangeSubset> files = new ArrayList<FileChangeSubset>();
            Element filesEl = groupEl.getChild(EL_FILES);
            if (filesEl != null) {
                for (Element fileEl : filesEl.getChildren(EL_FILE)) {
                    ArrayList<GroupedRange> arrayList;
                    boolean isPending;
                    String string3 = fileEl.getAttributeValue(ATTR_SUMMARY);
                    if (string3 == null) {
                        string3 = "";
                    }
                    String summary2 = string3;
                    Object object4 = fileEl.getAttributeValue(ATTR_IMPORTANCE);
                    double fImportance = object4 != null && (object4 = StringsKt.toDoubleOrNull((String)object4)) != null ? (Double)object4 : 0.0;
                    Object object5 = fileEl.getAttributeValue(ATTR_IS_PENDING);
                    boolean bl = isPending = object5 != null && (object5 = StringsKt.toBooleanStrictOrNull((String)object5)) != null ? (Boolean)object5 : false;
                    Element changeEl = fileEl.getChild(EL_CHANGE);
                    Change change = changeEl != null ? ChangeListManagerSerialization.readChange((Element)changeEl, (Project)this.project) : null;
                    if (change == null) continue;
                    Element rangesEl = fileEl.getChild(EL_RANGES);
                    if (rangesEl != null) {
                        ArrayList<GroupedRange> list = new ArrayList<GroupedRange>();
                        for (Element rEl : rangesEl.getChildren(EL_RANGE)) {
                            Object object6 = rEl.getAttributeValue(ATTR_AFTER_LINE1);
                            if (object6 == null || (object6 = StringsKt.toIntOrNull((String)object6)) == null) {
                                continue;
                            }
                            int after1 = (Integer)object6;
                            Object object7 = rEl.getAttributeValue(ATTR_AFTER_LINE2);
                            if (object7 == null || (object7 = StringsKt.toIntOrNull((String)object7)) == null) {
                                continue;
                            }
                            int after2 = (Integer)object7;
                            Object object8 = rEl.getAttributeValue(ATTR_BEFORE_LINE1);
                            if (object8 == null || (object8 = StringsKt.toIntOrNull((String)object8)) == null) {
                                continue;
                            }
                            int before1 = (Integer)object8;
                            Object object9 = rEl.getAttributeValue(ATTR_BEFORE_LINE2);
                            if (object9 == null || (object9 = StringsKt.toIntOrNull((String)object9)) == null) {
                                continue;
                            }
                            int before2 = (Integer)object9;
                            String string4 = rEl.getAttributeValue(ATTR_GROUP_ID);
                            if (string4 == null) {
                                string4 = "";
                            }
                            String gid = string4;
                            list.add(new GroupedRange(after1, after2, before1, before2, gid));
                        }
                        arrayList = list;
                    } else {
                        arrayList = null;
                    }
                    ArrayList<GroupedRange> ranges2 = arrayList;
                    files.add(new FileChangeSubset(change, (List<GroupedRange>)ranges2, summary2, fImportance, isPending));
                }
            }
            ((Map)groupsById).put(changeListId, new ChangesGroup(groupId, name, description, importance, (List<FileChangeSubset>)files));
        }
        AIChangeListsGroupedDiffData diffData = new AIChangeListsGroupedDiffData(stateId, groupsById, null, null, 12, null);
        return diffData;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0014\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/commit/AIDiffStateStorage$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/commit/AIDiffStateStorage;", "project", "Lcom/intellij/openapi/project/Project;", "EL_ROOT", "", "EL_GROUPS", "EL_GROUP", "EL_FILES", "EL_FILE", "EL_RANGES", "EL_RANGE", "EL_CHANGE", "ATTR_CHANGE_LIST_ID", "ATTR_ID", "ATTR_NAME", "ATTR_DESCRIPTION", "ATTR_IMPORTANCE", "ATTR_SUMMARY", "ATTR_IS_PENDING", "ATTR_AFTER_LINE1", "ATTR_AFTER_LINE2", "ATTR_BEFORE_LINE1", "ATTR_BEFORE_LINE2", "ATTR_GROUP_ID", "intellij.ml.llm.vcs.diff"})
    @SourceDebugExtension(value={"SMAP\nAIDiffStateStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIDiffStateStorage.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/commit/AIDiffStateStorage$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,176:1\n30#2,2:177\n*S KotlinDebug\n*F\n+ 1 AIDiffStateStorage.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/commit/AIDiffStateStorage$Companion\n*L\n17#1:177,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AIDiffStateStorage getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<AIDiffStateStorage> serviceClass$iv = AIDiffStateStorage.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (AIDiffStateStorage)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

