/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.ErrorList;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.FileNotInAnyGroupError;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.FileSummary;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.Group;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.GroupFileNotFoundError;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.GroupResponse;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.PatchInfo;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.TextFilePatchPrivacyWrapperKt;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u0006\u0010\u0018\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupsAnalysis;", "", "patchInfo", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/PatchInfo;", "groupResponse", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupResponse;", "errorList", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/ErrorList;", "<init>", "(Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/PatchInfo;Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupResponse;Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/ErrorList;)V", "getPatchInfo", "()Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/PatchInfo;", "getGroupResponse", "()Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupResponse;", "getErrorList", "()Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/ErrorList;", "groupList", "", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/Group;", "getGroupList", "()Ljava/util/List;", "buildFileSummaryMap", "", "validateAllFilesInGroups", "lastResortErrorFix", "Companion", "intellij.ml.llm.vcs.diff"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGroupsAnalysis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupsAnalysis.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupsAnalysis\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n774#2:160\n865#2,2:161\n1374#2:163\n1460#2,5:164\n1491#2:169\n1516#2,3:170\n1519#2,3:180\n774#2:183\n865#2,2:184\n774#2:186\n865#2,2:187\n1563#2:189\n1634#2,3:190\n1374#2:193\n1460#2,5:194\n1617#2,9:199\n1869#2:208\n1870#2:210\n1626#2:211\n774#2:212\n865#2,2:213\n1563#2:216\n1634#2,3:217\n382#3,7:173\n1#4:209\n1#4:215\n*S KotlinDebug\n*F\n+ 1 GroupsAnalysis.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupsAnalysis\n*L\n41#1:160\n41#1:161,2\n74#1:163\n74#1:164,5\n74#1:169\n74#1:170,3\n74#1:180,3\n76#1:183\n76#1:184,2\n103#1:186\n103#1:187,2\n111#1:189\n111#1:190,3\n118#1:193\n118#1:194,5\n119#1:199,9\n119#1:208\n119#1:210\n119#1:211\n122#1:212\n122#1:213,2\n129#1:216\n129#1:217,3\n74#1:173,7\n119#1:209\n*E\n"})
public final class GroupsAnalysis {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PatchInfo patchInfo;
    @NotNull
    private final GroupResponse groupResponse;
    @NotNull
    private final ErrorList errorList;
    @NotNull
    private final List<Group> groupList;

    private GroupsAnalysis(PatchInfo patchInfo, GroupResponse groupResponse, ErrorList errorList) {
        this.patchInfo = patchInfo;
        this.groupResponse = groupResponse;
        this.errorList = errorList;
        this.groupList = this.groupResponse.getGroups();
    }

    @NotNull
    public final PatchInfo getPatchInfo() {
        return this.patchInfo;
    }

    @NotNull
    public final GroupResponse getGroupResponse() {
        return this.groupResponse;
    }

    @NotNull
    public final ErrorList getErrorList() {
        return this.errorList;
    }

    @NotNull
    public final List<Group> getGroupList() {
        return this.groupList;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildFileSummaryMap() {
        for (Group group : this.groupList) {
            for (FileSummary fileSummary : group.getFiles()) {
                TextFilePatch matchingFile;
                TextFilePatch textFilePatch;
                Object v2;
                TextFilePatch it;
                Iterable iterable;
                PSString filePathName;
                PSString filePath;
                block13: {
                    char[] cArray = new char[]{'`'};
                    PSString pSString = fileSummary.getPath().trim(cArray);
                    cArray = new char[]{'\''};
                    filePath = pSString.trim(cArray);
                    filePathName = PSString.substringAfterLast$default((PSString)filePath, (String)"/", null, (int)2, null);
                    iterable = this.patchInfo.getFilePatches();
                    for (Object object : iterable) {
                        it = (TextFilePatch)object;
                        boolean bl = false;
                        String string = it.getAfterName();
                        if (string == null && (string = it.getBeforeName()) == null) {
                            string = "";
                        }
                        if (!Intrinsics.areEqual((Object)string, (Object)filePath.unwrap())) continue;
                        v2 = object;
                        break block13;
                    }
                    v2 = null;
                }
                if ((textFilePatch = (TextFilePatch)v2) == null) {
                    Object v5;
                    block14: {
                        iterable = this.patchInfo.getFilePatches();
                        for (Object object : iterable) {
                            it = (TextFilePatch)object;
                            boolean bl = false;
                            String string = it.getBeforeName();
                            if (string == null && (string = it.getAfterName()) == null) {
                                string = "";
                            }
                            if (!Intrinsics.areEqual((Object)string, (Object)filePath.unwrap())) continue;
                            v5 = object;
                            break block14;
                        }
                        v5 = null;
                    }
                    textFilePatch = v5;
                }
                if ((matchingFile = textFilePatch) == null) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = this.patchInfo.getFilePatches();
                    boolean $i$f$filter = false;
                    Iterable iterable2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        TextFilePatch it2 = (TextFilePatch)element$iv$iv;
                        boolean bl = false;
                        String string = it2.getAfterName();
                        if (string == null) {
                            string = "";
                        }
                        String toFileName = StringsKt.substringAfterLast$default((String)string, (char)'/', null, (int)2, null);
                        String string2 = it2.getBeforeName();
                        if (string2 == null) {
                            string2 = "";
                        }
                        String fromFileName = StringsKt.substringAfterLast$default((String)string2, (char)'/', null, (int)2, null);
                        if (!(Intrinsics.areEqual((Object)toFileName, (Object)filePathName.unwrap()) || Intrinsics.areEqual((Object)fromFileName, (Object)filePathName.unwrap()))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List matchingFilesByName = (List)destination$iv$iv;
                    if (matchingFilesByName.size() == 1) {
                        matchingFile = (TextFilePatch)CollectionsKt.first((List)matchingFilesByName);
                    }
                }
                if (matchingFile != null) {
                    fileSummary.setTextFilePatch(matchingFile);
                    continue;
                }
                this.errorList.addError(new GroupFileNotFoundError(group.getTitle(), filePath));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateAllFilesInGroups() {
        void $this$filterTo$iv$iv;
        void $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        List<TextFilePatch> allFiles = this.patchInfo.getFilePatches();
        Iterable $this$flatMap$iv = this.groupList;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Group)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((Group)it).getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            it = (FileSummary)element$iv$iv;
            boolean bl = false;
            TextFilePatch key$iv$iv = ((FileSummary)it).getTextFilePatch();
            Object object2 = destination$iv$iv;
            TextFilePatch key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object filesInGroups = destination$iv$iv;
        Iterable $this$filter$iv = allFiles;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextFilePatch file2 = (TextFilePatch)element$iv$iv;
            boolean bl = false;
            if (!(!filesInGroups.containsKey(file2))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List filesNotInGroups = (List)destination$iv$iv2;
        if (!((Collection)filesNotInGroups).isEmpty()) {
            for (TextFilePatch file3 : filesNotInGroups) {
                FileNotInAnyGroupError error = new FileNotInAnyGroupError(file3);
                this.errorList.addError(error);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GroupsAnalysis lastResortErrorFix() {
        void $this$filterTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Object newGroup;
        if (!this.errorList.hasErrors()) {
            return this;
        }
        List cleanedGroups = new ArrayList();
        for (Group group : this.groupList) {
            Collection<void> collection;
            Iterator $this$mapTo$iv$iv;
            void $this$map$iv;
            Object element$iv$iv2;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv = group.getFiles();
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                FileSummary it = (FileSummary)element$iv$iv2;
                boolean bl = false;
                if (!(it.getTextFilePatch() != null)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List recognizedFiles = (List)destination$iv$iv;
            Iterable $i$f$filter22 = recognizedFiles;
            PSString pSString = group.getSummary();
            PSString pSString2 = group.getReasoning();
            double d = group.getImportance();
            PSString pSString3 = group.getTitle();
            int n = group.getId();
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            element$iv$iv2 = $this$mapTo$iv$iv.iterator();
            while (element$iv$iv2.hasNext()) {
                void it;
                Object item$iv$iv = element$iv$iv2.next();
                FileSummary bl = (FileSummary)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it);
            }
            collection = (List)destination$iv$iv2;
            List list = CollectionsKt.toMutableList((Collection)collection);
            PSString pSString4 = pSString;
            PSString pSString5 = pSString2;
            double d2 = d;
            PSString pSString6 = pSString3;
            int n2 = n;
            newGroup = new Group(n2, pSString6, d2, pSString5, pSString4, list);
            cleanedGroups.add(newGroup);
        }
        Iterable $this$flatMap$iv = cleanedGroups;
        boolean $i$f$flatMap = false;
        newGroup = $this$flatMap$iv;
        Iterable<TextFilePatch> destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Group it = (Group)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            TextFilePatch it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
            boolean bl = false;
            FileSummary it = (FileSummary)element$iv$iv;
            boolean bl3 = false;
            if (it.getTextFilePatch() == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set filesAlreadyInGroups = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv = this.patchInfo.getFilePatches();
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Iterator destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextFilePatch it = (TextFilePatch)element$iv$iv;
            boolean bl = false;
            if (!(!filesAlreadyInGroups.contains(it))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List notGroupedFiles = (List)((Object)destination$iv$iv3);
        if (!((Collection)notGroupedFiles).isEmpty()) {
            void $this$mapTo$iv$iv;
            Object object;
            destination$iv$iv3 = ((Iterable)cleanedGroups).iterator();
            if (!destination$iv$iv3.hasNext()) {
                object = null;
            } else {
                Object it = (Group)destination$iv$iv3.next();
                boolean bl = false;
                it = ((Group)it).getId();
                while (destination$iv$iv3.hasNext()) {
                    Object it2 = (Group)destination$iv$iv3.next();
                    iterable = false;
                    if (it.compareTo(it2 = (Comparable)Integer.valueOf(((Group)it2).getId())) >= 0) continue;
                    it = it2;
                }
                object = it;
            }
            Integer n = (Integer)object;
            int uniqueId = (n != null ? n : 0) + 1;
            double minimalImportance = 0.0;
            Iterable $this$map$iv = notGroupedFiles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FileSummary fileSummary;
                void patch;
                TextFilePatch bl3 = (TextFilePatch)item$iv$iv;
                Collection collection = destination$iv$iv4;
                boolean bl = false;
                PSString path = TextFilePatchPrivacyWrapperKt.getFileNamePS((TextFilePatch)patch);
                FileSummary it = fileSummary = new FileSummary(path, ConstantsKt.getPrivacyConst((String)""), 0.0);
                boolean bl5 = false;
                it.setTextFilePatch((TextFilePatch)patch);
                collection.add(fileSummary);
            }
            List otherFiles = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv4));
            Group otherGroup = new Group(uniqueId, ConstantsKt.getPrivacyConst((String)"Other changes"), minimalImportance, ConstantsKt.getPrivacyConst((String)""), ConstantsKt.getPrivacyConst((String)"Other changes"), otherFiles);
            cleanedGroups.add(otherGroup);
        }
        GroupResponse newGroupResponse = new GroupResponse(this.groupResponse.getSummary(), this.groupResponse.getPreliminaryAnalysis(), CollectionsKt.toList((Iterable)cleanedGroups), this.groupResponse.getOriginalResponse(), this.groupResponse.getExecutionTime());
        this.errorList.clear();
        return Companion.analyzeGroups(this.patchInfo, newGroupResponse, this.errorList);
    }

    public /* synthetic */ GroupsAnalysis(PatchInfo patchInfo, GroupResponse groupResponse, ErrorList errorList, DefaultConstructorMarker $constructor_marker) {
        this(patchInfo, groupResponse, errorList);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupsAnalysis$Companion;", "", "<init>", "()V", "analyzeGroups", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupsAnalysis;", "patchInfo", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/PatchInfo;", "groupResponse", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupResponse;", "errorList", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/ErrorList;", "intellij.ml.llm.vcs.diff"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GroupsAnalysis analyzeGroups(@NotNull PatchInfo patchInfo, @NotNull GroupResponse groupResponse, @NotNull ErrorList errorList) {
            Intrinsics.checkNotNullParameter((Object)patchInfo, (String)"patchInfo");
            Intrinsics.checkNotNullParameter((Object)groupResponse, (String)"groupResponse");
            Intrinsics.checkNotNullParameter((Object)errorList, (String)"errorList");
            GroupsAnalysis result2 = new GroupsAnalysis(patchInfo, groupResponse, errorList, null);
            result2.buildFileSummaryMap();
            result2.validateAllFilesInGroups();
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

