/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.diff.groupedDiff.ui;

import com.intellij.ml.llm.vcs.diff.groupedDiff.ChangesGroup;
import com.intellij.ml.llm.vcs.diff.groupedDiff.ChangesGroupKt;
import com.intellij.ml.llm.vcs.diff.groupedDiff.FileChangeSubset;
import com.intellij.ml.llm.vcs.diff.groupedDiff.LLMVcsDiffBundle;
import com.intellij.ml.llm.vcs.diff.groupedDiff.commit.AIChangeListsGroupedDiffData;
import com.intellij.ml.llm.vcs.diff.groupedDiff.commit.AIDiffSplitService;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListDecorator;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.platform.vcs.changes.ChangeListManagerState;
import com.intellij.platform.vcs.impl.shared.changes.ChangeListsViewModel;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/ui/AiChangeListNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserChangeListNode;", "project", "Lcom/intellij/openapi/project/Project;", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "listRemoteState", "Lcom/intellij/openapi/vcs/changes/ui/ChangeListRemoteState;", "aiChangeListsData", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/commit/AIChangeListsGroupedDiffData;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/LocalChangeList;Lcom/intellij/openapi/vcs/changes/ui/ChangeListRemoteState;Lcom/intellij/ml/llm/vcs/diff/groupedDiff/commit/AIChangeListsGroupedDiffData;)V", "getAiChangeListsData", "()Lcom/intellij/ml/llm/vcs/diff/groupedDiff/commit/AIChangeListsGroupedDiffData;", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "renderWithImportanceIcon", "getImportanceFor", "", "list", "(Lcom/intellij/openapi/vcs/changes/LocalChangeList;)Ljava/lang/Double;", "compareUserObjects", "", "o2", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "intellij.ml.llm.vcs.diff"})
@SourceDebugExtension(value={"SMAP\nAiChangeListNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiChangeListNode.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/ui/AiChangeListNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,92:1\n1761#2,3:93\n30#3,2:96\n*S KotlinDebug\n*F\n+ 1 AiChangeListNode.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/ui/AiChangeListNode\n*L\n30#1:93,3\n50#1:96,2\n*E\n"})
public final class AiChangeListNode
extends ChangesBrowserChangeListNode {
    @NotNull
    private final Project project;
    @NotNull
    private final LocalChangeList changeList;
    @NotNull
    private final ChangeListRemoteState listRemoteState;
    @NotNull
    private final AIChangeListsGroupedDiffData aiChangeListsData;

    public AiChangeListNode(@NotNull Project project2, @NotNull LocalChangeList changeList, @NotNull ChangeListRemoteState listRemoteState, @NotNull AIChangeListsGroupedDiffData aiChangeListsData) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        Intrinsics.checkNotNullParameter((Object)listRemoteState, (String)"listRemoteState");
        Intrinsics.checkNotNullParameter((Object)aiChangeListsData, (String)"aiChangeListsData");
        super(project2, (ChangeList)changeList, listRemoteState);
        this.project = project2;
        this.changeList = changeList;
        this.listRemoteState = listRemoteState;
        this.aiChangeListsData = aiChangeListsData;
    }

    @NotNull
    public final AIChangeListsGroupedDiffData getAiChangeListsData() {
        return this.aiChangeListsData;
    }

    public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
        boolean hasPendingFiles;
        Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
        Object object = this.aiChangeListsData.getGroups().get(this.changeList.getId());
        if (object != null && (object = ((ChangesGroup)object).getFiles()) != null) {
            boolean bl;
            block17: {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv = iterator.next();
                        FileChangeSubset it = (FileChangeSubset)element$iv;
                        boolean bl2 = false;
                        if (!it.isPending()) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            v2 = bl;
        } else {
            v2 = hasPendingFiles = false;
        }
        if (this.userObject instanceof LocalChangeList) {
            Object object2 = this.userObject;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.changes.LocalChangeList");
            LocalChangeList localChangeList = (LocalChangeList)object2;
            String string = localChangeList.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String listName = string;
            renderer2.appendTextWithIssueLinks(" " + listName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.appendCount((ColoredTreeCellRenderer)renderer2);
            for (ChangeListDecorator decorator : ChangeListDecorator.getDecorators((Project)this.project)) {
                decorator.decorateChangeList(localChangeList, (ColoredTreeCellRenderer)renderer2, selected, expanded, hasFocus);
            }
            ChangeListManagerState clManagerState = (ChangeListManagerState)ChangeListsViewModel.Companion.getInstance(this.project).getChangeListManagerState().getValue();
            if (hasPendingFiles) {
                renderer2.append(FontUtil.spaceAndThinSpace() + LLMVcsDiffBundle.message("grouped.diff.loading", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else if (clManagerState instanceof ChangeListManagerState.Frozen) {
                renderer2.append(FontUtil.spaceAndThinSpace() + ((ChangeListManagerState.Frozen)clManagerState).getReason(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else if (clManagerState instanceof ChangeListManagerState.Updating) {
                this.appendUpdatingState(renderer2);
            } else {
                ComponentManager $this$service$iv = (ComponentManager)this.project;
                boolean $i$f$service = false;
                Class<AIDiffSplitService> serviceClass$iv = AIDiffSplitService.class;
                Object object3 = $this$service$iv.getService(serviceClass$iv);
                if (object3 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                AIDiffSplitService service = (AIDiffSplitService)object3;
                if (service.getTimerForReadyIcon().getShowReadyIcon()) {
                    renderer2.append(FontUtil.spaceAndThinSpace() + LLMVcsDiffBundle.message("grouped.diff.ready", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }
            if (!this.listRemoteState.allUpToDate()) {
                renderer2.append(FontUtil.spaceAndThinSpace());
                renderer2.append(VcsBundle.message((String)"changes.nodetitle.have.outdated.files", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        } else {
            super.render(renderer2, selected, expanded, hasFocus);
        }
        this.renderWithImportanceIcon(renderer2);
    }

    private final void renderWithImportanceIcon(ChangesBrowserNodeRenderer renderer2) {
        ChangesGroup changesGroup = this.aiChangeListsData.getGroups().get(this.changeList.getId());
        Double importance = changesGroup != null ? Double.valueOf(changesGroup.getImportance()) : null;
        Icon icon2 = ChangesGroupKt.getIconByImportance(importance);
        renderer2.setIcon(icon2);
        renderer2.setToolTipText(ChangesGroupKt.getTooltipByImportance(importance));
    }

    private final Double getImportanceFor(LocalChangeList list) {
        ChangesGroup changesGroup = this.aiChangeListsData.getGroups().get(list.getId());
        return changesGroup != null ? Double.valueOf(changesGroup.getImportance()) : null;
    }

    public int compareUserObjects(@NotNull ChangeList o2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        Object l1 = this.userObject;
        if (l1 instanceof LocalChangeList && o2 instanceof LocalChangeList) {
            int byWeight;
            Double w1 = this.getImportanceFor((LocalChangeList)l1);
            Double w2 = this.getImportanceFor((LocalChangeList)o2);
            if (w1 != null && w2 != null && (byWeight = -Double.compare(w1, w2)) != 0) {
                return byWeight;
            }
        }
        return super.compareUserObjects(o2);
    }
}

