/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.markdown;

import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.ml.llm.core.NotificationsKt;
import com.intellij.ml.llm.core.statistics.CommonLoggerServiceKt;
import com.intellij.ml.llm.core.statistics.CompositeStatisticsIdeActivity;
import com.intellij.ml.llm.core.statistics.ScoreResult;
import com.intellij.ml.llm.vcs.LLMVcsBundle;
import com.intellij.ml.llm.vcs.markdown.ScoreLinkProvider;
import com.intellij.ml.llm.vcs.summary.GenerateCommitSummary;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.ui.preview.BrowserPipe;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000-\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/vcs/markdown/ScoreLinkProvider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "<init>", "(Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;)V", "handler", "com/intellij/ml/llm/vcs/markdown/ScoreLinkProvider$handler$1", "Lcom/intellij/ml/llm/vcs/markdown/ScoreLinkProvider$handler$1;", "scoreLike", "", "link", "", "dispose", "", "Provider", "intellij.ml.llm.vcs.markdown"})
public final class ScoreLinkProvider
implements MarkdownBrowserPreviewExtension {
    @NotNull
    private final MarkdownHtmlPanel panel;
    @NotNull
    private final handler.1 handler;

    public ScoreLinkProvider(@NotNull MarkdownHtmlPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        this.panel = panel2;
        this.handler = new BrowserPipe.Handler(this){
            final /* synthetic */ ScoreLinkProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean processMessageReceived(String data2) {
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                return ScoreLinkProvider.access$scoreLike(this.this$0, data2);
            }
        };
        BrowserPipe browserPipe = this.panel.getBrowserPipe();
        if (browserPipe != null) {
            browserPipe.subscribe("openLink", (BrowserPipe.Handler)this.handler);
        }
        Disposer.register((Disposable)((Disposable)this), () -> ScoreLinkProvider._init_$lambda$0(this));
        if (this.panel instanceof MarkdownHtmlPanelEx) {
            ((MarkdownHtmlPanelEx)this.panel).putUserData(MarkdownHtmlPanelEx.Companion.getDO_NOT_USE_LINK_OPENER(), (Object)true);
        }
    }

    private final boolean scoreLike(String link2) {
        if (!Registry.Companion.is("markdown.open.vcs.log.link")) {
            return true;
        }
        URI uri = URI.create(link2);
        if (!Intrinsics.areEqual((Object)uri.getScheme(), (Object)"log") || !Intrinsics.areEqual((Object)uri.getAuthority(), (Object)"score")) {
            return true;
        }
        Project project2 = this.panel.getProject();
        if (project2 == null) {
            return true;
        }
        Project project3 = project2;
        Map parameters = new QueryStringDecoder(uri).parameters();
        Object object = (List)parameters.get("type");
        if (object == null || (object = (String)CollectionsKt.first((List)object)) == null) {
            return true;
        }
        Object type2 = object;
        Object object2 = (List)parameters.get("all_summary");
        if (object2 == null || (object2 = (String)CollectionsKt.first((List)object2)) == null) {
            return true;
        }
        boolean isAllSummary = Boolean.parseBoolean((String)object2);
        Object object3 = (List)parameters.get("generated_message_length");
        if (object3 == null || (object3 = (String)CollectionsKt.first((List)object3)) == null) {
            return true;
        }
        int generatedMessageLength = Integer.parseInt((String)object3);
        CompositeStatisticsIdeActivity compositeStatisticsIdeActivity = GenerateCommitSummary.Companion.getActivity(project3);
        if (compositeStatisticsIdeActivity == null) {
            return true;
        }
        CompositeStatisticsIdeActivity activity2 = compositeStatisticsIdeActivity;
        activity2.scored(Intrinsics.areEqual((Object)type2, (Object)"like") ? ScoreResult.YES : ScoreResult.NO, () -> ScoreLinkProvider.scoreLike$lambda$0(isAllSummary, generatedMessageLength));
        Notification notification2 = NotificationsKt.createNotificationGroup().createNotification(LLMVcsBundle.message("action.ai.generated.summary.dialog.title.score", new Object[0]), LLMVcsBundle.message("action.ai.generated.summary.dialog.message.your.score.saved", new Object[0]), NotificationType.INFORMATION);
        notification2.notify(project3);
        new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)FileEditorManager.getInstance((Project)project3).getSelectedEditor()).addRequest(() -> ScoreLinkProvider.scoreLike$lambda$1(notification2), 3000);
        return false;
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(ScoreLinkProvider this$0) {
        block0: {
            BrowserPipe browserPipe = this$0.panel.getBrowserPipe();
            if (browserPipe == null) break block0;
            browserPipe.removeSubscription("openLink", (BrowserPipe.Handler)this$0.handler);
        }
    }

    private static final List scoreLike$lambda$0(boolean $isAllSummary, int $generatedMessageLength) {
        Object[] objectArray = new EventPair[]{CommonLoggerServiceKt.getALL_SUMMARY_SCORE().with((Object)$isAllSummary)};
        CollectionsKt.arrayListOf((Object[])objectArray);
        objectArray = new EventPair[]{CommonLoggerServiceKt.getGENERATED_SUMMARY_MESSAGE_LENGTH().with((Object)$generatedMessageLength)};
        return CollectionsKt.arrayListOf((Object[])objectArray);
    }

    private static final void scoreLike$lambda$1(Notification $notification) {
        $notification.expire();
    }

    public static final /* synthetic */ boolean access$scoreLike(ScoreLinkProvider $this, String link2) {
        return $this.scoreLike(link2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/vcs/markdown/ScoreLinkProvider$Provider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Provider;", "<init>", "()V", "createBrowserExtension", "Lcom/intellij/ml/llm/vcs/markdown/ScoreLinkProvider;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "intellij.ml.llm.vcs.markdown"})
    public static final class Provider
    implements MarkdownBrowserPreviewExtension.Provider {
        @Nullable
        public ScoreLinkProvider createBrowserExtension(@NotNull MarkdownHtmlPanel panel2) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            VirtualFile virtualFile2 = panel2.getVirtualFile();
            if (!(virtualFile2 != null ? Intrinsics.areEqual((Object)virtualFile2.getUserData(GenerateCommitSummary.Companion.getSUMMARY_LLM_MARKDOWN_EDITOR()), (Object)true) : false)) {
                return null;
            }
            return new ScoreLinkProvider(panel2);
        }
    }
}

