/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.voice;

import com.intellij.ml.llm.voice.models.TranscriptionModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ApplicationKt;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\"\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "isVoiceEnabled", "", "()Z", "transcriptionModel", "Lcom/intellij/ml/llm/voice/models/TranscriptionModel;", "getTranscriptionModel", "()Lcom/intellij/ml/llm/voice/models/TranscriptionModel;", "micInactivityTimeoutSec", "", "getMicInactivityTimeoutSec", "()I", "intellij.ml.llm.voice"})
@SourceDebugExtension(value={"SMAP\nregistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 registry.kt\ncom/intellij/ml/llm/voice/RegistryKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,34:1\n57#2:35\n35#2,2:36\n*S KotlinDebug\n*F\n+ 1 registry.kt\ncom/intellij/ml/llm/voice/RegistryKt\n*L\n8#1:35\n8#1:36,2\n*E\n"})
public final class RegistryKt {
    @NotNull
    private static final Logger logger;

    public static final boolean isVoiceEnabled() {
        return ApplicationKt.getApplication().isInternal() && Registry.Companion.is("com.intellij.ml.llm.voice.transcription.enabled");
    }

    @NotNull
    public static final TranscriptionModel getTranscriptionModel() {
        TranscriptionModel transcriptionModel;
        String string = Registry.Companion.get("com.intellij.ml.llm.voice.transcription.model").getSelectedOption();
        if (string == null) {
            throw new IllegalStateException("Value for 'com.intellij.ml.llm.voice.transcription.model' is null".toString());
        }
        String stringValue = string;
        try {
            transcriptionModel = TranscriptionModel.valueOf(stringValue);
        }
        catch (Throwable throwable) {
            logger.warn("Invalid value for registry key 'com.intellij.ml.llm.voice.transcription.model': " + stringValue);
            transcriptionModel = TranscriptionModel.WHISPER_1;
        }
        return transcriptionModel;
    }

    public static final int getMicInactivityTimeoutSec() {
        int n;
        try {
            n = Registry.Companion.intValue("com.intellij.ml.llm.voice.mic.inactivity.timeout.sec");
        }
        catch (Throwable throwable) {
            logger.warn("Invalid value for registry key 'com.intellij.ml.llm.voice.mic.inactivity.timeout.sec'");
            n = 30;
        }
        return n;
    }

    static {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RegistryKt.logger = logger;
    }
}

