/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.api.IndicesKt;
import org.jetbrains.kotlinx.dataframe.api.SelectKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.columns.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.impl.DataFrameSize;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a{\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00040\u00052N\u0010\u0006\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\b\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u00040\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\f0\u0007j\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u0003`\u000e\u00a2\u0006\u0002\b\rH\u0086\u0002\u001aT\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0005\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u00052\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u00030\u0010j\u0002`\u00112\u001e\u0010\u0012\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u00030\u0010j\u0002`\u00110\u0013\"\u0006\u0012\u0002\b\u00030\u0010H\u0086\u0002\u00a2\u0006\u0002\u0010\u0014\u001a@\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0005\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u000f\u001a\u00020\u00152\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0013\"\u00020\u0015H\u0086\u0002\u00a2\u0006\u0002\u0010\u0016\u001a-\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0005\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018H\u0086\u0002\u001a\u0012\u0010&\u001a\u00020'*\n\u0012\u0002\b\u00030\u0005j\u0002`\u001f\"\u001c\u0010\u0019\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030\u001b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\" \u0010\u001e\u001a\u00020\u001a*\n\u0012\u0002\b\u00030\u0005j\u0002`\u001f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\" \u0010\"\u001a\u00020#*\n\u0012\u0002\b\u00030\u0005j\u0002`\u001f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\" \u0010&\u001a\u00020'*\n\u0012\u0002\b\u00030\u0005j\u0002`\u001f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006*"}, d2={"get", "", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "C", "T", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "columns", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/api/ColumnsSelectionDsl;", "Lkotlin/ParameterName;", "name", "it", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnsResolver;", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/dataframe/ColumnsSelector;", "first", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "Lorg/jetbrains/kotlinx/dataframe/AnyColumnReference;", "other", "", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;[Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "columnRange", "Lkotlin/ranges/ClosedRange;", "ncol", "", "Lorg/jetbrains/kotlinx/dataframe/ColumnsContainer;", "getNcol", "(Lorg/jetbrains/kotlinx/dataframe/ColumnsContainer;)I", "nrow", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "getNrow", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;)I", "indices", "Lkotlin/ranges/IntRange;", "getIndices", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;)Lkotlin/ranges/IntRange;", "size", "Lorg/jetbrains/kotlinx/dataframe/impl/DataFrameSize;", "getSize", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;)Lorg/jetbrains/kotlinx/dataframe/impl/DataFrameSize;", "core"})
public final class DataFrameKt {
    @NotNull
    public static final <T, C> List<DataColumn<C>> get(@NotNull DataFrame<? extends T> $this$get, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<? extends C>> columns2) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        return $this$get.get(columns2);
    }

    @NotNull
    public static final <T> DataFrame<T> get(@NotNull DataFrame<? extends T> $this$get, @NotNull ColumnReference<?> first, ColumnReference<?> ... other) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(first, (String)"first");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return SelectKt.select($this$get, (arg_0, arg_1) -> DataFrameKt.get$lambda$0(first, other, arg_0, arg_1));
    }

    @NotNull
    public static final <T> DataFrame<T> get(@NotNull DataFrame<? extends T> $this$get, @NotNull String first, String ... other) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return SelectKt.select($this$get, (arg_0, arg_1) -> DataFrameKt.get$lambda$1(first, other, arg_0, arg_1));
    }

    @NotNull
    public static final <T> DataFrame<T> get(@NotNull DataFrame<? extends T> $this$get, @NotNull ClosedRange<String> columnRange) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(columnRange, (String)"columnRange");
        return SelectKt.select($this$get, (arg_0, arg_1) -> DataFrameKt.get$lambda$2(columnRange, arg_0, arg_1));
    }

    public static final int getNcol(@NotNull ColumnsContainer<?> $this$ncol) {
        Intrinsics.checkNotNullParameter($this$ncol, (String)"<this>");
        return $this$ncol.columnsCount();
    }

    public static final int getNrow(@NotNull DataFrame<?> $this$nrow) {
        Intrinsics.checkNotNullParameter($this$nrow, (String)"<this>");
        return $this$nrow.rowsCount();
    }

    @NotNull
    public static final IntRange getIndices(@NotNull DataFrame<?> $this$indices) {
        Intrinsics.checkNotNullParameter($this$indices, (String)"<this>");
        return IndicesKt.indices($this$indices);
    }

    @NotNull
    public static final DataFrameSize getSize(@NotNull DataFrame<?> $this$size) {
        Intrinsics.checkNotNullParameter($this$size, (String)"<this>");
        return DataFrameKt.size($this$size);
    }

    @NotNull
    public static final DataFrameSize size(@NotNull DataFrame<?> $this$size) {
        Intrinsics.checkNotNullParameter($this$size, (String)"<this>");
        return new DataFrameSize(DataFrameKt.getNcol((ColumnsContainer)$this$size), DataFrameKt.getNrow($this$size));
    }

    private static final ColumnsResolver get$lambda$0(ColumnReference $first, ColumnReference[] $other, ColumnsSelectionDsl $this$select, ColumnsSelectionDsl it) {
        Intrinsics.checkNotNullParameter((Object)$this$select, (String)"$this$select");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConstructorsKt.toColumnSetColumnReference(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)$first), (Object[])$other));
    }

    private static final ColumnsResolver get$lambda$1(String $first, String[] $other, ColumnsSelectionDsl $this$select, ColumnsSelectionDsl it) {
        Intrinsics.checkNotNullParameter((Object)$this$select, (String)"$this$select");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConstructorsKt.toColumnSetString(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)$first), (Object[])$other));
    }

    private static final ColumnsResolver get$lambda$2(ClosedRange $columnRange, ColumnsSelectionDsl $this$select, ColumnsSelectionDsl it) {
        Intrinsics.checkNotNullParameter((Object)$this$select, (String)"$this$select");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $this$select.rangeTo((String)((Object)$columnRange.getStart()), (String)((Object)$columnRange.getEndInclusive()));
    }
}

