/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.api;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.DataRowKt;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.api.DropKt;
import org.jetbrains.kotlinx.dataframe.api.FirstKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumnKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a&\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a&\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00062\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a`\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00062B\u0010\b\u001a>\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\n\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u00020\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tj\b\u0012\u0004\u0012\u0002H\u0002`\u0010\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0011"}, d2={"take", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "T", "n", "", "takeLast", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "takeWhile", "predicate", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lkotlin/ParameterName;", "name", "it", "", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/dataframe/RowFilter;", "core"})
@SourceDebugExtension(value={"SMAP\ntake.kt\nKotlin\n*S Kotlin\n*F\n+ 1 take.kt\norg/jetbrains/kotlinx/dataframe/api/TakeKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,376:1\n1#2:377\n*E\n"})
public final class TakeKt {
    @NotNull
    public static final <T> DataColumn<T> take(@NotNull DataColumn<? extends T> $this$take, int n) {
        Intrinsics.checkNotNullParameter($this$take, (String)"<this>");
        return n == 0 ? $this$take.get(CollectionsKt.emptyList()) : (n >= BaseColumnKt.getSize((BaseColumn)$this$take) ? $this$take : $this$take.get(RangesKt.until((int)0, (int)n)));
    }

    @NotNull
    public static final <T> DataColumn<T> takeLast(@NotNull DataColumn<? extends T> $this$takeLast, int n) {
        Intrinsics.checkNotNullParameter($this$takeLast, (String)"<this>");
        return DropKt.drop($this$takeLast, BaseColumnKt.getSize((BaseColumn)$this$takeLast) - n);
    }

    public static /* synthetic */ DataColumn takeLast$default(DataColumn dataColumn, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return TakeKt.takeLast(dataColumn, n);
    }

    @NotNull
    public static final <T> DataFrame<T> take(@NotNull DataFrame<? extends T> $this$take, int n) {
        Intrinsics.checkNotNullParameter($this$take, (String)"<this>");
        if (!(n >= 0)) {
            boolean bl = false;
            String string = "Requested rows count " + n + " is less than zero.";
            throw new IllegalArgumentException(string.toString());
        }
        return DataFrameGetKt.getRows($this$take, RangesKt.until((int)0, (int)RangesKt.coerceAtMost((int)n, (int)DataFrameKt.getNrow($this$take))));
    }

    @NotNull
    public static final <T> DataFrame<T> takeLast(@NotNull DataFrame<? extends T> $this$takeLast, int n) {
        Intrinsics.checkNotNullParameter($this$takeLast, (String)"<this>");
        if (!(n >= 0)) {
            boolean bl = false;
            String string = "Requested rows count " + n + " is less than zero.";
            throw new IllegalArgumentException(string.toString());
        }
        return DropKt.drop($this$takeLast, RangesKt.coerceAtLeast((int)(DataFrameKt.getNrow($this$takeLast) - n), (int)0));
    }

    public static /* synthetic */ DataFrame takeLast$default(DataFrame dataFrame, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return TakeKt.takeLast(dataFrame, n);
    }

    @NotNull
    public static final <T> DataFrame<T> takeWhile(@NotNull DataFrame<? extends T> $this$takeWhile, @NotNull Function2<? super DataRow<? extends T>, ? super DataRow<? extends T>, Boolean> predicate) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter($this$takeWhile, (String)"<this>");
                Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                object = FirstKt.firstOrNull($this$takeWhile, (arg_0, arg_1) -> TakeKt.takeWhile$lambda$2(predicate, arg_0, arg_1));
                if (object == null) break block2;
                DataRow<? extends T> it = object;
                boolean bl = false;
                DataFrame<? extends T> dataFrame = TakeKt.take($this$takeWhile, DataRowKt.getIndex(it));
                object = dataFrame;
                if (dataFrame != null) break block3;
            }
            object = $this$takeWhile;
        }
        return object;
    }

    private static final boolean takeWhile$lambda$2(Function2 $predicate, DataRow $this$firstOrNull, DataRow it) {
        Intrinsics.checkNotNullParameter((Object)$this$firstOrNull, (String)"$this$firstOrNull");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Boolean)$predicate.invoke((Object)it, (Object)it) == false;
    }
}

