/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl;

import java.net.URL;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KTypes;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataColumnKt;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnGroup;
import org.jetbrains.kotlinx.dataframe.columns.ColumnKind;
import org.jetbrains.kotlinx.dataframe.columns.FrameColumn;
import org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt;
import org.jetbrains.kotlinx.dataframe.io.HtmlKt;
import org.jetbrains.kotlinx.dataframe.jupyter.RenderedContent;
import org.jetbrains.kotlinx.dataframe.schema.ColumnSchema;
import org.jetbrains.kotlinx.dataframe.schema.DataFrameSchema;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00022\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\bH\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0012\u0010\u000b\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u001a\u0018\u0010\u000b\u001a\u00020\u00022\u000e\u0010\f\u001a\n\u0012\u0002\b\u00030\u0010j\u0002`\u0011H\u0000\u001a\u0014\u0010\u0012\u001a\u00020\u0002*\n\u0012\u0002\b\u00030\u0010j\u0002`\u0011H\u0000\u00a8\u0006\u0013"}, d2={"truncate", "Lorg/jetbrains/kotlinx/dataframe/jupyter/RenderedContent;", "", "limit", "", "renderSchema", "df", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "schema", "Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "renderType", "column", "Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema;", "type", "Lkotlin/reflect/KType;", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "renderShort", "core"})
@SourceDebugExtension(value={"SMAP\nRendering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rendering.kt\norg/jetbrains/kotlinx/dataframe/impl/RenderingKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,125:1\n126#2:126\n153#2,3:127\n*S KotlinDebug\n*F\n+ 1 Rendering.kt\norg/jetbrains/kotlinx/dataframe/impl/RenderingKt\n*L\n37#1:126\n37#1:127,3\n*E\n"})
public final class RenderingKt {
    @NotNull
    public static final RenderedContent truncate(@NotNull String $this$truncate, int limit) {
        RenderedContent renderedContent;
        Intrinsics.checkNotNullParameter((Object)$this$truncate, (String)"<this>");
        boolean bl = 1 <= limit ? limit < $this$truncate.length() : false;
        if (bl) {
            if (limit < 4) {
                renderedContent = RenderedContent.Companion.truncatedText("...", $this$truncate);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                String string = $this$truncate.substring(0, RangesKt.coerceAtLeast((int)(limit - 3), (int)1));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                renderedContent = RenderedContent.Companion.truncatedText(stringBuilder.append(string).append("...").toString(), $this$truncate);
            }
        } else {
            renderedContent = RenderedContent.Companion.text($this$truncate);
        }
        return renderedContent;
    }

    @NotNull
    public static final String renderSchema(@NotNull DataFrame<?> df2) {
        Intrinsics.checkNotNullParameter(df2, (String)"df");
        return CollectionsKt.joinToString$default((Iterable)df2.columns(), null, null, null, (int)0, null, RenderingKt::renderSchema$lambda$0, (int)31, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String renderSchema(@NotNull DataFrameSchema schema) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Map<String, ColumnSchema> $this$map$iv = schema.getColumns();
        boolean $i$f$map = false;
        Map<String, ColumnSchema> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey() + ':' + RenderingKt.renderType((ColumnSchema)it.getValue()));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
    }

    @NotNull
    public static final String renderType(@NotNull ColumnSchema column) {
        String string;
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        ColumnSchema columnSchema = column;
        if (columnSchema instanceof ColumnSchema.Value) {
            string = RenderingKt.renderType(((ColumnSchema.Value)column).getType());
        } else if (columnSchema instanceof ColumnSchema.Frame) {
            string = '[' + RenderingKt.renderSchema(((ColumnSchema.Frame)column).getSchema()) + ']';
        } else if (columnSchema instanceof ColumnSchema.Group) {
            string = '{' + RenderingKt.renderSchema(((ColumnSchema.Group)column).getSchema()) + '}';
        } else {
            throw new NotImplementedError(null, 1, null);
        }
        return string;
    }

    @NotNull
    public static final String renderType(@Nullable KType type) {
        String string;
        KClassifier kClassifier;
        KType kType = type;
        Object object = kClassifier = kType != null ? kType.getClassifier() : null;
        if (kClassifier == null) {
            string = "*";
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Void.class))) {
            string = "Nothing" + (type.isMarkedNullable() ? "?" : "");
        } else {
            Object[] objectArray;
            String string2 = KTypesJvm.getJvmErasure((KType)type).getQualifiedName();
            if (string2 == null) {
                return type.toString();
            }
            String fullName = string2;
            String name = KTypes.isSubtypeOf((KType)type, (KType)Reflection.typeOf(Object[].class, (KTypeProjection)KTypeProjection.Companion.getSTAR())) ? "Array" : (Intrinsics.areEqual((Object)type.getClassifier(), (Object)Reflection.getOrCreateKotlinClass(URL.class)) ? StringsKt.removePrefix((String)fullName, (CharSequence)"java.net.") : (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])(objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(LocalDateTime.class), Reflection.getOrCreateKotlinClass(LocalTime.class)})), (Object)type.getClassifier()) ? StringsKt.removePrefix((String)fullName, (CharSequence)"java.time.") : (StringsKt.startsWith$default((String)fullName, (String)"kotlin.collections.", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)fullName, (CharSequence)"kotlin.collections.") : (StringsKt.startsWith$default((String)fullName, (String)"kotlin.", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)fullName, (CharSequence)"kotlin.") : (StringsKt.startsWith$default((String)fullName, (String)"org.jetbrains.kotlinx.dataframe.", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)fullName, (CharSequence)"org.jetbrains.kotlinx.dataframe.") : fullName)))));
            Object[] $this$renderType_u24lambda_u243 = objectArray = new StringBuilder();
            boolean bl = false;
            $this$renderType_u24lambda_u243.append(name);
            if (!((Collection)type.getArguments()).isEmpty()) {
                String arguments = CollectionsKt.joinToString$default((Iterable)type.getArguments(), null, null, null, (int)0, null, RenderingKt::renderType$lambda$3$lambda$2, (int)31, null);
                $this$renderType_u24lambda_u243.append('<' + arguments + '>');
            }
            if (type.isMarkedNullable()) {
                $this$renderType_u24lambda_u243.append("?");
            }
            String string3 = objectArray.toString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        }
        return string;
    }

    @NotNull
    public static final String renderType(@NotNull DataColumn<?> column) {
        String string;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        switch (WhenMappings.$EnumSwitchMapping$0[column.kind().ordinal()]) {
            case 1: {
                string = RenderingKt.renderType(DataColumnKt.getType(column));
                break;
            }
            case 2: {
                FrameColumn<?> table = UtilsKt.asAnyFrameColumn(column);
                string = '[' + RenderingKt.renderSchema((DataFrameSchema)table.getSchema().getValue()) + ']';
                break;
            }
            case 3: {
                ColumnGroup<?> group = TypeConversionsKt.asColumnGroupUntyped(column);
                string = '{' + RenderingKt.renderSchema((DataFrame)group) + '}';
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public static final String renderShort(@NotNull DataColumn<?> $this$renderShort) {
        String string;
        Intrinsics.checkNotNullParameter($this$renderShort, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$renderShort.kind().ordinal()]) {
            case 1: {
                string = HtmlKt.escapeHTML("ValueColumn<" + RenderingKt.renderType(DataColumnKt.getType($this$renderShort)) + ">: " + DataColumnKt.getSize($this$renderShort) + " entries");
                break;
            }
            case 2: {
                string = "FrameColumn: " + DataColumnKt.getSize($this$renderShort) + " entries";
                break;
            }
            case 3: {
                string = "ColumnGroup " + DataFrameKt.getSize(TypeConversionsKt.asDataFrame(TypeConversionsKt.asColumnGroupUntyped($this$renderShort))) + '}';
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private static final CharSequence renderSchema$lambda$0(DataColumn it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.name() + ':' + RenderingKt.renderType(it);
    }

    private static final CharSequence renderType$lambda$3$lambda$2(KTypeProjection it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return RenderingKt.renderType(it.getType());
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColumnKind.values().length];
            try {
                nArray[ColumnKind.Value.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnKind.Frame.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnKind.Group.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

