/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.frontend.compose.ui.foundation;

import androidx.compose.foundation.ScrollState;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import com.intellij.ml.llm.agents.frontend.compose.ui.foundation.ViewportBounds;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c1\u0002\u0018\u00002\u00020\u0001:\u0004\f\r\u000e\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/agents/frontend/compose/ui/foundation/StickyOverlayCalculator;", "", "<init>", "()V", "compute", "Lcom/intellij/ml/llm/agents/frontend/compose/ui/foundation/StickyOverlayCalculator$Result;", "env", "Lcom/intellij/ml/llm/agents/frontend/compose/ui/foundation/StickyOverlayCalculator$Environment;", "measures", "Lcom/intellij/ml/llm/agents/frontend/compose/ui/foundation/StickyOverlayCalculator$Measures;", "state", "Lcom/intellij/ml/llm/agents/frontend/compose/ui/foundation/StickyOverlayCalculator$State;", "Environment", "Measures", "State", "Result", "intellij.ml.llm.agents.frontend"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nStickyOverlayCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StickyOverlayCalculator.kt\ncom/intellij/ml/llm/agents/frontend/compose/ui/foundation/StickyOverlayCalculator\n+ 2 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,94:1\n59#2:95\n90#3:96\n1#4:97\n122#5:98\n*S KotlinDebug\n*F\n+ 1 StickyOverlayCalculator.kt\ncom/intellij/ml/llm/agents/frontend/compose/ui/foundation/StickyOverlayCalculator\n*L\n67#1:95\n67#1:96\n81#1:98\n*E\n"})
public final class StickyOverlayCalculator {
    @NotNull
    public static final StickyOverlayCalculator INSTANCE = new StickyOverlayCalculator();
    public static final int $stable;

    private StickyOverlayCalculator() {
    }

    @NotNull
    public final Result compute(@NotNull Environment env, @NotNull Measures measures, @NotNull State state) {
        float f;
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)measures, (String)"measures");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        LayoutCoordinates layoutCoordinates = env.getViewportCoordinates();
        if (layoutCoordinates != null) {
            long l = layoutCoordinates.getSize-YbymL2g();
            boolean bl = false;
            long value$iv$iv = l;
            boolean $i$f$unpackInt2 = false;
            f = (int)(value$iv$iv & 0xFFFFFFFFL);
        } else {
            ViewportBounds viewportBounds = env.getViewportBounds();
            if (viewportBounds != null) {
                ViewportBounds it = viewportBounds;
                boolean bl = false;
                f = it.getBottomPx() - it.getTopPx();
            } else {
                f = 0.0f;
            }
        }
        float viewportHeightLocal = f;
        ScrollState scrollState = env.getVerticalScrollState();
        int currentScroll = scrollState != null ? scrollState.getValue() : state.getLastMeasuredScroll();
        float dy = currentScroll - state.getLastMeasuredScroll();
        float predictedTopLocal = state.getLastFactTopLocal() - dy;
        float predictedBottomLocal = predictedTopLocal + (float)measures.getPanelHeightPx();
        boolean intersects = predictedBottomLocal > 0.0f && predictedTopLocal < viewportHeightLocal;
        boolean showHeader = intersects && predictedTopLocal < 0.0f;
        boolean showFooter = intersects && predictedBottomLocal > viewportHeightLocal;
        Density $this$compute_u24lambda_u241 = env.getDensity();
        boolean bl = false;
        boolean $this$dp$iv = false;
        boolean $i$f$getDp = false;
        int bottomInsetPx = $this$compute_u24lambda_u241.roundToPx-0680j_4(Dp.constructor-impl((float)((float)$this$dp$iv)));
        float headerY = showHeader ? -predictedTopLocal : 0.0f;
        float footerY = showFooter ? viewportHeightLocal - predictedTopLocal - (float)measures.getFooterHeightPx() - (float)bottomInsetPx : 0.0f;
        return new Result(showHeader, headerY, showFooter, footerY);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J7\u0010\u0018\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/agents/frontend/compose/ui/foundation/StickyOverlayCalculator$Environment;", "", "viewportCoordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "viewportBounds", "Lcom/intellij/ml/llm/agents/frontend/compose/ui/foundation/ViewportBounds;", "verticalScrollState", "Landroidx/compose/foundation/ScrollState;", "density", "Landroidx/compose/ui/unit/Density;", "<init>", "(Landroidx/compose/ui/layout/LayoutCoordinates;Lcom/intellij/ml/llm/agents/frontend/compose/ui/foundation/ViewportBounds;Landroidx/compose/foundation/ScrollState;Landroidx/compose/ui/unit/Density;)V", "getViewportCoordinates", "()Landroidx/compose/ui/layout/LayoutCoordinates;", "getViewportBounds", "()Lcom/intellij/ml/llm/agents/frontend/compose/ui/foundation/ViewportBounds;", "getVerticalScrollState", "()Landroidx/compose/foundation/ScrollState;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.agents.frontend"})
    @StabilityInferred(parameters=0)
    public static final class Environment {
        @Nullable
        private final LayoutCoordinates viewportCoordinates;
        @Nullable
        private final ViewportBounds viewportBounds;
        @Nullable
        private final ScrollState verticalScrollState;
        @NotNull
        private final Density density;
        public static final int $stable = 8;

        public Environment(@Nullable LayoutCoordinates viewportCoordinates, @Nullable ViewportBounds viewportBounds, @Nullable ScrollState verticalScrollState, @NotNull Density density) {
            Intrinsics.checkNotNullParameter((Object)density, (String)"density");
            this.viewportCoordinates = viewportCoordinates;
            this.viewportBounds = viewportBounds;
            this.verticalScrollState = verticalScrollState;
            this.density = density;
        }

        @Nullable
        public final LayoutCoordinates getViewportCoordinates() {
            return this.viewportCoordinates;
        }

        @Nullable
        public final ViewportBounds getViewportBounds() {
            return this.viewportBounds;
        }

        @Nullable
        public final ScrollState getVerticalScrollState() {
            return this.verticalScrollState;
        }

        @NotNull
        public final Density getDensity() {
            return this.density;
        }

        @Nullable
        public final LayoutCoordinates component1() {
            return this.viewportCoordinates;
        }

        @Nullable
        public final ViewportBounds component2() {
            return this.viewportBounds;
        }

        @Nullable
        public final ScrollState component3() {
            return this.verticalScrollState;
        }

        @NotNull
        public final Density component4() {
            return this.density;
        }

        @NotNull
        public final Environment copy(@Nullable LayoutCoordinates viewportCoordinates, @Nullable ViewportBounds viewportBounds, @Nullable ScrollState verticalScrollState, @NotNull Density density) {
            Intrinsics.checkNotNullParameter((Object)density, (String)"density");
            return new Environment(viewportCoordinates, viewportBounds, verticalScrollState, density);
        }

        public static /* synthetic */ Environment copy$default(Environment environment, LayoutCoordinates layoutCoordinates, ViewportBounds viewportBounds, ScrollState scrollState, Density density, int n, Object object) {
            if ((n & 1) != 0) {
                layoutCoordinates = environment.viewportCoordinates;
            }
            if ((n & 2) != 0) {
                viewportBounds = environment.viewportBounds;
            }
            if ((n & 4) != 0) {
                scrollState = environment.verticalScrollState;
            }
            if ((n & 8) != 0) {
                density = environment.density;
            }
            return environment.copy(layoutCoordinates, viewportBounds, scrollState, density);
        }

        @NotNull
        public String toString() {
            return "Environment(viewportCoordinates=" + this.viewportCoordinates + ", viewportBounds=" + this.viewportBounds + ", verticalScrollState=" + this.verticalScrollState + ", density=" + this.density + ")";
        }

        public int hashCode() {
            int result = this.viewportCoordinates == null ? 0 : this.viewportCoordinates.hashCode();
            result = result * 31 + (this.viewportBounds == null ? 0 : this.viewportBounds.hashCode());
            result = result * 31 + (this.verticalScrollState == null ? 0 : this.verticalScrollState.hashCode());
            result = result * 31 + this.density.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Environment)) {
                return false;
            }
            Environment environment = (Environment)other;
            if (!Intrinsics.areEqual((Object)this.viewportCoordinates, (Object)environment.viewportCoordinates)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.viewportBounds, (Object)environment.viewportBounds)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.verticalScrollState, (Object)environment.verticalScrollState)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.density, (Object)environment.density);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/agents/frontend/compose/ui/foundation/StickyOverlayCalculator$Measures;", "", "panelHeightPx", "", "footerHeightPx", "<init>", "(II)V", "getPanelHeightPx", "()I", "getFooterHeightPx", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.ml.llm.agents.frontend"})
    @StabilityInferred(parameters=1)
    public static final class Measures {
        private final int panelHeightPx;
        private final int footerHeightPx;
        public static final int $stable;

        public Measures(int panelHeightPx, int footerHeightPx) {
            this.panelHeightPx = panelHeightPx;
            this.footerHeightPx = footerHeightPx;
        }

        public final int getPanelHeightPx() {
            return this.panelHeightPx;
        }

        public final int getFooterHeightPx() {
            return this.footerHeightPx;
        }

        public final int component1() {
            return this.panelHeightPx;
        }

        public final int component2() {
            return this.footerHeightPx;
        }

        @NotNull
        public final Measures copy(int panelHeightPx, int footerHeightPx) {
            return new Measures(panelHeightPx, footerHeightPx);
        }

        public static /* synthetic */ Measures copy$default(Measures measures, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = measures.panelHeightPx;
            }
            if ((n3 & 2) != 0) {
                n2 = measures.footerHeightPx;
            }
            return measures.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Measures(panelHeightPx=" + this.panelHeightPx + ", footerHeightPx=" + this.footerHeightPx + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.panelHeightPx);
            result = result * 31 + Integer.hashCode(this.footerHeightPx);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Measures)) {
                return false;
            }
            Measures measures = (Measures)other;
            if (this.panelHeightPx != measures.panelHeightPx) {
                return false;
            }
            return this.footerHeightPx == measures.footerHeightPx;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/agents/frontend/compose/ui/foundation/StickyOverlayCalculator$Result;", "", "showHeader", "", "headerY", "", "showFooter", "footerY", "<init>", "(ZFZF)V", "getShowHeader", "()Z", "getHeaderY", "()F", "getShowFooter", "getFooterY", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.ml.llm.agents.frontend"})
    @StabilityInferred(parameters=1)
    public static final class Result {
        private final boolean showHeader;
        private final float headerY;
        private final boolean showFooter;
        private final float footerY;
        public static final int $stable;

        public Result(boolean showHeader, float headerY, boolean showFooter, float footerY) {
            this.showHeader = showHeader;
            this.headerY = headerY;
            this.showFooter = showFooter;
            this.footerY = footerY;
        }

        public final boolean getShowHeader() {
            return this.showHeader;
        }

        public final float getHeaderY() {
            return this.headerY;
        }

        public final boolean getShowFooter() {
            return this.showFooter;
        }

        public final float getFooterY() {
            return this.footerY;
        }

        public final boolean component1() {
            return this.showHeader;
        }

        public final float component2() {
            return this.headerY;
        }

        public final boolean component3() {
            return this.showFooter;
        }

        public final float component4() {
            return this.footerY;
        }

        @NotNull
        public final Result copy(boolean showHeader, float headerY, boolean showFooter, float footerY) {
            return new Result(showHeader, headerY, showFooter, footerY);
        }

        public static /* synthetic */ Result copy$default(Result result, boolean bl, float f, boolean bl2, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = result.showHeader;
            }
            if ((n & 2) != 0) {
                f = result.headerY;
            }
            if ((n & 4) != 0) {
                bl2 = result.showFooter;
            }
            if ((n & 8) != 0) {
                f2 = result.footerY;
            }
            return result.copy(bl, f, bl2, f2);
        }

        @NotNull
        public String toString() {
            return "Result(showHeader=" + this.showHeader + ", headerY=" + this.headerY + ", showFooter=" + this.showFooter + ", footerY=" + this.footerY + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.showHeader);
            result = result * 31 + Float.hashCode(this.headerY);
            result = result * 31 + Boolean.hashCode(this.showFooter);
            result = result * 31 + Float.hashCode(this.footerY);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (this.showHeader != result.showHeader) {
                return false;
            }
            if (Float.compare(this.headerY, result.headerY) != 0) {
                return false;
            }
            if (this.showFooter != result.showFooter) {
                return false;
            }
            return Float.compare(this.footerY, result.footerY) == 0;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/agents/frontend/compose/ui/foundation/StickyOverlayCalculator$State;", "", "lastFactTopLocal", "", "lastMeasuredScroll", "", "<init>", "(FI)V", "getLastFactTopLocal", "()F", "getLastMeasuredScroll", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.ml.llm.agents.frontend"})
    @StabilityInferred(parameters=1)
    public static final class State {
        private final float lastFactTopLocal;
        private final int lastMeasuredScroll;
        public static final int $stable;

        public State(float lastFactTopLocal, int lastMeasuredScroll) {
            this.lastFactTopLocal = lastFactTopLocal;
            this.lastMeasuredScroll = lastMeasuredScroll;
        }

        public final float getLastFactTopLocal() {
            return this.lastFactTopLocal;
        }

        public final int getLastMeasuredScroll() {
            return this.lastMeasuredScroll;
        }

        public final float component1() {
            return this.lastFactTopLocal;
        }

        public final int component2() {
            return this.lastMeasuredScroll;
        }

        @NotNull
        public final State copy(float lastFactTopLocal, int lastMeasuredScroll) {
            return new State(lastFactTopLocal, lastMeasuredScroll);
        }

        public static /* synthetic */ State copy$default(State state, float f, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                f = state.lastFactTopLocal;
            }
            if ((n2 & 2) != 0) {
                n = state.lastMeasuredScroll;
            }
            return state.copy(f, n);
        }

        @NotNull
        public String toString() {
            return "State(lastFactTopLocal=" + this.lastFactTopLocal + ", lastMeasuredScroll=" + this.lastMeasuredScroll + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.lastFactTopLocal);
            result = result * 31 + Integer.hashCode(this.lastMeasuredScroll);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (Float.compare(this.lastFactTopLocal, state.lastFactTopLocal) != 0) {
                return false;
            }
            return this.lastMeasuredScroll == state.lastMeasuredScroll;
        }
    }
}

