/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.credentialStore.Credentials;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessNotCreatedException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsManagerKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"canUseGitExe", "", "getCredentialsUsingGit", "Lcom/intellij/credentialStore/Credentials;", "uri", "Lorg/eclipse/jgit/transport/URIish;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "intellij.settingsRepository"})
public final class GitCredentialKt {
    private static boolean canUseGitExe = true;

    @Nullable
    public static final Credentials getCredentialsUsingGit(@NotNull URIish uri, @NotNull Repository repository) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        if (!canUseGitExe || repository.getConfig().getSubsections("credential").isEmpty()) {
            return null;
        }
        String[] stringArray = new String[]{"git", "credential", "fill"};
        GeneralCommandLine commandLine = new GeneralCommandLine(stringArray);
        Process process = null;
        try {
            Process process2 = commandLine.createProcess();
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"createProcess(...)");
            process = process2;
        }
        catch (ProcessNotCreatedException e) {
            canUseGitExe = false;
            return null;
        }
        OutputStream outputStream = process.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        OutputStream outputStream2 = outputStream;
        Object object2 = Charsets.UTF_8;
        OutputStreamWriter writer = new OutputStreamWriter(outputStream2, (Charset)object2);
        writer.write("url=");
        writer.write(uri.toPrivateString());
        writer.write("\n\n");
        writer.close();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        object2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)object2, charset);
        int n = 8192;
        BufferedReader reader2 = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        String username = null;
        String password = null;
        while (true) {
            String string = reader2.readLine();
            String line = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
            object = line;
            if (object == null || object.length() == 0) break;
            if (StringsKt.startsWith$default((String)line, (String)"username=", (boolean)false, (int)2, null)) {
                username = GitCredentialKt.getCredentialsUsingGit$readValue(line);
                continue;
            }
            if (!StringsKt.startsWith$default((String)line, (String)"password=", (boolean)false, (int)2, null)) continue;
            password = GitCredentialKt.getCredentialsUsingGit$readValue(line);
        }
        reader2.close();
        InputStream inputStream2 = process.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getErrorStream(...)");
        object = inputStream2;
        Charset charset2 = Charsets.UTF_8;
        String errorText = TextStreamsKt.readText((Reader)new InputStreamReader((InputStream)object, charset2));
        if (((CharSequence)errorText).length() > 0) {
            IcsManagerKt.getLOG().warn(errorText);
        }
        return username == null && password == null ? null : new Credentials(username, password);
    }

    private static final String getCredentialsUsingGit$readValue(String line) {
        String string = line.substring(StringsKt.indexOf$default((CharSequence)line, (char)'=', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }
}

