/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.BuildNumber;
import java.net.InetAddress;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.lib.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.git.CommitMessageFormatter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010\u0007\u001a\u00060\bj\u0002`\t2\n\u0010\n\u001a\u00060\bj\u0002`\tH\u0016J\u001e\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J$\u0010\u0010\u001a\u00060\bj\u0002`\t2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\f\b\u0002\u0010\n\u001a\u00060\bj\u0002`\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u0014*\u00060\bj\u0002`\tH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/settingsRepository/git/IdeaCommitMessageFormatter;", "Lorg/jetbrains/settingsRepository/git/CommitMessageFormatter;", "<init>", "()V", "message", "", "text", "prependMessage", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "builder", "mergeMessage", "refsToMerge", "", "Lorg/eclipse/jgit/lib/Ref;", "target", "appendCommitOwnerInfo", "avoidAppInfoInstantiation", "", "appendAppName", "", "intellij.settingsRepository"})
public final class IdeaCommitMessageFormatter
implements CommitMessageFormatter {
    @Override
    @NotNull
    public String message(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = IdeaCommitMessageFormatter.appendCommitOwnerInfo$default(this, false, null, 3, null).append(text).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public StringBuilder prependMessage(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return IdeaCommitMessageFormatter.appendCommitOwnerInfo$default(this, false, builder, 1, null);
    }

    @Override
    @NotNull
    public String mergeMessage(@NotNull List<? extends Ref> refsToMerge, @NotNull Ref target) {
        Intrinsics.checkNotNullParameter(refsToMerge, (String)"refsToMerge");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String string = IdeaCommitMessageFormatter.appendCommitOwnerInfo$default(this, false, null, 3, null).append(CommitMessageFormatter.super.mergeMessage(refsToMerge, target)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final StringBuilder appendCommitOwnerInfo(boolean avoidAppInfoInstantiation, StringBuilder builder) {
        if (avoidAppInfoInstantiation) {
            builder.append(ApplicationNamesInfo.getInstance().getProductName());
        } else {
            this.appendAppName(builder);
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application);
        if (!application.isUnitTestMode() && IcsManagerKt.getIcsManager().getSettings().getIncludeHostIntoCommitMessage()) {
            builder.append(' ').append('<').append(System.getProperty("user.name", "unknown-user"));
            builder.append('@').append(InetAddress.getLocalHost().getHostName());
        }
        builder.append(' ');
        return builder;
    }

    static /* synthetic */ StringBuilder appendCommitOwnerInfo$default(IdeaCommitMessageFormatter ideaCommitMessageFormatter, boolean bl, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            stringBuilder = new StringBuilder();
        }
        return ideaCommitMessageFormatter.appendCommitOwnerInfo(bl, stringBuilder);
    }

    private final void appendAppName(StringBuilder $this$appendAppName) {
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        if (appInfo != null) {
            BuildNumber buildNumber = appInfo.getBuild();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
            BuildNumber build = buildNumber;
            $this$appendAppName.append(build.getProductCode()).append('-');
            StringBuilder stringBuilder = appInfo.getMajorVersion() != null && !appInfo.isEAP() ? $this$appendAppName.append(appInfo.getFullVersion()) : $this$appendAppName.append(build.asStringWithoutProductCodeAndSnapshot());
        }
    }
}

