/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.grammarcommon;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.python.pydev.parser.grammarcommon.ITokenManager;
import org.python.pydev.parser.jython.Token;
import org.python.pydev.shared_core.structure.Tuple;

final class TokensIterator
implements Iterator<Token> {
    private Token currentToken;
    private int tokensToIterate;
    private int tokensIterated;
    private boolean breakOnIndentsDedentsAndNewCompounds;
    private ITokenManager tokenManager;
    private Tuple<Token, Token> prevAndReturned;
    private final HashSet<Integer> contextsToBreak = new HashSet();
    private boolean calculatedNext;
    private boolean isFirst;

    public TokensIterator(ITokenManager tokenManager, Token firstIterationToken, int tokensToIterate, boolean breakOnIndentsDedentsAndNewCompounds) {
        this.contextsToBreak.add(tokenManager.getIndentId());
        this.contextsToBreak.add(tokenManager.getDedentId());
        this.contextsToBreak.add(tokenManager.getIfId());
        this.contextsToBreak.add(tokenManager.getWhileId());
        this.contextsToBreak.add(tokenManager.getForId());
        this.contextsToBreak.add(tokenManager.getTryId());
        this.contextsToBreak.add(tokenManager.getDefId());
        this.contextsToBreak.add(tokenManager.getClassId());
        this.contextsToBreak.add(tokenManager.getAtId());
        this.contextsToBreak.add(tokenManager.getNewline1Id());
        this.contextsToBreak.add(tokenManager.getNewlineId());
        this.contextsToBreak.add(tokenManager.getNewline2Id());
        this.contextsToBreak.add(tokenManager.getCrlf1Id());
        this.reset(tokenManager, firstIterationToken, tokensToIterate, breakOnIndentsDedentsAndNewCompounds);
    }

    public void reset(ITokenManager tokenManager, Token firstIterationToken, int tokensToIterate, boolean breakOnIndentsDedentsAndNewCompounds) {
        this.currentToken = firstIterationToken;
        this.tokenManager = tokenManager;
        this.tokensToIterate = tokensToIterate;
        this.breakOnIndentsDedentsAndNewCompounds = breakOnIndentsDedentsAndNewCompounds;
        this.tokensIterated = 0;
        this.tokensToIterate = 0;
        this.prevAndReturned = new Tuple(null, null);
        this.calculatedNext = false;
        this.isFirst = true;
    }

    @Override
    public boolean hasNext() {
        if (this.isFirst) {
            return this.currentToken != null;
        }
        if (!this.calculatedNext) {
            this.calculateNext();
            this.calculatedNext = true;
        }
        return this.currentToken != null && this.currentToken.next != null;
    }

    @Override
    public Token next() {
        if (this.isFirst) {
            this.isFirst = false;
            return this.currentToken;
        }
        if (!this.calculatedNext) {
            this.calculateNext();
        }
        this.calculatedNext = false;
        ++this.tokensIterated;
        if (this.currentToken == null || this.currentToken.next == null) {
            throw new NoSuchElementException();
        }
        this.prevAndReturned.o1 = (Token)this.prevAndReturned.o2;
        this.prevAndReturned.o2 = this.currentToken.next;
        if (this.tokensIterated == this.tokensToIterate) {
            this.currentToken = null;
        } else if (this.currentToken != null && this.currentToken.kind == this.tokenManager.getEofId()) {
            this.currentToken = null;
        } else if (this.breakOnIndentsDedentsAndNewCompounds && this.currentToken != null && this.contextsToBreak.contains(this.currentToken.kind)) {
            this.currentToken = null;
        }
        if (this.currentToken != null) {
            this.currentToken = this.currentToken.next;
        }
        return (Token)this.prevAndReturned.o2;
    }

    private void calculateNext() {
        if (this.currentToken == null) {
            return;
        }
        if (this.currentToken.kind == this.tokenManager.getEofId()) {
            return;
        }
        if (this.currentToken.next == null) {
            this.currentToken.next = this.tokenManager.getNextToken();
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    public Token getBeforeLastReturned() {
        return (Token)this.prevAndReturned.o1;
    }
}

