/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.visitors.scope;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.python.pydev.parser.jython.ISpecialStr;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.NameIterator;
import org.python.pydev.parser.visitors.scope.OutlineIterator;
import org.python.pydev.shared_core.structure.FastStack;

public abstract class EasyAstIteratorBase
extends VisitorBase {
    protected List<ASTEntry> nodes = new ArrayList<ASTEntry>();
    protected final FastStack<SimpleNode> stack = new FastStack(20);
    protected final FastStack<ASTEntry> parents = new FastStack(10);
    protected SimpleNode lastVisited;
    protected ASTEntry lastDefVisited;
    private int higherLine = -1;

    @Override
    protected Object unhandled_node(SimpleNode node) throws Exception {
        this.lastVisited = node;
        int l = NodeUtils.getLineEnd(this.lastVisited);
        if (l > this.higherLine) {
            this.higherLine = l;
        }
        if (node.specialsAfter != null) {
            for (Object o : node.specialsAfter) {
                ISpecialStr str;
                if (!(o instanceof ISpecialStr) || (str = (ISpecialStr)o).getBeginLine() <= this.higherLine) continue;
                this.higherLine = str.getBeginLine();
            }
        }
        if (this.lastDefVisited != null) {
            this.lastDefVisited = null;
        }
        return null;
    }

    @Override
    public void traverse(SimpleNode node) throws Exception {
        if (node instanceof FunctionDef) {
            this.traverse((FunctionDef)node);
        } else {
            node.traverse(this);
        }
    }

    protected ASTEntry before(SimpleNode node) {
        ASTEntry entry = this.createEntry();
        entry.node = node;
        this.doAddNode(entry);
        this.stack.push((Object)node);
        return entry;
    }

    protected void doAddNode(ASTEntry entry) {
        this.nodes.add(entry);
    }

    protected void after(ASTEntry entry) {
        this.stack.pop();
        if (entry.endLine == 0) {
            int lineEnd = NodeUtils.getLineEnd(this.lastVisited);
            entry.endLine = lineEnd > this.higherLine ? lineEnd : this.higherLine;
            List<Object> s = entry.node.specialsAfter;
            if (s != null) {
                for (Object o : s) {
                    if (!(o instanceof commentType)) continue;
                    commentType comment = (commentType)o;
                    if (comment.beginLine <= entry.endLine) continue;
                    entry.endLine = comment.beginLine;
                }
            }
        }
        this.lastDefVisited = entry;
    }

    @Override
    public Object visitModule(Module node) throws Exception {
        Object ret = super.visitModule(node);
        int size = this.nodes.size();
        if (size > 0) {
            int i = -1;
            if (node.specialsAfter != null) {
                for (Object o : node.specialsAfter) {
                    if (!(o instanceof commentType)) continue;
                    commentType type = (commentType)o;
                    if (type.beginLine <= i) continue;
                    i = type.beginLine;
                }
            }
            if (i != -1 && this.lastDefVisited != null && this.lastDefVisited.endLine < i) {
                this.lastDefVisited.endLine = i;
            }
        }
        return ret;
    }

    protected ASTEntry atomic(SimpleNode node) {
        ASTEntry entry = this.createEntry();
        entry.node = node;
        entry.endLine = NodeUtils.getLineEnd(node);
        entry.endCol = NodeUtils.getColDefinition(node);
        this.doAddNode(entry);
        return entry;
    }

    protected ASTEntry createEntry() {
        ASTEntry entry = this.parents.size() > 0 ? new ASTEntry((ASTEntry)((Object)this.parents.peek())) : new ASTEntry(null);
        return entry;
    }

    @Override
    public Object visitClassDef(ClassDef node) throws Exception {
        ASTEntry entry = this.before(node);
        this.parents.push((Object)entry);
        this.traverse(node);
        this.after(entry);
        this.parents.pop();
        return null;
    }

    protected boolean isInGlobal() {
        for (SimpleNode node : this.stack) {
            if (!(node instanceof ClassDef) && !(node instanceof FunctionDef)) continue;
            return false;
        }
        return true;
    }

    protected boolean isInClassMethodDecl() {
        SimpleNode node;
        ListIterator iterator = this.stack.iterator();
        while (iterator.hasNext()) {
            node = (SimpleNode)iterator.next();
            if (node instanceof ClassDef) break;
        }
        while (iterator.hasNext()) {
            node = (SimpleNode)iterator.next();
            if (!(node instanceof FunctionDef)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInClassDecl() {
        if (this.stack.size() == 0) {
            return false;
        }
        SimpleNode last = (SimpleNode)this.stack.peek();
        return last instanceof ClassDef;
    }

    @Override
    public Object visitFunctionDef(FunctionDef node) throws Exception {
        ASTEntry entry = this.before(node);
        this.parents.push((Object)entry);
        this.traverse(node);
        this.parents.pop();
        this.after(entry);
        return null;
    }

    public void traverse(FunctionDef node) throws Exception {
        int i;
        if (node.decs != null) {
            i = 0;
            while (i < node.decs.length) {
                if (node.decs[i] != null) {
                    node.decs[i].accept(this);
                }
                ++i;
            }
        }
        if (node.name != null) {
            node.name.accept(this);
        }
        if (node.args != null) {
            node.args.accept(this);
        }
        if (node.returns != null) {
            node.returns.accept(this);
        }
        if (node.body != null) {
            i = 0;
            while (i < node.body.length) {
                if (node.body[i] != null) {
                    node.body[i].accept(this);
                }
                ++i;
            }
        }
    }

    public Iterator<ASTEntry> getIterator() {
        return this.nodes.iterator();
    }

    public Iterator<ASTEntry> getClassesIterator() {
        return this.getIterator((Class)ClassDef.class);
    }

    public List<ASTEntry> getClassesAndMethodsList() {
        return this.getAsList(ClassDef.class, FunctionDef.class);
    }

    protected List<ASTEntry> getIteratorAsList(Iterator<ASTEntry> iter) {
        ArrayList<ASTEntry> list = new ArrayList<ASTEntry>();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public Iterator<ASTEntry> getClassesAndMethodsIterator() {
        return this.getIterator(ClassDef.class, FunctionDef.class);
    }

    public Iterator<ASTEntry> getMethodsIterator() {
        return this.getIterator(new Class[]{FunctionDef.class});
    }

    public Iterator<ASTEntry> getIterator(Class class_) {
        return this.getIterator(new Class[]{class_});
    }

    public List<ASTEntry> getAsList(Class ... classes) {
        ArrayList<ASTEntry> newList = new ArrayList<ASTEntry>();
        for (ASTEntry entry : this.nodes) {
            if (!this.isFromClass(entry.node, classes)) continue;
            newList.add(entry);
        }
        return newList;
    }

    public List<ASTEntry> getAsList(Class class_) {
        return this.getAsList(new Class[]{class_});
    }

    public Iterator<ASTEntry> getIterator(Class ... classes) {
        return this.getAsList(classes).iterator();
    }

    public Iterator<ASTEntry> getNamesIterator() {
        return new NameIterator(this.nodes);
    }

    public Iterator<ASTEntry> getOutline() {
        return new OutlineIterator(this.nodes);
    }

    public List<ASTEntry> getAll() {
        return this.nodes;
    }

    public Iterator<ASTEntry> getAllIterator() {
        return this.nodes.iterator();
    }

    protected boolean isFromClass(SimpleNode node, Class[] classes) {
        Class<?> class1 = node.getClass();
        int i = 0;
        while (i < classes.length) {
            if (class1.isAssignableFrom(classes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

