/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_interactive_console.console;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.structure.LinkedListWarningOnSlowOperations;
import org.python.pydev.shared_interactive_console.InteractiveConsolePlugin;

public enum ScriptConsoleGlobalHistory {
    INSTANCE;

    private static final String HISTORY_PY = "history.py";
    private final LinkedList<String> lines = new LinkedListWarningOnSlowOperations();

    private ScriptConsoleGlobalHistory() {
        this.load();
    }

    public synchronized List<String> get() {
        return new ArrayList<String>(this.lines);
    }

    public synchronized void append(List<String> history) {
        int historyMaxEntries = this.getHistoryMaxEntries();
        if (history.size() > historyMaxEntries) {
            history = history.subList(history.size() - historyMaxEntries, history.size());
        }
        if (history.size() >= historyMaxEntries) {
            this.lines.clear();
        }
        for (String line : history) {
            this.lines.add(line);
        }
        while (this.lines.size() > historyMaxEntries) {
            this.lines.removeFirst();
        }
        this.store();
    }

    public synchronized void clear() {
        this.lines.clear();
        this.store();
    }

    private synchronized void load() {
        File history = this.getHistoryFile();
        if (history != null) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(history));
                try {
                    try {
                        String line = br.readLine();
                        while (line != null) {
                            this.lines.add(line);
                            line = br.readLine();
                        }
                    }
                    catch (IOException e) {
                        Log.log((String)"Failed reading existing console history.py", (Throwable)e);
                        try {
                            br.close();
                        }
                        catch (IOException e2) {
                            Log.log((String)"Failed closing existing console history.py", (Throwable)e2);
                        }
                    }
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        Log.log((String)"Failed closing existing console history.py", (Throwable)e);
                    }
                }
            }
            catch (FileNotFoundException e) {
                Log.logInfo((String)("No existing console history at: " + String.valueOf(history)), (Throwable)e);
            }
        }
    }

    private synchronized void store() {
        File history = this.getHistoryFile();
        if (history != null) {
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(history));
                try {
                    try {
                        for (String line : this.lines) {
                            bw.write(line);
                            bw.write("\n");
                        }
                    }
                    catch (IOException e) {
                        Log.log((String)"Failed writing console history.py", (Throwable)e);
                        try {
                            bw.close();
                        }
                        catch (IOException e2) {
                            Log.log((String)"Failed closing console history.py", (Throwable)e2);
                        }
                    }
                }
                finally {
                    try {
                        bw.close();
                    }
                    catch (IOException e) {
                        Log.log((String)"Failed closing console history.py", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                Log.log((String)"Failed creating console history.py", (Throwable)e);
            }
        }
    }

    private int getHistoryMaxEntries() {
        if (SharedCorePlugin.inTestMode()) {
            return 200;
        }
        InteractiveConsolePlugin plugin = InteractiveConsolePlugin.getDefault();
        IPreferenceStore store = plugin.getPreferenceStore();
        int historyMaxEntries = store.getInt("INTERACTIVE_CONSOLE_PERSISTENT_HISTORY_MAXIMUM_ENTRIES");
        if (historyMaxEntries < 0) {
            historyMaxEntries = 0;
        }
        return historyMaxEntries;
    }

    private File getHistoryFile() {
        if (SharedCorePlugin.inTestMode()) {
            return null;
        }
        InteractiveConsolePlugin plugin = InteractiveConsolePlugin.getDefault();
        IPath location = plugin.getStateLocation();
        IPath path = location.append(HISTORY_PY);
        return path.toFile();
    }
}

