/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_interactive_console.console.ui;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.IPageBookViewPage;
import org.python.pydev.core.autoedit.IHandleScriptAutoEditStrategy;
import org.python.pydev.core.interactive_console.IScriptConsoleViewer;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.Reflection;
import org.python.pydev.shared_interactive_console.console.IScriptConsoleCommunication;
import org.python.pydev.shared_interactive_console.console.IScriptConsoleInterpreter;
import org.python.pydev.shared_interactive_console.console.InterpreterResponse;
import org.python.pydev.shared_interactive_console.console.ScriptConsoleHistory;
import org.python.pydev.shared_interactive_console.console.ScriptConsolePrompt;
import org.python.pydev.shared_interactive_console.console.ui.IConsoleStyleProvider;
import org.python.pydev.shared_interactive_console.console.ui.IScriptConsoleListener;
import org.python.pydev.shared_interactive_console.console.ui.IScriptConsoleSession;
import org.python.pydev.shared_interactive_console.console.ui.ScriptConsolePartitioner;
import org.python.pydev.shared_interactive_console.console.ui.internal.ICommandHandler;
import org.python.pydev.shared_interactive_console.console.ui.internal.ScriptConsolePage;
import org.python.pydev.shared_interactive_console.console.ui.internal.ScriptConsoleSession;
import org.python.pydev.shared_interactive_console.console.ui.internal.ScriptConsoleViewer;
import org.python.pydev.shared_interactive_console.console.ui.internal.actions.AbstractHandleBackspaceAction;

public abstract class ScriptConsole
extends TextConsole
implements ICommandHandler {
    protected ScriptConsolePage page;
    protected ScriptConsolePartitioner partitioner;
    protected IScriptConsoleInterpreter interpreter;
    protected ScriptConsoleSession session;
    protected ListenerList consoleListeners;
    protected ScriptConsolePrompt prompt;
    protected ScriptConsoleHistory history;
    private WeakReference<ScriptConsoleViewer> viewer;
    public static final String DEFAULT_CONSOLE_TYPE = "org.python.pydev.debug.newconsole.PydevConsole";
    public static final String SCRIPT_DEBUG_CONSOLE_IN_PROCESS_CONSOLE = "SCRIPT_DEBUG_CONSOLE_IN_PROCESS_CONSOLE";
    private Color fPydevConsoleBackground;

    public static ScriptConsole getActiveScriptConsole(String ignored) {
        return ScriptConsole.getActiveScriptConsole();
    }

    public IDocument getDocument() {
        return super.getDocument();
    }

    public static Iterable<IConsoleView> iterConsoles() {
        IWorkbenchPage page;
        ArrayList<IConsoleView> consoles = new ArrayList<IConsoleView>();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            List<IViewPart> consoleParts = ScriptConsole.getConsoleParts(page, false);
            if (consoleParts.size() == 0) {
                consoleParts = ScriptConsole.getConsoleParts(page, true);
            }
            for (IViewPart iViewPart : consoleParts) {
                if (!(iViewPart instanceof IConsoleView)) continue;
                consoles.add((IConsoleView)iViewPart);
            }
        }
        return consoles;
    }

    public static ScriptConsole getActiveScriptConsole() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            List<IViewPart> consoleParts = ScriptConsole.getConsoleParts(page, false);
            if (consoleParts.size() == 0) {
                consoleParts = ScriptConsole.getConsoleParts(page, true);
            }
            if (consoleParts.size() > 0) {
                IConsoleView view = null;
                long lastChangeMillis = Long.MIN_VALUE;
                if (consoleParts.size() == 1) {
                    view = (IConsoleView)consoleParts.get(0);
                } else {
                    int i = 0;
                    while (i < consoleParts.size()) {
                        ScriptConsole tempConsole;
                        ScriptConsoleViewer viewer;
                        long tempLastChangeMillis;
                        IConsoleView temp = (IConsoleView)consoleParts.get(i);
                        IConsole console = temp.getConsole();
                        if (console instanceof ScriptConsole && (tempLastChangeMillis = (viewer = (tempConsole = (ScriptConsole)console).getViewer()).getLastChangeMillis()) > lastChangeMillis) {
                            lastChangeMillis = tempLastChangeMillis;
                            view = temp;
                        }
                        ++i;
                    }
                }
                if (view != null) {
                    ScriptConsole scriptConsole2;
                    IScriptConsoleCommunication consoleCommunication;
                    ProcessConsole processConsole;
                    Object scriptConsole;
                    IConsole console = view.getConsole();
                    if (console instanceof ScriptConsole) {
                        return (ScriptConsole)console;
                    }
                    if (console instanceof ProcessConsole && (scriptConsole = (processConsole = (ProcessConsole)console).getAttribute(SCRIPT_DEBUG_CONSOLE_IN_PROCESS_CONSOLE)) instanceof ScriptConsole && (consoleCommunication = (scriptConsole2 = (ScriptConsole)scriptConsole).getInterpreter().getConsoleCommunication()).isConnected()) {
                        return scriptConsole2;
                    }
                }
            }
        }
        return null;
    }

    private static List<IViewPart> getConsoleParts(IWorkbenchPage page, boolean restore) {
        IViewReference[] viewReferences;
        ArrayList<IViewPart> consoleParts = new ArrayList<IViewPart>();
        IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
        int n = viewReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IViewPart part;
            IViewReference ref = iViewReferenceArray[n2];
            if (ref.getId().equals("org.eclipse.ui.console.ConsoleView") && (part = ref.getView(restore)) != null) {
                consoleParts.add(part);
                if (restore) {
                    return consoleParts;
                }
            }
            ++n2;
        }
        return consoleParts;
    }

    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    public ScriptConsole(String consoleName, String consoleType, IScriptConsoleInterpreter interpreterArg) {
        super(consoleName, consoleType, null, true);
        this.interpreter = interpreterArg;
        this.consoleListeners = new ListenerList(1);
        this.prompt = this.createConsolePrompt();
        this.history = new ScriptConsoleHistory();
        this.session = new ScriptConsoleSession();
        this.addListener(this.session);
        this.partitioner = new ScriptConsolePartitioner();
        this.getDocument().setDocumentPartitioner((IDocumentPartitioner)this.partitioner);
        this.partitioner.connect(this.getDocument());
    }

    protected abstract IContentAssistProcessor createConsoleCompletionProcessor(ContentAssistant var1);

    protected abstract IQuickAssistProcessor createConsoleQuickAssistProcessor(QuickAssistAssistant var1);

    protected abstract ITextHover createHover();

    protected abstract ScriptConsolePrompt createConsolePrompt();

    public IScriptConsoleSession getSession() {
        return this.session;
    }

    public void addListener(IScriptConsoleListener listener) {
        this.consoleListeners.add((Object)listener);
    }

    public void removeListener(IScriptConsoleListener listener) {
        this.consoleListeners.remove((Object)listener);
    }

    protected void setInterpreter(IScriptConsoleInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public IScriptConsoleInterpreter getInterpreter() {
        return this.interpreter;
    }

    public ScriptConsolePrompt getPrompt() {
        return this.prompt;
    }

    public ScriptConsoleHistory getHistory() {
        return this.history;
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        this.page = new ScriptConsolePage(this, view, this.createSourceViewerConfiguration());
        return this.page;
    }

    public abstract SourceViewerConfiguration createSourceViewerConfiguration();

    public void clearConsole() {
        this.page.clearConsolePage();
    }

    @Override
    public void setOnContentsReceivedCallback(ICallback<Object, Tuple<String, String>> onContentsReceived) {
        this.interpreter.setOnContentsReceivedCallback(onContentsReceived);
    }

    @Override
    public boolean isOnStateWhereCommandHandlingShouldStop(String commandLine) {
        Object[] listeners;
        Object[] objectArray = listeners = this.consoleListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (((IScriptConsoleListener)listener).isOnStateWhereCommandHandlingShouldStop(commandLine)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void beforeHandleCommand(String userInput, ICallback<Object, InterpreterResponse> onResponseReceived) {
        Object[] listeners;
        Object[] objectArray = listeners = this.consoleListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IScriptConsoleListener)listener).userRequest(userInput, this.prompt);
            ++n2;
        }
    }

    @Override
    public void handleCommand(String userInput, final ICallback<Object, InterpreterResponse> onResponseReceived) {
        final Object[] listeners = this.consoleListeners.getListeners();
        if (this.interpreter != null) {
            this.interpreter.exec(userInput, new ICallback<Object, InterpreterResponse>(){

                public Object call(InterpreterResponse response) {
                    ScriptConsole.this.prompt.setMode(!response.more);
                    ScriptConsole.this.prompt.setNeedInput(response.need_input);
                    Object[] objectArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object listener = objectArray[n2];
                        ((IScriptConsoleListener)listener).interpreterResponse(response, ScriptConsole.this.prompt);
                        ++n2;
                    }
                    onResponseReceived.call((Object)response);
                    return null;
                }
            });
        }
    }

    @Override
    public ICompletionProposalHandle[] getTabCompletions(String commandLine, int cursorPosition) {
        try {
            ICompletionProposalHandle[] completions = this.interpreter.getCompletions((IScriptConsoleViewer)this.viewer.get(), commandLine, cursorPosition, cursorPosition, 3);
            return completions;
        }
        catch (Exception exception) {
            return new ICompletionProposalHandle[0];
        }
    }

    public void terminate() {
        try {
            if (this.history != null) {
                this.history.close();
            }
            this.interpreter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.history = null;
        this.interpreter = null;
    }

    public void interrupt() {
        try {
            this.interpreter.interrupt();
            this.getViewer().discardCommandLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setViewer(ScriptConsoleViewer scriptConsoleViewer) {
        this.viewer = new WeakReference<ScriptConsoleViewer>(scriptConsoleViewer);
    }

    public ScriptConsoleViewer getViewer() {
        if (this.viewer != null) {
            return (ScriptConsoleViewer)this.viewer.get();
        }
        return null;
    }

    public abstract IConsoleStyleProvider createStyleProvider();

    public abstract List<IConsoleLineTracker> createLineTrackers(TextConsole var1);

    public abstract String getInitialCommands();

    public Color getPydevConsoleBackground() {
        try {
            Color ret = (Color)Reflection.invoke((Object)this, (String)"getBackground", (Object[])new Object[0]);
            return ret;
        }
        catch (Throwable e) {
            return this.fPydevConsoleBackground;
        }
    }

    public void setPydevConsoleBackground(Color color) {
        try {
            Reflection.invoke((Object)this, (String)"setBackground", (Object[])new Object[]{color});
        }
        catch (Throwable e) {
            this.fPydevConsoleBackground = color;
        }
    }

    public Object getInterpreterInfo() {
        return this.interpreter.getInterpreterInfo();
    }

    public abstract boolean getFocusOnStart();

    public abstract boolean getTabCompletionEnabled();

    public void linkWithDebugSelection(boolean isLinkedWithDebug) {
        this.interpreter.linkWithDebugSelection(isLinkedWithDebug);
    }

    public abstract AbstractHandleBackspaceAction getBackspaceAction();

    public abstract void createActions(IToolBarManager var1);

    public abstract IHandleScriptAutoEditStrategy getAutoEditStrategy();
}

