/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.log.Log;

public class SharedCorePlugin
extends Plugin {
    public static final String SHARED_CORE_PLUGIN_ID = "org.python.pydev.shared_core";
    public static final String PYDEV_PLUGIN_ID = "org.python.pydev";
    public static final String DEFAULT_PYDEV_PREFERENCES_SCOPE = "org.python.pydev";
    private static SharedCorePlugin plugin;
    private static IImageCache imageCache;
    private static boolean testModeReturnFalse;
    public static ICallback<Object, Runnable> onAsyncRunInUiThread;
    public static ICallback<Object, Runnable> onSyncWithUiThread;

    static {
        testModeReturnFalse = false;
        onAsyncRunInUiThread = runnable -> {
            Log.log("Error: no callback assigned to run in ui thread async.");
            runnable.run();
            return null;
        };
        onSyncWithUiThread = runnable -> {
            Log.log("Error: no callback assigned to run in ui thread sync.");
            runnable.run();
            return null;
        };
    }

    public static void setImageCache(IImageCache imageCache) {
        SharedCorePlugin.imageCache = imageCache;
    }

    public static IImageCache getImageCache() {
        return imageCache;
    }

    public SharedCorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static String getIResourceOSString(IResource f) {
        IPath rawLocation;
        URI locationURI = f.getLocationURI();
        if (locationURI != null) {
            try {
                return FileUtils.getFileAbsolutePath(new File(locationURI));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((rawLocation = f.getLocation()) == null) {
            return null;
        }
        String fullPath = rawLocation.toOSString();
        File file = new File(fullPath);
        if (file.exists()) {
            return FileUtils.getFileAbsolutePath(file);
        }
        IProject project = f.getProject();
        IPath location = project.getLocation();
        File projectFile = location.toFile();
        if (projectFile.exists()) {
            String projectFilePath = FileUtils.getFileAbsolutePath(projectFile);
            if (fullPath.startsWith(projectFilePath)) {
                return fullPath;
            }
            if (fullPath.toLowerCase().startsWith(projectFilePath.toLowerCase())) {
                String relativePart = fullPath.substring(projectFilePath.length());
                return projectFilePath + relativePart;
            }
        }
        return fullPath;
    }

    public static Status makeStatus(int errorLevel, String message, Throwable e) {
        return new Status(errorLevel, "org.python.pydev", errorLevel, message, e);
    }

    public static SharedCorePlugin getDefault() {
        return plugin;
    }

    public static boolean inTestMode() {
        if (testModeReturnFalse) {
            return false;
        }
        if (plugin == null) {
            return true;
        }
        if ("true".equals(System.getProperty("PyDevInTestMode"))) {
            return true;
        }
        if ("true".equals(System.getenv("PyDevInTestMode"))) {
            return true;
        }
        testModeReturnFalse = true;
        return false;
    }

    public static boolean skipKnownFailures() {
        return true;
    }

    public static void asyncRunInUiThread(Runnable runnable) {
        onAsyncRunInUiThread.call(runnable);
    }

    public static void syncWithUiThread(Runnable runnable) {
        onSyncWithUiThread.call(runnable);
    }
}

