/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.index;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.util.CharTokenizer;

public class CodeAnalyzer
extends Analyzer {
    Map<String, Analyzer.TokenStreamComponents> fieldNameToStreamComponents = new HashMap<String, Analyzer.TokenStreamComponents>();
    private static final String[] PYTHON_KEYWORDS = new String[]{"False", "None", "True", "and", "as", "assert", "break", "class", "continue", "def", "del", "elif", "else", "except", "finally", "for", "from", "global", "if", "import", "in", "is", "lambda", "nonlocal", "not", "or", "pass", "raise", "return", "try", "while", "with", "yield"};
    private static final String[] GENERAL_STOP_WORDS = new String[]{"a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "i", "no", "not", "of", "on", "or", "s", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with", "we", "you"};

    public CodeAnalyzer() {
        this.fieldNameToStreamComponents.put("__default__", CodeAnalyzer.createDefaultComponents(new String[0]));
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Analyzer.TokenStreamComponents streamComponents = this.fieldNameToStreamComponents.get(fieldName);
        if (streamComponents != null) {
            return streamComponents;
        }
        return this.fieldNameToStreamComponents.get("__default__");
    }

    public void registerTokenizer(String fieldName, Analyzer.TokenStreamComponents tokenStream) {
        this.fieldNameToStreamComponents.put(fieldName, tokenStream);
    }

    public static Analyzer.TokenStreamComponents createDefaultComponents(String ... ignoreWords) {
        CharTokenizer src = CharTokenizer.fromTokenCharPredicate(Character::isJavaIdentifierPart);
        LowerCaseFilter tok = new LowerCaseFilter((TokenStream)src);
        CharArraySet stopWords = StopFilter.makeStopSet((String[])ignoreWords);
        tok = new StopFilter((TokenStream)tok, stopWords);
        Analyzer.TokenStreamComponents tokenStreamComponents = new Analyzer.TokenStreamComponents((Tokenizer)src, (TokenStream)tok);
        return tokenStreamComponents;
    }

    public static Analyzer.TokenStreamComponents createPythonStreamComponents() {
        return CodeAnalyzer.createDefaultComponents(PYTHON_KEYWORDS);
    }

    public static Analyzer.TokenStreamComponents createStringsOrCommentsStreamComponents() {
        return CodeAnalyzer.createDefaultComponents(GENERAL_STOP_WORDS);
    }
}

