/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.partitioner;

import org.eclipse.core.runtime.Assert;
import org.python.pydev.shared_core.partitioner.ICharacterScanner;
import org.python.pydev.shared_core.partitioner.IRule;
import org.python.pydev.shared_core.partitioner.IToken;
import org.python.pydev.shared_core.partitioner.IWhitespaceDetector;
import org.python.pydev.shared_core.partitioner.Token;

public class WhitespaceRule
implements IRule {
    protected IWhitespaceDetector fDetector;
    protected final IToken fWhitespaceToken;

    public WhitespaceRule(IWhitespaceDetector detector) {
        this(detector, Token.WHITESPACE);
    }

    public WhitespaceRule(IWhitespaceDetector detector, IToken token) {
        Assert.isNotNull((Object)detector);
        Assert.isNotNull((Object)token);
        this.fDetector = detector;
        this.fWhitespaceToken = token;
    }

    @Override
    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (this.fDetector.isWhitespace((char)c)) {
            while (this.fDetector.isWhitespace((char)(c = scanner.read()))) {
            }
            scanner.unread();
            return this.fWhitespaceToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }
}

