/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.process;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.python.pydev.shared_core.io.ThreadStreamReader;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.PlatformUtils;

public class ProcessUtils {
    public static Tuple<String, String> getProcessOutput(Process process, String executionString, IProgressMonitor monitor, String encoding) {
        boolean closeOutput = true;
        return ProcessUtils.getProcessOutput(process, executionString, monitor, encoding, closeOutput);
    }

    public static Tuple<String, String> getProcessOutput(Process process, String executionString, IProgressMonitor monitor, String encoding, boolean closeOutput) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (process != null) {
            if (closeOutput) {
                try {
                    process.getOutputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            monitor.setTaskName("Reading output...");
            monitor.worked(5);
            ThreadStreamReader std = new ThreadStreamReader(process.getInputStream(), false, encoding);
            ThreadStreamReader err = new ThreadStreamReader(process.getErrorStream(), false, encoding);
            std.start();
            err.start();
            boolean interrupted = true;
            while (interrupted) {
                interrupted = false;
                try {
                    monitor.setTaskName("Waiting for process to finish.");
                    monitor.worked(5);
                    process.waitFor();
                }
                catch (InterruptedException e1) {
                    interrupted = true;
                }
            }
            monitor.setTaskName("Process finished.");
            try {
                std.join(1000L);
            }
            catch (InterruptedException e1) {
                Log.log(e1);
            }
            try {
                err.join(1000L);
            }
            catch (InterruptedException e1) {
                Log.log(e1);
            }
            return new Tuple<String, String>(std.getContents(), err.getContents());
        }
        try {
            throw new CoreException((IStatus)new Status(4, "org.python.pydev.shared_core", "Error creating process - got null process(" + executionString + ")", (Throwable)new Exception("Error creating process - got null process.")));
        }
        catch (CoreException e) {
            Log.log(4, e.getMessage(), e);
            return new Tuple<String, CallSite>("", (CallSite)((Object)("Error creating process - got null process(" + executionString + ")")));
        }
    }

    public static Process createProcess(String[] cmdarray, String[] envp, File workingDir) throws IOException {
        return Runtime.getRuntime().exec(ProcessUtils.getWithoutEmptyParams(cmdarray), ProcessUtils.getWithoutEmptyParams(envp), workingDir);
    }

    private static String[] getWithoutEmptyParams(String[] cmdarray) {
        if (cmdarray == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = cmdarray;
        int n = cmdarray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string != null && string.length() > 0) {
                list.add(string);
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    public static Tuple<Process, String> run(String[] cmdarray, String[] envp, File workingDir, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String executionString = ProcessUtils.getArgumentsAsStr(cmdarray, new String[0]);
        monitor.setTaskName("Executing: " + executionString);
        monitor.worked(5);
        Process process = null;
        try {
            monitor.setTaskName("Making pythonpath environment..." + executionString);
            monitor.setTaskName("Making exec..." + executionString);
            if (workingDir != null && !workingDir.isDirectory()) {
                throw new RuntimeException(StringUtils.format("Working dir must be an existing directory (received: %s)", workingDir));
            }
            process = ProcessUtils.createProcess(cmdarray, envp, workingDir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new Tuple<Process, String>(process, executionString);
    }

    public static Tuple<String, String> runAndGetOutput(String[] cmdarray, String[] envp, File workingDir, IProgressMonitor monitor, String encoding) {
        Tuple<Process, String> r = ProcessUtils.run(cmdarray, envp, workingDir, monitor);
        return ProcessUtils.getProcessOutput((Process)r.o1, (String)r.o2, monitor, encoding);
    }

    public static String getArgumentsAsStr(String[] commandLine, String ... args) {
        if (args != null && args.length > 0) {
            String[] newCommandLine = new String[commandLine.length + args.length];
            System.arraycopy(commandLine, 0, newCommandLine, 0, commandLine.length);
            System.arraycopy(args, 0, newCommandLine, commandLine.length, args.length);
            commandLine = newCommandLine;
        }
        if (commandLine.length < 1) {
            return "";
        }
        FastStringBuffer buf = new FastStringBuffer();
        FastStringBuffer command = new FastStringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            if (commandLine[i] != null) {
                if (i > 0) {
                    buf.append(' ');
                }
                char[] characters = commandLine[i].toCharArray();
                command.clear();
                boolean containsSpace = false;
                int j = 0;
                while (j < characters.length) {
                    char character = characters[j];
                    if (character == '\"') {
                        command.append('\\');
                    } else if (character == ' ') {
                        containsSpace = true;
                    }
                    command.append(character);
                    ++j;
                }
                if (containsSpace) {
                    buf.append('\"');
                    buf.append(command.toString());
                    buf.append('\"');
                } else {
                    buf.append(command.toString());
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String getEnvironmentAsStr(String[] envp) {
        return StringUtils.join("\n", envp);
    }

    public static String[] getMapEnvAsArray(Map<String, String> env) {
        String[] strings = new String[env.size()];
        FastStringBuffer buffer = new FastStringBuffer();
        int i = 0;
        for (Map.Entry<String, String> entry : env.entrySet()) {
            buffer.clear().append(entry.getKey());
            buffer.append('=').append(entry.getValue());
            strings[i] = buffer.toString();
            ++i;
        }
        return strings;
    }

    public static String[] parseArguments(String args) {
        if (args == null || args.length() == 0) {
            return new String[0];
        }
        if (PlatformUtils.isWindowsPlatform()) {
            return ProcessUtils.parseArgumentsWindows(args);
        }
        return ProcessUtils.parseArgumentsImpl(args);
    }

    /*
     * Exception decompiling
     */
    private static String[] parseArgumentsImpl(String args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static String[] parseArgumentsWindows(String args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<String, String> getArrayAsMapEnv(String[] mapEnvAsArray) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        int length = mapEnvAsArray.length;
        int i = 0;
        while (i < length) {
            String s = mapEnvAsArray[i];
            int iEq = s.indexOf(61);
            if (iEq != -1) {
                map.put(s.substring(0, iEq), s.substring(iEq + 1));
            }
            ++i;
        }
        return map;
    }

    public static String[] addOrReplaceEnvVar(String[] mapEnvAsArray, String nameToReplace, String newVal) {
        int len = mapEnvAsArray.length;
        nameToReplace = (String)nameToReplace + "=";
        int i = 0;
        while (i < len) {
            String string = mapEnvAsArray[i];
            if (string.startsWith((String)nameToReplace)) {
                mapEnvAsArray[i] = (String)nameToReplace + newVal;
                return mapEnvAsArray;
            }
            ++i;
        }
        return StringUtils.addString(mapEnvAsArray, (String)nameToReplace + newVal);
    }
}

