/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.string;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.shared_core.string.ICoreTextSelection;

public class CoreTextSelection
implements ICoreTextSelection {
    private final IDocument fDocument;
    private int fOffset;
    private int fLength;

    public CoreTextSelection(int offset, int length) {
        this(null, offset, length);
    }

    public CoreTextSelection(IDocument document, int offset, int length) {
        this.fDocument = document;
        this.fOffset = offset;
        this.fLength = length;
    }

    @Override
    public int getOffset() {
        return this.fOffset;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public int getStartLine() {
        try {
            if (this.fDocument != null) {
                return this.fDocument.getLineOfOffset(this.fOffset);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public int getEndLine() {
        try {
            if (this.fDocument != null) {
                int endOffset = this.fOffset + this.fLength;
                if (this.fLength != 0) {
                    --endOffset;
                }
                return this.fDocument.getLineOfOffset(endOffset);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public String getText() {
        try {
            if (this.fDocument != null) {
                return this.fDocument.get(this.fOffset, this.fLength);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public boolean equals(Object obj) {
        boolean sameRange;
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CoreTextSelection s = (CoreTextSelection)obj;
        boolean bl = sameRange = s.fOffset == this.fOffset && s.fLength == this.fLength;
        if (sameRange) {
            if (s.fDocument == null && this.fDocument == null) {
                return true;
            }
            if (s.fDocument == null || this.fDocument == null) {
                return false;
            }
            try {
                String sContent = s.fDocument.get(this.fOffset, this.fLength);
                String content = this.fDocument.get(this.fOffset, this.fLength);
                return sContent.equals(content);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        int low = this.fDocument != null ? this.fDocument.hashCode() : 0;
        return this.fOffset << 24 | this.fLength << 16 | low;
    }

    protected IDocument getDocument() {
        return this.fDocument;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CoreTextSelection [offset: ").append(this.fOffset);
        int startLine = this.getStartLine();
        sb.append(", startLine: ").append(startLine);
        int endLine = this.getEndLine();
        if (endLine != startLine) {
            sb.append(", endLine: ").append(endLine);
        }
        sb.append(", length: ").append(this.fLength);
        if (this.fLength != 0) {
            sb.append(", text: ").append(this.getText());
        }
        if (this.fDocument != null) {
            sb.append(", document: ").append(this.fDocument);
        }
        sb.append("]");
        return sb.toString();
    }
}

