/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.shared_core.callbacks.ICallback;

public class ArrayUtils {
    public static <T> List<T> filter(T[] listToFilter, ICallback<Boolean, T> callbackThatFilters) {
        ArrayList<T> lst = new ArrayList<T>();
        T[] TArray = listToFilter;
        int n = listToFilter.length;
        int n2 = 0;
        while (n2 < n) {
            T marker = TArray[n2];
            if (callbackThatFilters.call(marker).booleanValue()) {
                lst.add(marker);
            }
            ++n2;
        }
        return lst;
    }

    public static <T> T[] concatArrays(T[] ... arrays) {
        Assert.isTrue((arrays.length > 0 ? 1 : 0) != 0, (String)"Arrays len must be > 0.");
        int count = 0;
        T[][] TArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            T[] array = TArray[n2];
            count += array.length;
            ++n2;
        }
        Object[] mergedArray = (Object[])Array.newInstance(arrays[0].getClass().getComponentType(), count);
        int start = 0;
        T[][] TArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            T[] array = TArray2[n4];
            System.arraycopy(array, 0, mergedArray, start, array.length);
            start += array.length;
            ++n4;
        }
        return mergedArray;
    }

    public static <T> T[] remove(T[] original, int element, Class componentType) {
        Object[] n = (Object[])Array.newInstance(componentType, original.length - 1);
        System.arraycopy(original, 0, n, 0, element);
        System.arraycopy(original, element + 1, n, element, original.length - element - 1);
        return n;
    }

    public static <T> int indexOf(T[] original, T element) {
        int i = 0;
        while (i < original.length) {
            if (element.equals(original)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean contains(Object[] array, Object o) {
        if (array == null) {
            return false;
        }
        return Arrays.asList(array).contains(o);
    }

    public static <T> Set<T> asSet(T ... objects) {
        return new HashSet<T>(Arrays.asList(objects));
    }

    public static int[] reversedCopy(int[] regionsForSave) {
        int[] copyOf = Arrays.copyOf(regionsForSave, regionsForSave.length);
        ArrayUtils.reverse(copyOf);
        return copyOf;
    }

    private static void reverse(int[] copyOf) {
        int length = copyOf.length;
        int middle = length / 2;
        int i = 0;
        while (i < middle) {
            int temp = copyOf[i];
            copyOf[i] = copyOf[length - i - 1];
            copyOf[length - i - 1] = temp;
            ++i;
        }
    }

    public static final class ArraysIterator<T>
    implements Iterator<T> {
        private final List<T[]> iterThroughArrays = new ArrayList<T[]>();
        private int currentArrayIndex = 0;
        private int currentElementIndex = 0;
        private boolean frozen = false;

        public void addArray(T[] array) {
            if (this.frozen) {
                throw new RuntimeException("ArraysIterator already frozen");
            }
            if (array != null) {
                this.iterThroughArrays.add(array);
            }
        }

        @Override
        public boolean hasNext() {
            this.frozen = true;
            if (this.iterThroughArrays.isEmpty()) {
                return false;
            }
            if (this.currentArrayIndex >= this.iterThroughArrays.size()) {
                return false;
            }
            T[] currentArray = this.iterThroughArrays.get(this.currentArrayIndex);
            if (this.currentElementIndex >= currentArray.length) {
                ++this.currentArrayIndex;
                this.currentElementIndex = 0;
                return this.hasNext();
            }
            return true;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T[] currentArray = this.iterThroughArrays.get(this.currentArrayIndex);
            T element = currentArray[this.currentElementIndex];
            ++this.currentElementIndex;
            return element;
        }
    }
}

