/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.utils.internal.win32;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.process.ProcessUtils;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.utils.IProcessInfo;
import org.python.pydev.shared_core.utils.IProcessList;
import org.python.pydev.shared_core.utils.internal.ProcessInfo;
import org.python.pydev.shared_core.utils.internal.win32.CSVReader;
import org.python.pydev.shared_core.utils.internal.win32.ProcessListWin32Internal;

public class ProcessListWin32
implements IProcessList {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IProcessInfo[] getProcessList() {
        try {
            return this.createFromWMIC();
        }
        catch (Exception exception) {
            Process p = null;
            InputStream in = null;
            IProcessInfo[] procInfos = new IProcessInfo[]{};
            try {
                try {
                    try {
                        p = ProcessUtils.createProcess(new String[]{"tasklist.exe", "/fo", "csv", "/nh", "/v"}, null, null);
                    }
                    catch (Exception e) {
                        IProcessInfo[] iProcessInfoArray = new ProcessListWin32Internal().getProcessList();
                        if (in != null) {
                            in.close();
                        }
                        if (p == null) return iProcessInfoArray;
                        p.destroy();
                        return iProcessInfoArray;
                    }
                    in = p.getInputStream();
                    InputStreamReader reader = new InputStreamReader(in);
                    procInfos = this.parseListTasks(reader);
                    return procInfos;
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (p != null) {
                        p.destroy();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return procInfos;
        }
    }

    private IProcessInfo[] createFromWMIC() throws Exception {
        Process p = ProcessUtils.createProcess(new String[]{"wmic.exe", "path", "win32_process", "get", "Caption,Processid,Commandline"}, null, null);
        ArrayList<ProcessInfo> lst = new ArrayList<ProcessInfo>();
        InputStream in = p.getInputStream();
        InputStreamReader reader = new InputStreamReader(in);
        try {
            BufferedReader br = new BufferedReader(reader);
            String line = br.readLine();
            int commandLineI = line.indexOf("CommandLine");
            int processIdI = line.indexOf("ProcessId");
            if (commandLineI == -1) {
                throw new AssertionError((Object)("Could not find CommandLine in: " + line));
            }
            if (processIdI == -1) {
                throw new AssertionError((Object)("Could not find ProcessId in: " + line));
            }
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                try {
                    String name = line.substring(0, commandLineI).trim();
                    String commandLine = line.substring(commandLineI, processIdI).trim();
                    String processId = line.substring(processIdI, line.length()).trim();
                    lst.add(new ProcessInfo(Integer.parseInt(processId), name + "   " + commandLine));
                }
                catch (Exception exception) {}
            }
            if (lst.size() == 0) {
                throw new AssertionError((Object)"Error: no processes found");
            }
            IProcessInfo[] iProcessInfoArray = lst.toArray(new IProcessInfo[0]);
            return iProcessInfoArray;
        }
        catch (Exception e) {
            Log.log(e);
            throw e;
        }
        finally {
            in.close();
        }
    }

    public IProcessInfo[] parseListTasks(InputStreamReader reader) {
        String[] next;
        BufferedReader br = new BufferedReader(reader);
        CSVReader csvReader = new CSVReader(br);
        ArrayList<ProcessInfo> processList = new ArrayList<ProcessInfo>();
        do {
            try {
                next = csvReader.readNext();
                if (next == null) continue;
                int pid = Integer.parseInt(next[1]);
                String name = StringUtils.join(" - ", next[0], next[next.length - 1]);
                processList.add(new ProcessInfo(pid, name));
            }
            catch (IOException e) {
                break;
            }
        } while (next != null);
        return processList.toArray(new IProcessInfo[processList.size()]);
    }

    public static void main(String[] args) {
        IProcessInfo[] processList;
        IProcessInfo[] iProcessInfoArray = processList = new ProcessListWin32().getProcessList();
        int n = processList.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessInfo iProcessInfo = iProcessInfoArray[n2];
            System.out.println(iProcessInfo);
            ++n2;
        }
    }
}

