/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.django.debug.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.python.pydev.ast.runners.SimpleRunner;
import org.python.pydev.django.debug.ui.actions.DjangoAction;
import org.python.pydev.plugin.nature.PythonNature;

public class DjangoWar
extends DjangoAction {
    @Override
    public void run(IAction action) {
        try {
            PythonNature nature = PythonNature.getPythonNature((IProject)this.selectedProject);
            if (nature.getInterpreterType() != 1) {
                MessageDialog.openInformation(null, (String)"Can't create WAR", (String)"Creation of WAR packages is only supported on Jython");
                return;
            }
            Object javaLibs = null;
            for (String path : nature.getPythonPathNature().getOnlyProjectPythonPathStr(true, true)) {
                if (!path.endsWith(".jar")) continue;
                if (javaLibs == null) {
                    javaLibs = path;
                    continue;
                }
                javaLibs = (String)javaLibs + SimpleRunner.getPythonPathSeparator();
                javaLibs = (String)javaLibs + path;
            }
            Object command = "war";
            if (javaLibs != null) {
                command = (String)command + " --include-java-libs=" + javaLibs;
            }
            this.launchDjangoCommand((String)command, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

