/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.django.ui;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.python.pydev.ast.codecompletion.revisited.ProjectModulesManager;
import org.python.pydev.core.BaseModuleRequest;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.string.StringUtils;

public class DjangoProjectProperties
extends PropertyPage {
    private IProject project;
    private Text textDjangoSettings;
    private Text textDjangoManage;
    private Label labelErrorSettings;
    private Label labelErrorManage;

    protected Control createContents(Composite parent) {
        Composite topComp;
        block7: {
            this.project = (IProject)this.getElement().getAdapter(IProject.class);
            topComp = new Composite(parent, 0);
            GridLayout innerLayout = new GridLayout();
            innerLayout.numColumns = 2;
            innerLayout.marginHeight = 0;
            innerLayout.marginWidth = 0;
            topComp.setLayout((Layout)innerLayout);
            GridData gd = new GridData(1808);
            topComp.setLayoutData((Object)gd);
            if (this.project != null) {
                try {
                    Text text;
                    IPythonPathNature pathNature = PythonNature.getPythonPathNature((IProject)this.project);
                    final PythonNature nature = PythonNature.getPythonNature((IProject)this.project);
                    Map variableSubstitution = pathNature.getVariableSubstitution(false);
                    Label label = new Label(topComp, 0);
                    label.setText("Django manage.py");
                    this.textDjangoManage = text = new Text(topComp, 2048);
                    this.textDjangoManage.setToolTipText("This is the name of the project-relative location of manage.py (i.e.: src/myapp/manage.py)");
                    label = new Label(topComp, 0);
                    this.labelErrorManage = new Label(topComp, 0);
                    this.labelErrorManage.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                    ModifyListener manageValidator = new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            try {
                                String path = DjangoProjectProperties.this.textDjangoManage.getText().trim();
                                if (path.trim().length() == 0) {
                                    DjangoProjectProperties.this.labelErrorSettings.setText("Please specify the manage.py relative name (i.e.: src/myapp/manage.py)");
                                    return;
                                }
                                IFile file = DjangoProjectProperties.this.project.getFile((IPath)new Path(path));
                                if (!file.exists()) {
                                    DjangoProjectProperties.this.labelErrorManage.setText(StringUtils.format((String)"File: %s could not be found.", (Object[])new Object[]{path}));
                                } else {
                                    DjangoProjectProperties.this.labelErrorManage.setText("");
                                }
                            }
                            catch (Exception e1) {
                                Log.log((Throwable)e1);
                            }
                        }
                    };
                    text.addModifyListener(manageValidator);
                    text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                    String string = (String)variableSubstitution.get("DJANGO_MANAGE_LOCATION");
                    if (string != null) {
                        text.setText(string);
                    } else {
                        text.setText("");
                    }
                    label = new Label(topComp, 0);
                    label.setText("Django settings module");
                    this.textDjangoSettings = text = new Text(topComp, 2048);
                    this.textDjangoSettings.setToolTipText("This is the name of the django settings module (i.e.: myapp.settings)");
                    label = new Label(topComp, 0);
                    this.labelErrorSettings = new Label(topComp, 0);
                    this.labelErrorSettings.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                    ModifyListener settingsValidator = new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            try {
                                String moduleName = DjangoProjectProperties.this.textDjangoSettings.getText().trim();
                                if (moduleName.trim().length() == 0) {
                                    DjangoProjectProperties.this.labelErrorSettings.setText("Please specify the name of the module (i.e.: myapp.settings)");
                                    return;
                                }
                                ICodeCompletionASTManager astManager = nature.getAstManager();
                                ProjectModulesManager modulesManager = (ProjectModulesManager)astManager.getModulesManager();
                                IModule moduleInDirectManager = modulesManager.getModuleInDirectManager(moduleName, (IPythonNature)nature, true, (IModuleRequestState)new BaseModuleRequest(false));
                                if (moduleInDirectManager == null) {
                                    DjangoProjectProperties.this.labelErrorSettings.setText(StringUtils.format((String)"Module: %s could not be found.", (Object[])new Object[]{moduleName}));
                                } else {
                                    DjangoProjectProperties.this.labelErrorSettings.setText("");
                                }
                            }
                            catch (Exception e1) {
                                Log.log((Throwable)e1);
                            }
                        }
                    };
                    text.addModifyListener(settingsValidator);
                    text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                    string = (String)variableSubstitution.get("DJANGO_SETTINGS_MODULE");
                    if (string != null) {
                        text.setText(string);
                        break block7;
                    }
                    text.setText("");
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            } else {
                Label label = new Label(topComp, 0);
                label.setText("Internal error: project not set!");
            }
        }
        return topComp;
    }

    public void dispose() {
        super.dispose();
        if (this.textDjangoManage != null) {
            this.textDjangoManage.dispose();
            this.textDjangoManage = null;
        }
        if (this.textDjangoSettings != null) {
            this.textDjangoSettings.dispose();
            this.textDjangoSettings = null;
        }
    }

    public boolean performOk() {
        try {
            IPythonPathNature pythonPathNature = PythonNature.getPythonPathNature((IProject)this.project);
            Map variableSubstitution = pythonPathNature.getVariableSubstitution(false);
            boolean changed = this.update("DJANGO_MANAGE_LOCATION", variableSubstitution, this.textDjangoManage.getText(), pythonPathNature);
            boolean bl = changed = this.update("DJANGO_SETTINGS_MODULE", variableSubstitution, this.textDjangoSettings.getText(), pythonPathNature) || changed;
            if (changed) {
                pythonPathNature.setVariableSubstitution(variableSubstitution);
                PythonNature pythonNature = PythonNature.getPythonNature((IProject)this.project);
                if (pythonNature != null && (changed || pythonNature.getAstManager() == null)) {
                    pythonNature.rebuildPath();
                }
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return true;
    }

    private boolean update(String varName, Map<String, String> currVariableSubstitution, String text, IPythonPathNature pythonPathNature) {
        boolean changed = false;
        String currVal = currVariableSubstitution.get(varName);
        String trimmed = text.trim();
        if (currVal == null) {
            changed = trimmed.length() != 0;
        } else {
            boolean bl = changed = !currVal.equals(trimmed);
        }
        if (changed) {
            if (trimmed.length() == 0) {
                currVariableSubstitution.remove(varName);
            } else {
                currVariableSubstitution.put(varName, trimmed);
            }
        }
        return changed;
    }
}

