/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.codegenerator.generateproperties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.ast.adapters.IClassDefAdapter;
import org.python.pydev.ast.refactoring.RefactoringInfo;
import org.python.pydev.refactoring.codegenerator.generateproperties.GeneratePropertiesChangeProcessor;
import org.python.pydev.refactoring.codegenerator.generateproperties.GeneratePropertiesRequestProcessor;
import org.python.pydev.refactoring.core.base.AbstractPythonRefactoring;
import org.python.pydev.refactoring.core.change.IChangeProcessor;
import org.python.pydev.refactoring.messages.Messages;

public class GeneratePropertiesRefactoring
extends AbstractPythonRefactoring {
    private GeneratePropertiesRequestProcessor requestProcessor;
    private IChangeProcessor changeProcessor;

    public GeneratePropertiesRefactoring(RefactoringInfo req) {
        super(req);
        try {
            this.initWizard();
        }
        catch (Throwable e) {
            this.status.addInfo(Messages.infoFixCode);
        }
    }

    private void initWizard() throws Throwable {
        this.requestProcessor = new GeneratePropertiesRequestProcessor(this.info.getAdapterPrefs());
        this.changeProcessor = new GeneratePropertiesChangeProcessor(this.getName(), this.info, this.requestProcessor);
    }

    @Override
    protected List<IChangeProcessor> getChangeProcessors() {
        ArrayList<IChangeProcessor> processors = new ArrayList<IChangeProcessor>();
        processors.add(this.changeProcessor);
        return processors;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        List classes = this.info.getClasses();
        for (IClassDefAdapter adapter : classes) {
            if (adapter.getAttributes().isEmpty()) continue;
            return super.checkInitialConditions(pm);
        }
        this.status.addFatalError(Messages.generatePropertiesUnavailable);
        return this.status;
    }

    public String getName() {
        return Messages.generatePropertiesLabel;
    }

    public GeneratePropertiesRequestProcessor getRequestProcessor() {
        return this.requestProcessor;
    }
}

