/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.codegenerator.overridemethods.edit;

import org.python.pydev.ast.adapters.FunctionDefAdapter;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Pass;
import org.python.pydev.parser.jython.ast.factory.PyAstFactory;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.prettyprinterv2.MakeAstValidForPrettyPrintingVisitor;
import org.python.pydev.refactoring.codegenerator.overridemethods.request.OverrideMethodsRequest;
import org.python.pydev.refactoring.core.edit.AbstractInsertEdit;

public class MethodEdit
extends AbstractInsertEdit {
    private int offsetStrategy;
    private FunctionDefAdapter method;

    public MethodEdit(OverrideMethodsRequest req) {
        super(req);
        this.method = req.method;
        this.offsetStrategy = req.offsetStrategy;
    }

    @Override
    protected SimpleNode getEditNode() {
        FunctionDef origin = (FunctionDef)this.method.getASTNode();
        PyAstFactory factory = new PyAstFactory(this.adapterPrefs);
        stmtType overrideBody = factory.createOverrideBody(origin);
        FunctionDef functionDef = origin.createCopy(false);
        functionDef.body = new stmtType[]{overrideBody != null ? overrideBody : new Pass()};
        try {
            MakeAstValidForPrettyPrintingVisitor.makeValid((SimpleNode)functionDef);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return functionDef;
    }

    @Override
    public int getOffsetStrategy() {
        return this.offsetStrategy;
    }
}

