/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.coderefactoring.extractlocal.edit;

import java.util.List;
import org.python.pydev.ast.adapters.ModuleAdapter;
import org.python.pydev.ast.codecompletion.revisited.visitors.FindScopeVisitor;
import org.python.pydev.ast.refactoring.RefactoringInfo;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.Visitor;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.visitors.scope.GetNodeForExtractLocalVisitor;
import org.python.pydev.refactoring.coderefactoring.extractlocal.request.ExtractLocalRequest;
import org.python.pydev.refactoring.core.edit.AbstractInsertEdit;
import org.python.pydev.shared_core.string.ICoreTextSelection;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_core.structure.Tuple;

public class CreateLocalVariableEdit
extends AbstractInsertEdit {
    private RefactoringInfo info;
    private String variableName;
    private exprType expression;
    private int lineForLocal = -1;
    private boolean replaceDuplicates;
    private List<Tuple<ICoreTextSelection, SimpleNode>> duplicates;

    public CreateLocalVariableEdit(ExtractLocalRequest req) {
        super(req);
        this.info = req.info;
        this.variableName = req.variableName;
        this.expression = (exprType)req.expression.createCopy();
        this.replaceDuplicates = req.replaceDuplicates;
        this.duplicates = req.duplicates;
    }

    @Override
    protected SimpleNode getEditNode() {
        Name variable = new Name(this.variableName, 2, false);
        exprType[] target = new exprType[]{variable};
        return new Assign(target, this.expression, null);
    }

    private int calculateLineForLocal() {
        if (this.lineForLocal == -1) {
            Module module;
            ICoreTextSelection userSelection = this.info.getSelectionComputer((RefactoringInfo.SelectionComputer.SelectionComputerKind)RefactoringInfo.SelectionComputer.SelectionComputerKind.inline).selection;
            if (this.replaceDuplicates) {
                for (Tuple<ICoreTextSelection, SimpleNode> dup : this.duplicates) {
                    if (((ICoreTextSelection)dup.o1).getStartLine() >= userSelection.getStartLine()) continue;
                    userSelection = (ICoreTextSelection)dup.o1;
                }
            }
            PySelection selection = new PySelection(this.info.getDocument(), userSelection);
            int startLineIndexIndocCoords = selection.getStartLineIndex();
            int startLineIndexInASTCoords = startLineIndexIndocCoords + 1;
            ModuleAdapter modAdapter = this.info.getModuleAdapter();
            Module currentScope = module = (Module)modAdapter.getASTNode();
            try {
                FindScopeVisitor scopeVisitor = new FindScopeVisitor(startLineIndexInASTCoords, selection.getCursorColumn() + 1, this.info.getNature(), modAdapter.getIModule());
                module.accept((VisitorIF)scopeVisitor);
                ILocalScope scope = scopeVisitor.scope;
                FastStack scopeStack = scope.getScopeStack();
                currentScope = (SimpleNode)scopeStack.peek();
            }
            catch (Exception e1) {
                Log.log((Throwable)e1);
            }
            GetNodeForExtractLocalVisitor visitor = new GetNodeForExtractLocalVisitor(startLineIndexInASTCoords);
            try {
                currentScope.accept((VisitorIF)visitor);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            SimpleNode lastNodeBeforePassedLine = visitor.getLastInContextBeforePassedLine();
            if (lastNodeBeforePassedLine != null) {
                final int[] line = new int[]{Integer.MAX_VALUE};
                try {
                    Visitor v = new Visitor(){

                        protected Object unhandled_node(SimpleNode node) throws Exception {
                            if (node.beginLine > 0) {
                                line[0] = Math.min(line[0], node.beginLine - 1);
                            } else {
                                Log.log((String)("Found node with beginLine <= 0:" + String.valueOf(node) + " line: " + node.beginLine));
                            }
                            return this;
                        }
                    };
                    lastNodeBeforePassedLine.accept((VisitorIF)v);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
                this.lineForLocal = line[0] != Integer.MAX_VALUE ? line[0] : lastNodeBeforePassedLine.beginLine - 1;
            } else {
                this.lineForLocal = startLineIndexIndocCoords;
            }
            if (this.lineForLocal > startLineIndexIndocCoords) {
                this.lineForLocal = startLineIndexIndocCoords;
            }
        }
        return this.lineForLocal;
    }

    @Override
    public int getOffset() {
        PySelection selection = new PySelection(this.info.getDocument(), this.calculateLineForLocal(), 0);
        return selection.getStartLineOffset();
    }

    @Override
    public int getOffsetStrategy() {
        return 0;
    }

    @Override
    public String getIndent() {
        PySelection selection = new PySelection(this.info.getDocument(), this.calculateLineForLocal(), 0);
        return selection.getIndentationFromLine();
    }
}

