/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.coderefactoring.extractmethod;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.ast.adapters.IClassDefAdapter;
import org.python.pydev.ast.adapters.ModuleAdapter;
import org.python.pydev.ast.adapters.visitors.VisitorFactory;
import org.python.pydev.ast.adapters.visitors.selection.SelectionException;
import org.python.pydev.ast.refactoring.RefactoringInfo;
import org.python.pydev.core.log.Log;
import org.python.pydev.refactoring.coderefactoring.extractmethod.ExtractMethodChangeProcessor;
import org.python.pydev.refactoring.coderefactoring.extractmethod.ExtractMethodRequestProcessor;
import org.python.pydev.refactoring.core.base.AbstractPythonRefactoring;
import org.python.pydev.refactoring.core.change.IChangeProcessor;
import org.python.pydev.refactoring.messages.Messages;

public class ExtractMethodRefactoring
extends AbstractPythonRefactoring {
    private ExtractMethodRequestProcessor requestProcessor;
    private IChangeProcessor changeProcessor;
    private final ModuleAdapter module;

    public ExtractMethodRefactoring(RefactoringInfo req) {
        super(req);
        this.module = req.getModuleAdapter();
    }

    @Override
    protected List<IChangeProcessor> getChangeProcessors() {
        ArrayList<IChangeProcessor> processors = new ArrayList<IChangeProcessor>();
        this.changeProcessor = new ExtractMethodChangeProcessor(this.getName(), this.info, this.requestProcessor);
        processors.add(this.changeProcessor);
        return processors;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringInfo.SelectionComputer selectionComputer = this.info.getSelectionComputer(RefactoringInfo.SelectionComputer.SelectionComputerKind.extractMethod);
        if (selectionComputer.selection == null) {
            this.status.addFatalError(Messages.extractMethodIncompleteSelection);
            return this.status;
        }
        try {
            VisitorFactory.validateSelection((ModuleAdapter)selectionComputer.selectionModuleAdapter);
        }
        catch (SelectionException e) {
            this.status.addFatalError(e.getMessage());
            return this.status;
        }
        try {
            this.requestProcessor = new ExtractMethodRequestProcessor(this.info.getScopeAdapter(), selectionComputer.selectionModuleAdapter, this.module, selectionComputer.selection);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
            this.status.addFatalError("Unexpected exception: " + e.getMessage());
        }
        if (this.requestProcessor.getScopeAdapter() == null || this.requestProcessor.getScopeAdapter() instanceof IClassDefAdapter) {
            this.status.addFatalError(Messages.extractMethodScopeInvalid);
            return this.status;
        }
        return this.status;
    }

    public String getName() {
        return Messages.extractMethodLabel;
    }

    public ExtractMethodRequestProcessor getRequestProcessor() {
        return this.requestProcessor;
    }
}

