/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.coderefactoring.extractmethod.edit;

import java.util.ArrayList;
import java.util.List;
import org.python.pydev.ast.adapters.IASTNodeAdapter;
import org.python.pydev.ast.adapters.IClassDefAdapter;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.factory.PyAstFactory;
import org.python.pydev.refactoring.coderefactoring.extractmethod.request.ExtractMethodRequest;
import org.python.pydev.refactoring.core.edit.AbstractReplaceEdit;

public class ExtractCallEdit
extends AbstractReplaceEdit {
    private String methodName;
    private int offset;
    private IASTNodeAdapter<?> offsetAdapter;
    private int replaceLength;
    private List<String> callParameters;
    private List<String> returnVariables;

    public ExtractCallEdit(ExtractMethodRequest req) {
        super(req);
        this.methodName = req.methodName;
        this.offset = req.selection.getOffset();
        this.replaceLength = req.selection.getLength();
        this.offsetAdapter = req.getOffsetNode();
        this.callParameters = req.parameters;
        this.returnVariables = req.returnVariables;
    }

    @Override
    protected SimpleNode getEditNode() {
        List<exprType> argsList = this.initCallArguments();
        Call methodCall = new Call(this.createCallAttribute(), argsList.toArray(PyAstFactory.EMPTY_EXPR_TYPE), null, null, null);
        return this.initSubstituteCall(methodCall);
    }

    private SimpleNode initSubstituteCall(Call methodCall) {
        if (this.returnVariables.size() == 0) {
            return methodCall;
        }
        ArrayList<Name> returnExpr = new ArrayList<Name>();
        for (String returnVar : this.returnVariables) {
            returnExpr.add(new Name(returnVar, 2, false));
        }
        exprType[] expr = returnExpr.toArray(PyAstFactory.EMPTY_EXPR_TYPE);
        if (expr.length > 1) {
            expr = new exprType[]{new Tuple(expr, 1, false)};
        }
        return new Assign(expr, (exprType)methodCall, null);
    }

    private List<exprType> initCallArguments() {
        ArrayList<exprType> argsList = new ArrayList<exprType>();
        for (String parameter : this.callParameters) {
            argsList.add((exprType)new Name(parameter, 1, false));
        }
        return argsList;
    }

    private exprType createCallAttribute() {
        if (this.offsetAdapter instanceof IClassDefAdapter) {
            return new Attribute((exprType)new Name("self", 1, false), (NameTokType)new NameTok(this.methodName, 8), 1);
        }
        return new Name(this.methodName, 1, false);
    }

    @Override
    public int getOffsetStrategy() {
        return 0;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    protected int getReplaceLength() {
        return this.replaceLength;
    }
}

