/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ui.pages.extractmethod;

import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.python.pydev.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.core.validator.NameValidator;
import org.python.pydev.refactoring.ui.pages.core.SimpleTableItem;
import org.python.pydev.refactoring.ui.pages.listener.IValidationPage;

public class VariableCellValidator {
    private Table table;
    private IValidationPage page;
    private AbstractScopeNode<?> scope;

    public VariableCellValidator(IValidationPage page, Table table, AbstractScopeNode<?> scope) {
        assert (page != null);
        assert (table != null);
        assert (scope != null);
        this.page = page;
        this.table = table;
        this.scope = scope;
    }

    private boolean hasUniqueArguments() {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.table.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem outer = tableItemArray[n2];
            TableItem[] tableItemArray2 = items;
            int n3 = items.length;
            int n4 = 0;
            while (n4 < n3) {
                TableItem inner = tableItemArray2[n4];
                if (outer != inner && outer.getText().equals(inner.getText())) {
                    this.page.setErrorMessage("Variable name " + outer.getText() + " was already used");
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    private void validateArguments() {
        TableItem[] items;
        RefactoringStatus status = new RefactoringStatus();
        NameValidator validator = new NameValidator(status, this.scope);
        TableItem[] tableItemArray = items = this.table.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleTableItem variableItem;
            TableItem item = tableItemArray[n2];
            if (item instanceof SimpleTableItem && (variableItem = (SimpleTableItem)item).hasNewName()) {
                validator.validateVariableName(item.getText());
                validator.validateUniqueVariable(item.getText());
            }
            ++n2;
        }
        if (status.hasError()) {
            this.page.setErrorMessage(status.getMessageMatchingSeverity(2));
        }
    }

    public void validate() {
        this.validateArguments();
        this.hasUniqueArguments();
    }
}

