/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.hyperlink;

import com.python.pydev.refactoring.hyperlink.PythonHyperlink;
import com.python.pydev.refactoring.hyperlink.PythonWordFinder;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.parser.visitors.PythonLanguageUtils;

public class PythonElementHyperlinkDetector
extends AbstractHyperlinkDetector {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null || !(textEditor instanceof PyEdit)) {
            return null;
        }
        PyEdit editor = (PyEdit)textEditor;
        int offset = region.getOffset();
        try {
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            IRegion wordRegion = PythonWordFinder.findWord(document, offset);
            if (wordRegion == null) {
                return null;
            }
            try {
                IDocument doc = editor.getDocument();
                String selectedWord = doc.get(wordRegion.getOffset(), wordRegion.getLength());
                if (PythonLanguageUtils.isKeyword((String)selectedWord)) {
                    return null;
                }
            }
            catch (BadLocationException e) {
                Log.log((Throwable)e);
            }
            if (wordRegion.getLength() == 0) {
                return null;
            }
            return new IHyperlink[]{new PythonHyperlink(wordRegion, editor)};
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return null;
        }
    }
}

