/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.ui.findreplace;

import com.python.pydev.refactoring.ui.findreplace.FindInOpenDocuments;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.IOfflineActionWithParameters;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.PySelectionFromEditor;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.EditorUtils;

public class PySearchInOpenDocumentsAction
extends Action
implements IOfflineActionWithParameters {
    private List<String> parameters;
    private PyEdit edit;

    public PySearchInOpenDocumentsAction(PyEdit edit) {
        this.edit = edit;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public void run() {
        InputDialog d;
        int retCode;
        IDialogSettings settings = TextEditorPlugin.getDefault().getDialogSettings();
        IDialogSettings s = settings.getSection("org.eclipse.ui.texteditor.FindReplaceDialog");
        boolean caseSensitive = false;
        boolean wholeWord = false;
        boolean isRegEx = false;
        if (s != null) {
            caseSensitive = s.getBoolean("casesensitive");
            wholeWord = s.getBoolean("wholeword");
            isRegEx = s.getBoolean("isRegEx");
        }
        Object searchText = "";
        if (this.parameters != null) {
            searchText = StringUtils.join((String)" ", this.parameters);
        }
        if (((String)searchText).length() == 0) {
            PySelection ps = PySelectionFromEditor.createPySelectionFromEditor((ITextEditor)this.edit);
            try {
                searchText = ps.getSelectedText();
            }
            catch (BadLocationException e) {
                searchText = "";
            }
        }
        IStatusLineManager statusLineManager = this.edit.getStatusLineManager();
        if (((String)searchText).length() == 0 && (retCode = (d = new InputDialog(EditorUtils.getShell(), "Text to search", "Enter text to search.", "", null)).open()) == 0) {
            searchText = d.getValue();
        }
        if (((String)searchText).length() >= 0) {
            if (wholeWord && !isRegEx && this.isWord((String)searchText)) {
                isRegEx = true;
                searchText = "\\b" + (String)searchText + "\\b";
            }
            FindInOpenDocuments.findInOpenDocuments((String)searchText, caseSensitive, wholeWord, isRegEx, statusLineManager);
        }
    }

    private boolean isWord(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < str.length()) {
            if (!Character.isJavaIdentifierPart(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

