/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.overview_ruler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.projection.AnnotationBag;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.shared_core.log.Log;

public class CopiedOverviewRuler
implements IOverviewRuler {
    private static final boolean IS_MAC = Util.isMac();
    private static final int INSET = 2;
    private static final int ANNOTATION_HEIGHT = 4;
    private static boolean ANNOTATION_HEIGHT_SCALABLE = true;
    private IAnnotationModel fModel;
    protected ITextViewer fTextViewer;
    protected Canvas fCanvas;
    private Canvas fHeader;
    private Image fBuffer;
    private InternalListener fInternalListener = new InternalListener();
    protected int fWidth;
    private Cursor fHitDetectionCursor;
    private Cursor fLastCursor;
    private int fLastMouseButtonActivityLine = -1;
    private int fAnnotationHeight = -1;
    private IAnnotationAccess fAnnotationAccess;
    private HeaderPainter fHeaderPainter;
    private Set fConfiguredAnnotationTypes = new HashSet();
    private Set fConfiguredHeaderAnnotationTypes = new HashSet();
    private Map fAnnotationTypes2Colors = new HashMap();
    private ISharedTextColors fSharedTextColors;
    private List fAnnotationsSortedByLayer = new ArrayList();
    private List fLayersSortedByLayer = new ArrayList();
    private Map fAllowedAnnotationTypes = new HashMap();
    private Map fAllowedHeaderAnnotationTypes = new HashMap();
    private List fCachedAnnotations = new ArrayList();
    private Object fRunnableLock = new Object();
    private boolean fIsRunnablePosted = false;
    private Runnable fRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = CopiedOverviewRuler.this.fRunnableLock;
            synchronized (object) {
                CopiedOverviewRuler.this.fIsRunnablePosted = false;
            }
            CopiedOverviewRuler.this.redraw();
            CopiedOverviewRuler.this.updateHeader();
        }
    };
    private boolean fIsTemporaryAnnotationDiscolored;

    public CopiedOverviewRuler(IAnnotationAccess annotationAccess, int width, ISharedTextColors sharedColors) {
        this(annotationAccess, width, sharedColors, false);
    }

    public CopiedOverviewRuler(IAnnotationAccess annotationAccess, int width, ISharedTextColors sharedColors, boolean discolorTemporaryAnnotation) {
        this.fAnnotationAccess = annotationAccess;
        this.fWidth = width;
        this.fSharedTextColors = sharedColors;
        this.fIsTemporaryAnnotationDiscolored = discolorTemporaryAnnotation;
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public int getWidth() {
        return this.fWidth;
    }

    public void setModel(IAnnotationModel model) {
        if (model != this.fModel || model != null) {
            if (this.fModel != null) {
                this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
            }
            this.fModel = model;
            if (this.fModel != null) {
                this.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
            }
            this.update();
        }
    }

    public Control createControl(Composite parent, ITextViewer textViewer) {
        this.fTextViewer = textViewer;
        this.fHitDetectionCursor = parent.getDisplay().getSystemCursor(21);
        this.fHeader = new Canvas(parent, 0);
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            this.fHeader.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent e) {
                    CopiedOverviewRuler.this.updateHeaderToolTipText();
                }
            });
        }
        this.fCanvas = new Canvas(parent, 262144);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (CopiedOverviewRuler.this.fTextViewer != null) {
                    CopiedOverviewRuler.this.doubleBufferPaint(event.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                CopiedOverviewRuler.this.handleDispose();
                CopiedOverviewRuler.this.fTextViewer = null;
            }
        });
        this.fCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                CopiedOverviewRuler.this.handleMouseDown(event);
            }

            public void mouseUp(MouseEvent event) {
                CopiedOverviewRuler.this.handleMouseUp(event);
            }
        });
        this.fCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                CopiedOverviewRuler.this.handleMouseMove(event);
            }
        });
        if (this.fTextViewer != null) {
            this.fTextViewer.addTextListener((ITextListener)this.fInternalListener);
        }
        return this.fCanvas;
    }

    protected void handleDispose() {
        if (this.fTextViewer != null) {
            this.fTextViewer.removeTextListener((ITextListener)this.fInternalListener);
            this.fTextViewer = null;
        }
        if (this.fModel != null) {
            this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
        this.fConfiguredAnnotationTypes.clear();
        this.fAllowedAnnotationTypes.clear();
        this.fConfiguredHeaderAnnotationTypes.clear();
        this.fAllowedHeaderAnnotationTypes.clear();
        this.fAnnotationTypes2Colors.clear();
        this.fAnnotationsSortedByLayer.clear();
        this.fLayersSortedByLayer.clear();
    }

    protected void doubleBufferPaint(GC dest) {
        Point size = this.fCanvas.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            Rectangle r = this.fBuffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.fBuffer);
        try {
            gc.setBackground(this.fCanvas.getBackground());
            gc.fillRectangle(0, 0, size.x, size.y);
            this.cacheAnnotations();
            this.doPaint1(gc);
        }
        finally {
            gc.dispose();
        }
        dest.drawImage(this.fBuffer, 0, 0);
    }

    private void cacheAnnotations() {
        this.fCachedAnnotations.clear();
        if (this.fModel != null) {
            Iterator iter = this.fModel.getAnnotationIterator();
            while (iter.hasNext()) {
                Annotation annotation = (Annotation)iter.next();
                if (annotation.isMarkedDeleted() || this.skip(annotation.getType())) continue;
                this.fCachedAnnotations.add(annotation);
            }
        }
    }

    protected void doPaint1(GC gc) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        int hh = 4;
        ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
        IDocument document = this.fTextViewer.getDocument();
        StyledText textWidget = this.fTextViewer.getTextWidget();
        int maxLines = this.getLineCount(textWidget);
        Point size = this.fCanvas.getSize();
        for (Object annotationType : this.fAnnotationsSortedByLayer) {
            if (this.skip(annotationType)) continue;
            int[] style = new int[]{4, 2};
            int t = 0;
            while (t < style.length) {
                FilterIterator e = new FilterIterator(annotationType, style[t], this.fCachedAnnotations.iterator());
                boolean areColorsComputed = false;
                Color fill = null;
                Color stroke = null;
                while (e.hasNext()) {
                    IRegion widgetRegion;
                    Annotation a = (Annotation)e.next();
                    Position p = this.fModel.getPosition(a);
                    if (p == null || (widgetRegion = extension.modelRange2WidgetRange((IRegion)new Region(p.getOffset(), p.getLength()))) == null) continue;
                    try {
                        if (ANNOTATION_HEIGHT_SCALABLE) {
                            int numbersOfLines = document.getNumberOfLines(p.getOffset(), p.getLength());
                            IRegion lastLine = document.getLineInformationOfOffset(p.getOffset() + p.getLength());
                            if (lastLine.getOffset() == p.getOffset() + p.getLength()) {
                                hh = (numbersOfLines -= 2) * size.y / maxLines + 4;
                                if (hh < 4) {
                                    hh = 4;
                                }
                            } else {
                                hh = 4;
                            }
                        }
                        this.fAnnotationHeight = hh;
                        int startLine = textWidget.getLineAtOffset(widgetRegion.getOffset());
                        int yy = Math.min(startLine * size.y / maxLines, size.y - hh);
                        if (!areColorsComputed) {
                            fill = this.getFillColor(annotationType, style[t] == 2);
                            stroke = this.getStrokeColor(annotationType, style[t] == 2);
                            areColorsComputed = true;
                        }
                        if (fill != null) {
                            gc.setBackground(fill);
                            gc.fillRectangle(2, yy, size.x - 4, hh);
                        }
                        if (stroke == null) continue;
                        gc.setForeground(stroke);
                        r.x = 2;
                        r.y = yy;
                        if (yy + hh == size.y) {
                            --r.y;
                        }
                        r.width = size.x - 4;
                        r.height = hh;
                        gc.setLineWidth(0);
                        gc.drawRectangle(r);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++t;
            }
        }
    }

    protected int getLineCount(StyledText textWidget) {
        int lineCount = textWidget.getLineCount();
        if (lineCount < 100) {
            lineCount = 100;
        }
        return lineCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Display d;
        if (this.fCanvas != null && !this.fCanvas.isDisposed() && (d = this.fCanvas.getDisplay()) != null) {
            Object object = this.fRunnableLock;
            synchronized (object) {
                if (this.fIsRunnablePosted) {
                    return;
                }
                this.fIsRunnablePosted = true;
            }
            d.asyncExec(this.fRunnable);
        }
    }

    protected void redraw() {
        if (this.fTextViewer == null || this.fModel == null) {
            return;
        }
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            try {
                this.fCanvas.redraw();
                this.fCanvas.update();
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    protected int[] toLineNumbers(int y_coordinate) {
        StyledText textWidget = this.fTextViewer.getTextWidget();
        int maxLines = this.getLineCount(textWidget);
        int rulerLength = this.fCanvas.getSize().y;
        int writable = rulerLength;
        if (y_coordinate >= writable || y_coordinate >= rulerLength) {
            return new int[]{-1, -1};
        }
        int[] lines = new int[2];
        int pixel0 = Math.max(y_coordinate - 1, 0);
        int pixel1 = Math.min(rulerLength, y_coordinate + 1);
        rulerLength = Math.max(rulerLength, 1);
        lines[0] = pixel0 * maxLines / rulerLength;
        lines[1] = pixel1 * maxLines / rulerLength;
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            lines[0] = extension.widgetLine2ModelLine(lines[0]);
            lines[1] = extension.widgetLine2ModelLine(lines[1]);
        } else {
            try {
                IRegion visible = this.fTextViewer.getVisibleRegion();
                int lineNumber = this.fTextViewer.getDocument().getLineOfOffset(visible.getOffset());
                lines[0] = lines[0] + lineNumber;
                lines[1] = lines[1] + lineNumber;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return lines;
    }

    protected Position getAnnotationPosition(int[] lineNumbers) {
        if (lineNumbers[0] == -1) {
            return null;
        }
        Position found = null;
        try {
            IDocument d = this.fTextViewer.getDocument();
            IRegion line = d.getLineInformation(lineNumbers[0]);
            int start = line.getOffset();
            line = d.getLineInformation(lineNumbers[lineNumbers.length - 1]);
            int end = line.getOffset() + line.getLength();
            int i = this.fAnnotationsSortedByLayer.size() - 1;
            while (i >= 0) {
                Object annotationType = this.fAnnotationsSortedByLayer.get(i);
                FilterIterator e = new FilterIterator(annotationType, 6);
                while (e.hasNext() && found == null) {
                    Position p;
                    Annotation a = (Annotation)e.next();
                    if (a.isMarkedDeleted() || this.skip(a.getType()) || (p = this.fModel.getPosition(a)) == null) continue;
                    int posOffset = p.getOffset();
                    int posEnd = posOffset + p.getLength();
                    IRegion region = d.getLineInformationOfOffset(posEnd);
                    if (posEnd > posOffset && region.getOffset() == posEnd) {
                        region = d.getLineInformationOfOffset(--posEnd);
                    }
                    if (posOffset > end || posEnd < start) continue;
                    found = p;
                }
                --i;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return found;
    }

    private int findBestMatchingLineNumber(int[] lineNumbers) {
        Position pos;
        block4: {
            if (lineNumbers == null || lineNumbers.length < 1) {
                return -1;
            }
            try {
                pos = this.getAnnotationPosition(lineNumbers);
                if (pos != null) break block4;
                return -1;
            }
            catch (BadLocationException ex) {
                return -1;
            }
        }
        return this.fTextViewer.getDocument().getLineOfOffset(pos.getOffset());
    }

    protected void handleMouseDown(MouseEvent event) {
        if (this.fTextViewer != null) {
            int[] lines = this.toLineNumbers(event.y);
            Position p = this.getAnnotationPosition(lines);
            if (p == null && event.button == 1) {
                try {
                    p = new Position(this.fTextViewer.getDocument().getLineInformation(lines[0]).getOffset(), 0);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (p != null) {
                this.fTextViewer.revealRange(p.getOffset(), p.getLength());
                this.fTextViewer.setSelectedRange(p.getOffset(), p.getLength());
            }
            this.fTextViewer.getTextWidget().setFocus();
        }
        this.fLastMouseButtonActivityLine = this.toDocumentLineNumber(event.y);
    }

    protected void handleMouseUp(MouseEvent event) {
    }

    protected void handleMouseMove(MouseEvent event) {
        if (this.fTextViewer != null) {
            Cursor cursor;
            int[] lines = this.toLineNumbers(event.y);
            Position p = this.getAnnotationPosition(lines);
            Cursor cursor2 = cursor = p != null ? this.fHitDetectionCursor : null;
            if (cursor != this.fLastCursor) {
                this.fCanvas.setCursor(cursor);
                this.fLastCursor = cursor;
            }
        }
    }

    public void addAnnotationType(Object annotationType) {
        this.fConfiguredAnnotationTypes.add(annotationType);
        this.fAllowedAnnotationTypes.clear();
    }

    public void removeAnnotationType(Object annotationType) {
        this.fConfiguredAnnotationTypes.remove(annotationType);
        this.fAllowedAnnotationTypes.clear();
    }

    public void setAnnotationTypeLayer(Object annotationType, int layer) {
        int j = this.fAnnotationsSortedByLayer.indexOf(annotationType);
        if (j != -1) {
            this.fAnnotationsSortedByLayer.remove(j);
            this.fLayersSortedByLayer.remove(j);
        }
        if (layer >= 0) {
            int i = 0;
            int size = this.fLayersSortedByLayer.size();
            while (i < size && layer >= (Integer)this.fLayersSortedByLayer.get(i)) {
                ++i;
            }
            this.fLayersSortedByLayer.add(i, layer);
            this.fAnnotationsSortedByLayer.add(i, annotationType);
        }
    }

    public void setAnnotationTypeColor(Object annotationType, Color color) {
        if (color != null) {
            this.fAnnotationTypes2Colors.put(annotationType, color);
        } else {
            this.fAnnotationTypes2Colors.remove(annotationType);
        }
    }

    private boolean skip(Object annotationType) {
        return !this.contains(annotationType, this.fAllowedAnnotationTypes, this.fConfiguredAnnotationTypes);
    }

    private boolean skipInHeader(Object annotationType) {
        return !this.contains(annotationType, this.fAllowedHeaderAnnotationTypes, this.fConfiguredHeaderAnnotationTypes);
    }

    private boolean contains(Object annotationType, Map allowed, Set configured) {
        Boolean cached = (Boolean)allowed.get(annotationType);
        if (cached != null) {
            return cached;
        }
        boolean covered = this.isCovered(annotationType, configured);
        allowed.put(annotationType, covered ? Boolean.TRUE : Boolean.FALSE);
        return covered;
    }

    private boolean isCovered(Object annotationType, Set configured) {
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            IAnnotationAccessExtension extension = (IAnnotationAccessExtension)this.fAnnotationAccess;
            Iterator e = configured.iterator();
            while (e.hasNext()) {
                if (!extension.isSubtype(annotationType, e.next())) continue;
                return true;
            }
            return false;
        }
        return configured.contains(annotationType);
    }

    private static RGB interpolate(RGB fg, RGB bg, double scale) {
        return new RGB((int)((1.0 - scale) * (double)fg.red + scale * (double)bg.red), (int)((1.0 - scale) * (double)fg.green + scale * (double)bg.green), (int)((1.0 - scale) * (double)fg.blue + scale * (double)bg.blue));
    }

    private static double greyLevel(RGB rgb) {
        if (rgb.red == rgb.green && rgb.green == rgb.blue) {
            return rgb.red;
        }
        return 0.299 * (double)rgb.red + 0.587 * (double)rgb.green + 0.114 * (double)rgb.blue + 0.5;
    }

    private static boolean isDark(RGB rgb) {
        return CopiedOverviewRuler.greyLevel(rgb) > 128.0;
    }

    private Color getColor(Object annotationType, double scale) {
        Color base = this.findColor(annotationType);
        if (base == null) {
            return null;
        }
        RGB baseRGB = base.getRGB();
        RGB background = this.fCanvas.getBackground().getRGB();
        boolean darkBase = CopiedOverviewRuler.isDark(baseRGB);
        boolean darkBackground = CopiedOverviewRuler.isDark(background);
        if (darkBase && darkBackground) {
            background = new RGB(255, 255, 255);
        } else if (!darkBase && !darkBackground) {
            background = new RGB(0, 0, 0);
        }
        return this.fSharedTextColors.getColor(CopiedOverviewRuler.interpolate(baseRGB, background, scale));
    }

    private Color findColor(Object annotationType) {
        IAnnotationAccessExtension extension;
        Object[] superTypes;
        Color color = (Color)this.fAnnotationTypes2Colors.get(annotationType);
        if (color != null) {
            return color;
        }
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension && (superTypes = (extension = (IAnnotationAccessExtension)this.fAnnotationAccess).getSupertypes(annotationType)) != null) {
            int i = 0;
            while (i < superTypes.length) {
                color = (Color)this.fAnnotationTypes2Colors.get(superTypes[i]);
                if (color != null) {
                    return color;
                }
                ++i;
            }
        }
        return null;
    }

    private Color getStrokeColor(Object annotationType, boolean temporary) {
        return this.getColor(annotationType, temporary && this.fIsTemporaryAnnotationDiscolored ? 0.5 : 0.2);
    }

    private Color getFillColor(Object annotationType, boolean temporary) {
        return this.getColor(annotationType, temporary && this.fIsTemporaryAnnotationDiscolored ? 0.9 : 0.75);
    }

    public int getLineOfLastMouseButtonActivity() {
        if (this.fLastMouseButtonActivityLine >= this.fTextViewer.getDocument().getNumberOfLines()) {
            this.fLastMouseButtonActivityLine = -1;
        }
        return this.fLastMouseButtonActivityLine;
    }

    public int toDocumentLineNumber(int y_coordinate) {
        if (this.fTextViewer == null || y_coordinate == -1) {
            return -1;
        }
        int[] lineNumbers = this.toLineNumbers(y_coordinate);
        int bestLine = this.findBestMatchingLineNumber(lineNumbers);
        if (bestLine == -1 && lineNumbers.length > 0) {
            return lineNumbers[0];
        }
        return bestLine;
    }

    public IAnnotationModel getModel() {
        return this.fModel;
    }

    public int getAnnotationHeight() {
        return this.fAnnotationHeight;
    }

    public boolean hasAnnotation(int y) {
        return this.findBestMatchingLineNumber(this.toLineNumbers(y)) != -1;
    }

    public Control getHeaderControl() {
        return this.fHeader;
    }

    public void addHeaderAnnotationType(Object annotationType) {
        this.fConfiguredHeaderAnnotationTypes.add(annotationType);
        this.fAllowedHeaderAnnotationTypes.clear();
    }

    public void removeHeaderAnnotationType(Object annotationType) {
        this.fConfiguredHeaderAnnotationTypes.remove(annotationType);
        this.fAllowedHeaderAnnotationTypes.clear();
    }

    private void updateHeader() {
        if (this.fHeader == null || this.fHeader.isDisposed()) {
            return;
        }
        this.fHeader.setToolTipText(null);
        Object colorType = null;
        int i = this.fAnnotationsSortedByLayer.size() - 1;
        block0: while (i >= 0) {
            Object annotationType = this.fAnnotationsSortedByLayer.get(i);
            if (!this.skipInHeader(annotationType) && !this.skip(annotationType)) {
                FilterIterator e = new FilterIterator(annotationType, 14, this.fCachedAnnotations.iterator());
                while (e.hasNext()) {
                    if (e.next() == null) continue;
                    colorType = annotationType;
                    break block0;
                }
            }
            --i;
        }
        Color color = null;
        if (colorType != null) {
            color = this.findColor(colorType);
        }
        if (color == null) {
            if (this.fHeaderPainter != null) {
                this.fHeaderPainter.setColor(null);
            }
        } else {
            if (this.fHeaderPainter == null) {
                this.fHeaderPainter = new HeaderPainter();
                this.fHeader.addPaintListener((PaintListener)this.fHeaderPainter);
            }
            this.fHeaderPainter.setColor(color);
        }
        this.fHeader.redraw();
    }

    private void updateHeaderToolTipText() {
        if (this.fHeader == null || this.fHeader.isDisposed()) {
            return;
        }
        if (this.fHeader.getToolTipText() != null) {
            return;
        }
        Object overview = "";
        int i = this.fAnnotationsSortedByLayer.size() - 1;
        while (i >= 0) {
            Object annotationType = this.fAnnotationsSortedByLayer.get(i);
            if (!this.skipInHeader(annotationType) && !this.skip(annotationType)) {
                int count = 0;
                String annotationTypeLabel = null;
                FilterIterator e = new FilterIterator(annotationType, 14, this.fCachedAnnotations.iterator());
                while (e.hasNext()) {
                    Annotation annotation = (Annotation)e.next();
                    if (annotation == null) continue;
                    if (annotationTypeLabel == null) {
                        annotationTypeLabel = ((IAnnotationAccessExtension)this.fAnnotationAccess).getTypeLabel(annotation);
                    }
                    ++count;
                }
                if (annotationTypeLabel != null) {
                    if (((String)overview).length() > 0) {
                        overview = (String)overview + "\n";
                    }
                    overview = (String)overview + annotationTypeLabel + ":" + count;
                }
            }
            --i;
        }
        if (((String)overview).length() > 0) {
            this.fHeader.setToolTipText((String)overview);
        }
    }

    class FilterIterator
    implements Iterator {
        static final int TEMPORARY = 2;
        static final int PERSISTENT = 4;
        static final int IGNORE_BAGS = 8;
        private Iterator fIterator;
        private Object fType;
        private Annotation fNext;
        private int fStyle;

        public FilterIterator(Object annotationType, int style) {
            this.fType = annotationType;
            this.fStyle = style;
            if (CopiedOverviewRuler.this.fModel != null) {
                this.fIterator = CopiedOverviewRuler.this.fModel.getAnnotationIterator();
                this.skip();
            }
        }

        public FilterIterator(Object annotationType, int style, Iterator iterator) {
            this.fType = annotationType;
            this.fStyle = style;
            this.fIterator = iterator;
            this.skip();
        }

        private void skip() {
            boolean temp = (this.fStyle & 2) != 0;
            boolean pers = (this.fStyle & 4) != 0;
            boolean ignr = (this.fStyle & 8) != 0;
            while (this.fIterator.hasNext()) {
                Annotation next = (Annotation)this.fIterator.next();
                if (next.isMarkedDeleted() || ignr && next instanceof AnnotationBag) continue;
                this.fNext = next;
                String annotationType = next.getType();
                if (this.fType != null && !this.fType.equals(annotationType) && (CopiedOverviewRuler.this.fConfiguredAnnotationTypes.contains(annotationType) || !this.isSubtype(annotationType))) continue;
                if (temp && pers) {
                    return;
                }
                if (pers && next.isPersistent()) {
                    return;
                }
                if (!temp || next.isPersistent()) continue;
                return;
            }
            this.fNext = null;
        }

        private boolean isSubtype(Object annotationType) {
            if (CopiedOverviewRuler.this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
                IAnnotationAccessExtension extension = (IAnnotationAccessExtension)CopiedOverviewRuler.this.fAnnotationAccess;
                return extension.isSubtype(annotationType, this.fType);
            }
            return this.fType.equals(annotationType);
        }

        @Override
        public boolean hasNext() {
            return this.fNext != null;
        }

        public Object next() {
            try {
                Annotation annotation = this.fNext;
                return annotation;
            }
            finally {
                if (this.fIterator != null) {
                    this.skip();
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class HeaderPainter
    implements PaintListener {
        private Color fIndicatorColor;
        private Color fSeparatorColor;

        public HeaderPainter() {
            this.fSeparatorColor = CopiedOverviewRuler.this.fHeader.getDisplay().getSystemColor(18);
        }

        public void setColor(Color color) {
            this.fIndicatorColor = color;
        }

        private void drawBevelRect(GC gc, int x, int y, int w, int h, Color topLeft, Color bottomRight) {
            gc.setForeground(topLeft);
            gc.drawLine(x, y, x + w - 1, y);
            gc.drawLine(x, y, x, y + h - 1);
            gc.setForeground(bottomRight);
            gc.drawLine(x + w, y, x + w, y + h);
            gc.drawLine(x, y + h, x + w, y + h);
        }

        public void paintControl(PaintEvent e) {
            boolean isTall;
            if (this.fIndicatorColor == null) {
                return;
            }
            Point s = CopiedOverviewRuler.this.fHeader.getSize();
            e.gc.setBackground(this.fIndicatorColor);
            Rectangle headerBounds = CopiedOverviewRuler.this.fHeader.getBounds();
            boolean isOnTop = headerBounds.y + headerBounds.height <= CopiedOverviewRuler.this.fCanvas.getLocation().y;
            boolean bl = isTall = s.y > s.x + 8;
            int y = !isOnTop ? s.y - 12 : (isTall ? 4 : (s.y - 8) / 2);
            Rectangle r = new Rectangle(2, y, s.x - 4, 8);
            e.gc.fillRectangle(r);
            this.drawBevelRect(e.gc, r.x, r.y, r.width - 1, r.height - 1, this.fSeparatorColor, this.fSeparatorColor);
            e.gc.setForeground(this.fSeparatorColor);
            e.gc.setLineWidth(0);
            if (!isOnTop || !isTall) {
                e.gc.drawLine(0, s.y - 1, s.x - 1, s.y - 1);
            }
        }
    }

    class InternalListener
    implements ITextListener,
    IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        InternalListener() {
        }

        public void textChanged(TextEvent e) {
            if (CopiedOverviewRuler.this.fTextViewer != null && e.getDocumentEvent() == null && e.getViewerRedrawState()) {
                CopiedOverviewRuler.this.redraw();
            }
        }

        public void modelChanged(IAnnotationModel model) {
            CopiedOverviewRuler.this.update();
        }

        public void modelChanged(AnnotationModelEvent event) {
            if (!event.isValid()) {
                return;
            }
            if (event.isWorldChange()) {
                CopiedOverviewRuler.this.update();
                return;
            }
            Annotation[] annotations = event.getAddedAnnotations();
            int length = annotations.length;
            int i = 0;
            while (i < length) {
                if (!CopiedOverviewRuler.this.skip(annotations[i].getType())) {
                    CopiedOverviewRuler.this.update();
                    return;
                }
                ++i;
            }
            annotations = event.getRemovedAnnotations();
            length = annotations.length;
            i = 0;
            while (i < length) {
                if (!CopiedOverviewRuler.this.skip(annotations[i].getType())) {
                    CopiedOverviewRuler.this.update();
                    return;
                }
                ++i;
            }
            annotations = event.getChangedAnnotations();
            length = annotations.length;
            i = 0;
            while (i < length) {
                if (!CopiedOverviewRuler.this.skip(annotations[i].getType())) {
                    CopiedOverviewRuler.this.update();
                    return;
                }
                ++i;
            }
        }
    }
}

