/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.overview_ruler;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.utils.ArrayUtils;

public final class StyledTextWithoutVerticalBar
extends StyledText {
    public StyledTextWithoutVerticalBar(Composite parent, int style) {
        super(parent, style);
    }

    public void setStyleRanges(StyleRange[] styles) {
        if (styles != null) {
            RangesInfo rangesInfo = StyledTextWithoutVerticalBar.createRanges(styles, this.getCharCount());
            int[] newRanges = rangesInfo.newRanges;
            styles = rangesInfo.styles;
            super.setStyleRanges(newRanges, styles);
            return;
        }
        super.setStyleRanges(styles);
    }

    public void replaceStyleRanges(int start, int length, StyleRange[] styles) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (styles == null) {
            SWT.error((int)4);
        }
        RangesInfo rangesInfo = StyledTextWithoutVerticalBar.createRanges(styles, this.getCharCount());
        int[] newRanges = rangesInfo.newRanges;
        styles = rangesInfo.styles;
        try {
            this.setStyleRanges(start, length, newRanges, styles);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public void redraw() {
        try {
            super.redraw();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static RangesInfo createRanges(StyleRange[] styles, int charCount) throws AssertionError {
        newRanges = new int[styles.length << 1];
        removeRangesFrom = -1;
        removeRanges = new ArrayList<Integer>();
        endOffset = -1;
        i = 0;
        j = 0;
        while (i < styles.length) {
            newStyle = styles[i];
            if (newStyle.start >= charCount) {
                Log.log((String)"Removing ranges past end.");
                removeRangesFrom = i;
                break;
            }
            if (endOffset <= newStyle.start) ** GOTO lbl-1000
            msg = "Error endOffset (" + endOffset + ") > next style start (" + newStyle.start + ")";
            Log.log((String)msg);
            diff = endOffset - newStyle.start;
            newStyle.start = endOffset;
            newStyle.length -= diff;
            if (newStyle.length < 0) {
                removeRanges.add(i);
            } else lbl-1000:
            // 2 sources

            {
                if ((endOffset = newStyle.start + newStyle.length) > charCount) {
                    msg = "Error endOffset (" + endOffset + ") > charCount (" + charCount + ")";
                    Log.log((String)msg);
                    newStyle.length -= endOffset - charCount;
                    if (newStyle.length < 0) {
                        Log.log((String)"Removing ranges past end.");
                        removeRangesFrom = i;
                        break;
                    }
                }
                newRanges[j++] = newStyle.start;
                newRanges[j++] = newStyle.length;
            }
            ++i;
        }
        if (j < newRanges.length - 1) {
            reallocate /* !! */  = new int[j];
            System.arraycopy(newRanges, 0, reallocate /* !! */ , 0, j);
            newRanges = reallocate /* !! */ ;
        }
        if (removeRangesFrom != -1) {
            reallocate /* !! */  = (int[])new StyleRange[removeRangesFrom];
            System.arraycopy(styles, 0, reallocate /* !! */ , 0, removeRangesFrom);
            styles = reallocate /* !! */ ;
        }
        if (removeRanges.size() > 0) {
            Collections.reverse(removeRanges);
        }
        var9_10 = removeRanges.iterator();
        while (var9_10.hasNext()) {
            remove = (Integer)var9_10.next();
            if (remove >= styles.length) continue;
            styles = (StyleRange[])ArrayUtils.remove((Object[])styles, (int)remove, StyleRange.class);
        }
        return new RangesInfo((StyleRange[])styles, newRanges);
    }

    public static class RangesInfo {
        public final StyleRange[] styles;
        public final int[] newRanges;

        public RangesInfo(StyleRange[] styles, int[] newRanges) {
            this.styles = styles;
            this.newRanges = newRanges;
        }
    }
}

