/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public class ConsoleColorCache
implements IEclipsePreferences.IPreferenceChangeListener {
    private static ConsoleColorCache instance;
    private static Object instanceLock;
    private List<WeakReference<IOConsole>> weakrefs = new ArrayList<WeakReference<IOConsole>>();
    private final Object referencesLock = new Object();
    protected Map<RGB, Color> cache = new HashMap<RGB, Color>(4);

    static {
        instanceLock = new Object();
    }

    private ConsoleColorCache() {
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.debug.ui");
        node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConsoleColorCache getDefault() {
        if (instance == null) {
            Object object = instanceLock;
            synchronized (object) {
                if (instance == null) {
                    instance = new ConsoleColorCache();
                }
            }
        }
        return instance;
    }

    public Color getColor(RGB rgb) {
        Color color = this.cache.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.cache.put(rgb, color);
        }
        return color;
    }

    private Color getDebugColor(String key) {
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.debug.ui");
        String color = node.get(key, null);
        if (color != null) {
            try {
                return ConsoleColorCache.getDefault().getColor(StringConverter.asRGB((String)color));
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return null;
    }

    public void keepConsoleColorsSynched(IOConsole console) {
        this.updateConsole(console);
        this.addRef(console);
    }

    private void updateConsole(final IOConsole console) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Color color = ConsoleColorCache.this.getDebugColor("org.eclipse.debug.ui.consoleBackground");
                    if (color != null) {
                        console.setBackground(color);
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
                try {
                    Map streamToColor = (Map)console.getAttribute("themeConsoleStreamToColor");
                    if (streamToColor != null) {
                        Set entrySet = streamToColor.entrySet();
                        for (Map.Entry entry : entrySet) {
                            Color color;
                            String value = (String)entry.getValue();
                            if ("console.output".equals(value)) {
                                color = ConsoleColorCache.this.getDebugColor("org.eclipse.debug.ui.outColor");
                                if (color == null) continue;
                                ((IOConsoleOutputStream)entry.getKey()).setColor(color);
                                continue;
                            }
                            if ("console.error".equals(value)) {
                                color = ConsoleColorCache.this.getDebugColor("org.eclipse.debug.ui.errorColor");
                                if (color == null) continue;
                                ((IOConsoleOutputStream)entry.getKey()).setColor(color);
                                continue;
                            }
                            Log.log((String)("Unrecognized value (expected console.output or console.error):" + value));
                        }
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        };
        RunInUiThread.async(r, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRef(IOConsole console) {
        Object object = this.referencesLock;
        synchronized (object) {
            int size = this.weakrefs.size();
            int i = 0;
            while (i < size) {
                WeakReference<IOConsole> ref = this.weakrefs.get(i);
                Object object2 = ref.get();
                if (object2 == console) {
                    return;
                }
                if (object2 == null) {
                    this.weakrefs.remove(i);
                    --i;
                    --size;
                }
                ++i;
            }
            this.weakrefs.add(new WeakReference<IOConsole>(console));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String key = event.getKey();
        if ("org.eclipse.debug.ui.consoleBackground".equals(key) || "org.eclipse.debug.ui.outColor".equals(key) || "org.eclipse.debug.ui.errorColor".equals(key)) {
            Object object = this.referencesLock;
            synchronized (object) {
                ArrayList<IOConsole> currentRefs = this.getCurrentRefs();
                for (IOConsole console : currentRefs) {
                    this.updateConsole(console);
                }
            }
        }
    }

    private ArrayList<IOConsole> getCurrentRefs() {
        int size = this.weakrefs.size();
        ArrayList<IOConsole> currentRefs = new ArrayList<IOConsole>(size);
        int i = 0;
        while (i < size) {
            WeakReference<IOConsole> ref = this.weakrefs.get(i);
            IOConsole object = (IOConsole)ref.get();
            if (object == null) {
                this.weakrefs.remove(i);
                --i;
                --size;
            } else {
                currentRefs.add(object);
            }
            ++i;
        }
        return currentRefs;
    }
}

