/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_ui.bundle.BundleInfo;
import org.python.pydev.shared_ui.bundle.IBundleInfo;
import org.python.pydev.shared_ui.utils.RunInUiThread;
import org.python.pydev.shared_ui.utils.UIUtils;

public class SharedUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.python.pydev.shared_ui";
    private static SharedUiPlugin plugin;
    public static IBundleInfo info;
    private static IImageCache imageCache;

    static {
        imageCache = null;
    }

    public static IBundleInfo getBundleInfo() {
        if (info == null) {
            SharedUiPlugin bundle = SharedUiPlugin.getDefault();
            if (bundle == null) {
                return null;
            }
            info = new BundleInfo(bundle.getBundle());
        }
        return info;
    }

    public static void setBundleInfo(IBundleInfo b) {
        info = b;
    }

    public SharedUiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        SharedCorePlugin.setImageCache((IImageCache)SharedUiPlugin.getImageCache());
        SharedCorePlugin.onAsyncRunInUiThread = runnable -> {
            RunInUiThread.async(runnable);
            return null;
        };
        SharedCorePlugin.onSyncWithUiThread = runnable -> {
            RunInUiThread.sync(runnable);
            return null;
        };
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static SharedUiPlugin getDefault() {
        return plugin;
    }

    public static IImageCache getImageCache() {
        if (imageCache == null) {
            IBundleInfo bundleInfo = SharedUiPlugin.getBundleInfo();
            if (bundleInfo == null) {
                return null;
            }
            imageCache = bundleInfo.getImageCache();
        }
        return imageCache;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return this.getImageRegistry().getDescriptor(key);
    }

    public static void setCssId(Object control, String id, boolean applyToChildren) {
        try {
            IStylingEngine engine = (IStylingEngine)UIUtils.getActiveWorkbenchWindow().getService(IStylingEngine.class);
            if (engine != null) {
                engine.setId(control, id);
                IThemeEngine themeEngine = (IThemeEngine)Display.getDefault().getData("org.eclipse.e4.ui.css.swt.theme");
                themeEngine.applyStyles(control, applyToChildren);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void fixSelectionStatusDialogStatusLineColor(Object dialog, Color color) {
        try {
            Field field = SelectionStatusDialog.class.getDeclaredField("fStatusLine");
            field.setAccessible(true);
            Control messageLine = (Control)field.get(dialog);
            messageLine.setBackground(color);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public static IStatus makeErrorStatus(Exception e, boolean useErrorMessage) {
        String message = "";
        if (useErrorMessage && (message = e.getMessage()) == null) {
            message = "null";
        }
        return new Status(4, PLUGIN_ID, 4, message, (Throwable)e);
    }
}

