/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.editor_input;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;

public class PydevZipFileStorage
implements IStorage {
    public final File zipFile;
    public final String zipPath;

    public PydevZipFileStorage(File zipFile, String zipPath) {
        this.zipFile = zipFile;
        this.zipPath = zipPath;
    }

    public InputStream getContents() throws CoreException {
        ByteArrayInputStream byteArrayInputStream;
        ZipFile f;
        block14: {
            f = new ZipFile(this.zipFile);
            InputStream inputStream = null;
            try {
                inputStream = f.getInputStream(f.getEntry(this.zipPath));
                FastStringBuffer streamContents = (FastStringBuffer)FileUtils.getStreamContents((InputStream)inputStream, null, null, FastStringBuffer.class);
                byteArrayInputStream = new ByteArrayInputStream(streamContents.getBytes());
                if (inputStream == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                    }
                    try {
                        f.close();
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "org.python.pydev.shared_core", "Error getting contents from zip file", (Throwable)e));
                }
            }
            try {
                inputStream.close();
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        try {
            f.close();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return byteArrayInputStream;
    }

    public IPath getFullPath() {
        return Path.fromOSString((String)this.zipFile.getAbsolutePath()).append((IPath)new Path(this.zipPath));
    }

    public String getName() {
        List split = StringUtils.split((String)this.zipPath, (char)'/');
        if (split.size() > 0) {
            return (String)split.get(split.size() - 1);
        }
        return this.zipPath;
    }

    public boolean isReadOnly() {
        return true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }
}

