/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.field_editors;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.dialogs.ProjectSelectionDialog;
import org.python.pydev.shared_ui.field_editors.DirectoryFieldEditorCustom;

public class ProjectDirectoryFieldEditorCustom
extends DirectoryFieldEditorCustom {
    private Composite newParent;
    private Button projectButton;

    public ProjectDirectoryFieldEditorCustom(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected Button getChangeControl(Composite p) {
        if (this.newParent == null) {
            this.newParent = new Composite(p, 0);
            this.newParent.setLayout((Layout)new GridLayout(2, true));
            if (this.projectButton == null) {
                this.projectButton = new Button(this.newParent, 8);
                this.projectButton.setImage(ImageCache.asImage(SharedCorePlugin.getImageCache().get("icons/project.png")));
                this.projectButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(evt -> {
                    Object[] result;
                    ProjectSelectionDialog dialog = new ProjectSelectionDialog(EditorUtils.getShell(), null);
                    dialog.setMessage("Choose project.\n");
                    if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
                        this.setStringValue(((IProject)result[0]).getLocation().toOSString());
                    }
                }));
                this.projectButton.addDisposeListener(event -> {
                    Button button = this.projectButton = null;
                });
            }
        }
        return super.getChangeControl(this.newParent);
    }
}

