/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.outline;

import java.lang.ref.WeakReference;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.outline.BaseOutlinePage;

public abstract class AbstractOutlineFilterAction
extends Action {
    protected ViewerFilter filter;
    protected WeakReference<BaseOutlinePage> page;
    protected String preference;

    public AbstractOutlineFilterAction(String text, BaseOutlinePage page, IImageCache imageCache, String preference, String uiConstant) {
        super(text, 2);
        this.preference = preference;
        this.page = new WeakReference<BaseOutlinePage>(page);
        this.setChecked(page.getStore().getBoolean(preference));
        this.setActionEnabled(this.isChecked());
        this.setImageDescriptor(ImageCache.asImageDescriptor(imageCache.getDescriptor(uiConstant)));
    }

    public void run() {
        this.setActionEnabled(this.isChecked());
    }

    protected void setActionEnabled(boolean enableAction) {
        BaseOutlinePage p = (BaseOutlinePage)((Object)this.page.get());
        if (p != null) {
            TreeViewer treeViewer;
            p.getStore().setValue(this.preference, enableAction);
            if (this.filter == null) {
                this.filter = this.createFilter();
            }
            if ((treeViewer = p.getTreeViewer()) != null) {
                if (enableAction) {
                    treeViewer.addFilter(this.filter);
                } else {
                    treeViewer.removeFilter(this.filter);
                }
            }
        }
    }

    protected abstract ViewerFilter createFilter();
}

