/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class StringMatcherWithIndexSemantics {
    private final Pattern compiled;
    private boolean startsWithWildCard;
    private boolean endsWithWildCard;

    public StringMatcherWithIndexSemantics(String text, boolean ignoreCase, boolean wholeWord) {
        FastStringBuffer buf = new FastStringBuffer();
        FastStringBuffer finalRegexp = new FastStringBuffer();
        boolean skipLeftSep = false;
        boolean skipRightSep = false;
        if (!wholeWord) {
            skipLeftSep = true;
        }
        while (text.startsWith("*")) {
            skipLeftSep = true;
            text = text.substring(1);
        }
        if (!wholeWord) {
            skipRightSep = true;
        }
        while (text.endsWith("*") && !text.endsWith("\\*")) {
            skipRightSep = true;
            text = text.substring(0, text.length() - 1);
        }
        int length = text.length();
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            if (c == '\\') {
                if (++i < length) {
                    buf.append(text.charAt(i));
                }
            } else if (c == '*' || c == '?') {
                if (buf.length() > 0) {
                    finalRegexp.append(Pattern.quote(buf.toString()));
                    buf.clear();
                }
                finalRegexp.append(".").append(c);
            } else {
                buf.append(c);
            }
            ++i;
        }
        if (buf.length() > 0) {
            finalRegexp.append(Pattern.quote(buf.toString()));
        }
        if (!skipLeftSep && !finalRegexp.startsWith('*')) {
            if (!finalRegexp.startsWith("\\Q")) {
                finalRegexp.insert(0, "\\b");
            } else if (Character.isJavaIdentifierPart(finalRegexp.charAt(2))) {
                finalRegexp.insert(0, "\\b");
            }
        }
        if (!skipRightSep && !finalRegexp.endsWith('*')) {
            if (!finalRegexp.endsWith("\\E")) {
                finalRegexp.append("\\b");
            } else if (Character.isJavaIdentifierPart(finalRegexp.charAt(finalRegexp.length() - 3))) {
                finalRegexp.append("\\b");
            }
        }
        this.startsWithWildCard = skipLeftSep;
        this.endsWithWildCard = skipRightSep;
        this.compiled = Pattern.compile(finalRegexp.toString(), ignoreCase ? 2 : 0);
    }

    public Position find(String text, int start) {
        Matcher matcher;
        boolean find;
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (start < 0) {
            start = 0;
        }
        if (!(find = (matcher = this.compiled.matcher(text)).find(start))) {
            return null;
        }
        int startPos = matcher.start();
        int endPos = matcher.end();
        return new Position(startPos, endPos);
    }

    public boolean match(String text) {
        Matcher matcher = this.compiled.matcher(text);
        if (!this.startsWithWildCard && !this.endsWithWildCard) {
            return matcher.matches();
        }
        Position found = this.find(text, 0);
        if (found == null) {
            return false;
        }
        if (!this.startsWithWildCard && found.start != 0) {
            return false;
        }
        return this.endsWithWildCard || found.end == text.length();
    }

    public static class Position {
        public int start;
        public int end;

        public Position(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

