/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.swt;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.python.pydev.shared_core.structure.LinkedListWarningOnSlowOperations;
import org.python.pydev.shared_ui.utils.ColorParse;

public class StyledLink
extends Hyperlink {
    private static final RGB DEFAULT_COLOR = new RGB(0, 51, 153);
    private static Color fgColor;
    private static List<WeakReference<StyledLink>> weakLinks;

    static {
        weakLinks = new ArrayList<WeakReference<StyledLink>>();
    }

    private static void syncLinksFgColor(StyledLink styledLink) {
        Iterator<WeakReference<StyledLink>> iterator = weakLinks.iterator();
        while (iterator.hasNext()) {
            WeakReference<StyledLink> weak = iterator.next();
            StyledLink link = (StyledLink)((Object)weak.get());
            if (link != null && !link.isDisposed()) continue;
            iterator.remove();
        }
        weakLinks.add(new WeakReference<StyledLink>(styledLink));
        if (fgColor == null) {
            IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.ui.workbench");
            String string = node.get("HYPERLINK_COLOR", "");
            fgColor = string != null && string.length() > 0 ? new Color((Device)Display.getCurrent(), ColorParse.parseRGB(string, DEFAULT_COLOR)) : new Color((Device)Display.getCurrent(), DEFAULT_COLOR);
            node.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

                public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                    if ("HYPERLINK_COLOR".equals(event.getKey())) {
                        Color old = fgColor;
                        Object newValue = event.getNewValue();
                        fgColor = newValue != null && newValue.toString().length() != 0 ? new Color((Device)Display.getCurrent(), ColorParse.parseRGB(newValue.toString(), DEFAULT_COLOR)) : new Color((Device)Display.getCurrent(), DEFAULT_COLOR);
                        Iterator<WeakReference<StyledLink>> iterator = weakLinks.iterator();
                        while (iterator.hasNext()) {
                            WeakReference<StyledLink> weak = iterator.next();
                            StyledLink link = (StyledLink)((Object)weak.get());
                            if (link == null || link.isDisposed()) {
                                iterator.remove();
                                continue;
                            }
                            link.setForeground(fgColor);
                        }
                        old.dispose();
                    }
                }
            });
        }
        styledLink.setForeground(fgColor);
    }

    public StyledLink(Composite parent, int style) {
        super(parent, style);
        this.setUnderlined(true);
        StyledLink.syncLinksFgColor(this);
    }

    public static class MultiStyledLink
    extends Composite {
        LinkedList<Control> created = new LinkedListWarningOnSlowOperations();

        public MultiStyledLink(Composite parent, int style) {
            super(parent, style);
            RowLayout layout = new RowLayout();
            layout.wrap = false;
            this.setLayout((Layout)layout);
        }

        public void setText(String text) {
            if (this.created.size() > 0) {
                for (Control c : this.created) {
                    c.dispose();
                }
                this.created.clear();
            }
            MultiStyledLink container = this;
            int start = text.indexOf("<a>");
            int curr = 0;
            while (start != -1) {
                int end = text.indexOf("</a>", start);
                if (start > curr) {
                    Label label = new Label((Composite)container, 0);
                    label.setText(text.substring(curr, start));
                    this.created.add((Control)label);
                }
                StyledLink link = new StyledLink(container, 0);
                link.setText(text.substring(start + 3, end));
                this.created.add((Control)link);
                curr = end + 4;
                start = text.indexOf("<a>", curr);
            }
            if (curr < text.length()) {
                Label label = new Label((Composite)container, 0);
                label.setText(text.substring(curr, text.length()));
                this.created.add((Control)label);
            }
        }

        public AbstractHyperlink getLink(int i) {
            int j = 0;
            for (Control c : this.created) {
                if (!(c instanceof StyledLink)) continue;
                if (j == i) {
                    return (AbstractHyperlink)c;
                }
                ++j;
            }
            return null;
        }
    }
}

