/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.concurrency;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.MathUtils;
import org.python.pydev.core.concurrency.IRunnableWithMonitor;
import org.python.pydev.core.concurrency.Semaphore;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.structure.Tuple;

public class RunnableAsJobsPoolThread
extends Thread {
    private final Semaphore jobsCreationSemaphore;
    private final Semaphore canRunSemaphore = new Semaphore(0L);
    private final List<Tuple<Runnable, String>> runnables = new ArrayList<Tuple<Runnable, String>>();
    private final Object lockRunnables = new Object();
    private final Object stopThreadsLock = new Object();
    private int stopThreads = 0;
    private static RunnableAsJobsPoolThread singleton;

    public RunnableAsJobsPoolThread(int maxSize) {
        this.jobsCreationSemaphore = new Semaphore(maxSize);
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushStopThreads() {
        Object object = this.stopThreadsLock;
        synchronized (object) {
            ++this.stopThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popStopThreads() {
        Object object = this.stopThreadsLock;
        synchronized (object) {
            --this.stopThreads;
            Assert.isTrue((this.stopThreads >= 0 ? 1 : 0) != 0);
            if (this.stopThreads == 0) {
                this.stopThreadsLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            int size;
            this.canRunSemaphore.acquire();
            Tuple<Runnable, String> execute = null;
            Object object = this.lockRunnables;
            synchronized (object) {
                size = this.runnables.size();
                if (size > 0) {
                    execute = this.runnables.remove(0);
                    --size;
                }
            }
            int local = 0;
            while (true) {
                Object object2 = this.stopThreadsLock;
                synchronized (object2) {
                    local = this.stopThreads;
                }
                if (local == 0) break;
                object2 = this.stopThreadsLock;
                synchronized (object2) {
                    try {
                        this.stopThreadsLock.wait(200L);
                    }
                    catch (InterruptedException e) {
                        Log.log(e);
                    }
                }
            }
            if (execute == null) continue;
            this.jobsCreationSemaphore.acquire();
            final Runnable[] runnable = new Runnable[]{(Runnable)execute.o1};
            Object name = (String)execute.o2;
            execute = null;
            if (size > 1) {
                name = (String)name + " (" + size + " scheduled)";
            }
            Job workbenchJob = new Job((String)name){

                public IStatus run(IProgressMonitor monitor) {
                    Runnable r;
                    try {
                        try {
                            r = runnable[0];
                            if (r instanceof IRunnableWithMonitor) {
                                ((IRunnableWithMonitor)r).setMonitor(monitor);
                            }
                            runnable[0] = null;
                            r.run();
                        }
                        catch (RuntimeException e) {
                            if (CorePlugin.getDefault() != null) {
                                Log.log(e);
                            }
                            Object r2 = null;
                            RunnableAsJobsPoolThread.this.jobsCreationSemaphore.release();
                        }
                    }
                    finally {
                        r = null;
                        RunnableAsJobsPoolThread.this.jobsCreationSemaphore.release();
                    }
                    return Status.OK_STATUS;
                }
            };
            workbenchJob.setPriority(10);
            workbenchJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleToRun(IRunnableWithMonitor runnable, String name) {
        Object object = this.lockRunnables;
        synchronized (object) {
            this.runnables.add((Tuple<Runnable, String>)new Tuple((Object)runnable, (Object)name));
        }
        this.canRunSemaphore.release();
    }

    public void waitToFinishCurrent() {
        final Semaphore semaphore = new Semaphore(0L);
        IRunnableWithMonitor runnable = new IRunnableWithMonitor(){

            @Override
            public void run() {
                semaphore.release();
            }

            @Override
            public void setMonitor(IProgressMonitor monitor) {
            }
        };
        this.scheduleToRun(runnable, "Wait to run all currently scheduled jobs");
        semaphore.acquire();
    }

    public static synchronized RunnableAsJobsPoolThread getSingleton() {
        if (singleton == null) {
            int maxSize = 6;
            try {
                int availableProcessors = Runtime.getRuntime().availableProcessors();
                maxSize = availableProcessors <= 1 ? 3 : (int)((long)availableProcessors + Math.round(MathUtils.log(availableProcessors, 1.4)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            singleton = new RunnableAsJobsPoolThread(maxSize);
        }
        return singleton;
    }
}

