/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docstrings;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.python.pydev.core.IAssistProps;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.autoedit.DefaultIndentPrefs;
import org.python.pydev.core.docstrings.DocstringPreferences;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;

public class AssistDocString
implements IAssistProps {
    private final String docStringStyle;

    public AssistDocString() {
        this(null);
    }

    public AssistDocString(String docStringStyle) {
        this.docStringStyle = docStringStyle;
    }

    @Override
    public List<ICompletionProposalHandle> getProps(PySelection ps, IImageCache imageCache, File f, IPythonNature nature, IPyEdit edit, int offset) throws BadLocationException {
        ArrayList<ICompletionProposalHandle> l = new ArrayList<ICompletionProposalHandle>();
        PySelection.InsideParenthesisInfo tuple = ps.getInsideParentesisToks(false);
        if (tuple == null) {
            if (ps.isInClassLine()) {
                tuple = new PySelection.InsideParenthesisInfo(offset, offset, new ArrayList<String>());
            } else {
                return l;
            }
        }
        List<String> params = tuple.contents;
        String initial = PySelection.getIndentationFromLine((String)ps.getCursorLineContents());
        String delimiter = ps.getEndLineDelim();
        String indentation = edit != null ? edit.getIndentPrefs().getIndentationString() : DefaultIndentPrefs.get(nature).getIndentationString();
        String delimiterAndIndent = delimiter + initial + indentation;
        FastStringBuffer buf = new FastStringBuffer();
        String docStringMarker = DocstringPreferences.getDocstringMarker();
        buf.append(delimiterAndIndent + docStringMarker);
        buf.append(delimiterAndIndent);
        int newOffset = buf.length();
        int lineOfOffset = ps.getLineOfOffset(tuple.closeParenthesisOffset);
        int offsetPosToAdd = ps.getEndLineOffset(lineOfOffset);
        IImageHandle image = null;
        if (imageCache != null) {
            image = imageCache.get("icons/template.gif");
        }
        boolean inFunctionLine = ps.isInFunctionLine(true);
        PySelection.DocstringInfo docstringFromFunction = null;
        if (inFunctionLine) {
            docstringFromFunction = ps.getDocstringFromLine(lineOfOffset + 1);
        }
        PySelection.DocstringInfo finalDocstringFromFunction = docstringFromFunction;
        String preferredDocstringStyle = this.docStringStyle;
        if (preferredDocstringStyle == null) {
            preferredDocstringStyle = DocstringPreferences.getPreferredDocstringStyle();
        }
        String preferredDocstringStyle2 = preferredDocstringStyle;
        if (inFunctionLine && params.size() > 0 && preferredDocstringStyle.equals("G")) {
            buf.append("Args:");
        }
        l.add(CompletionProposalFactory.get().createAssistDocstringCompletionProposal("", offsetPosToAdd, 0, newOffset, image, finalDocstringFromFunction != null ? "Update docstring" : "Make docstring", null, null, 10, null, initial, delimiter, docStringMarker, delimiterAndIndent, preferredDocstringStyle2, inFunctionLine, finalDocstringFromFunction, indentation, buf, params));
        return l;
    }

    @Override
    public boolean isValid(PySelection ps, String sel, IPyEdit edit, int offset) {
        return ps.isInFunctionLine(true) || ps.isInClassLine();
    }

    public static String updatedDocstring(String baseDocstring, List<String> params, String delimiter, String indent, String docstringStyle) {
        String paramName;
        String docStringStartEnd;
        String initialIndent = indent;
        if (baseDocstring.startsWith("\"\"\"") && baseDocstring.endsWith("\"\"\"")) {
            docStringStartEnd = "\"\"\"";
        } else if (baseDocstring.startsWith("'''") && baseDocstring.endsWith("'''")) {
            docStringStartEnd = "'''";
        } else if (baseDocstring.startsWith("'") && baseDocstring.endsWith("'")) {
            docStringStartEnd = "'";
        } else if (baseDocstring.startsWith("\"") && baseDocstring.endsWith("\"")) {
            docStringStartEnd = "\"";
        } else {
            return null;
        }
        baseDocstring = baseDocstring.substring(docStringStartEnd.length(), baseDocstring.length() - docStringStartEnd.length());
        Pattern paramPattern = Pattern.compile("\\s*(" + Pattern.quote(docstringStyle) + "param(\\s)+)(\\w+)(\\s)*" + Pattern.quote(":"));
        Pattern paramPatternWithTypeOnSphinx = Pattern.compile("\\s*(" + Pattern.quote(docstringStyle) + "param(\\s)+.*\\s+)(\\w+)(\\s)*" + Pattern.quote(":"));
        Pattern typePattern = Pattern.compile("\\s*(" + Pattern.quote(docstringStyle) + "type(\\s)+)(\\w+)(\\s)*" + Pattern.quote(":"));
        Pattern otherPattern = Pattern.compile("\\s*" + Pattern.quote(docstringStyle) + "(\\w)+(\\b)");
        Pattern googlePattern = Pattern.compile("\\s*(\\w+)*:");
        HashMap<String, ParamInfo> paramInfos = new HashMap<String, ParamInfo>();
        List splitted = StringUtils.splitInLines((String)baseDocstring, (boolean)false);
        String lastIndent = "";
        if (splitted.size() == 0) {
            splitted.add("");
        } else {
            String last = (String)splitted.get(splitted.size() - 1);
            if (last.strip().length() == 0) {
                lastIndent = last;
            }
        }
        String firstLine = ((String)splitted.get(0)).trim();
        if (firstLine.length() > 0) {
            splitted.add(0, "");
            splitted.set(1, (String)indent + (String)splitted.get(1));
        }
        HashSet<String> paramsWithTypeInline = new HashSet<String>();
        HashSet<Integer> otherMatches = new HashSet<Integer>();
        int size = splitted.size();
        int i = 0;
        while (i < size) {
            String s = (String)splitted.get(i);
            Matcher paramMatcher = paramPattern.matcher(s);
            if (paramMatcher.lookingAt()) {
                String paramName2 = paramMatcher.group(3);
                AssistDocString.getParamInfo(paramInfos, (String)paramName2).paramLine = i;
            } else {
                Matcher matcher = paramPatternWithTypeOnSphinx.matcher(s);
                if (matcher.lookingAt()) {
                    String paramName3 = matcher.group(3);
                    AssistDocString.getParamInfo(paramInfos, (String)paramName3).paramLine = i;
                    paramsWithTypeInline.add(paramName3);
                } else {
                    Matcher typeMatcher = typePattern.matcher(s);
                    if (typeMatcher.lookingAt()) {
                        paramName = typeMatcher.group(3);
                        AssistDocString.getParamInfo(paramInfos, (String)paramName).typeLine = i;
                    } else {
                        Matcher otherMatcher = otherPattern.matcher(s);
                        if (otherMatcher.lookingAt()) {
                            otherMatches.add(i);
                        } else {
                            Matcher googleMatcher = googlePattern.matcher(s);
                            if (googleMatcher.lookingAt()) {
                                String paramName4 = googleMatcher.group(1);
                                AssistDocString.getParamInfo(paramInfos, (String)paramName4).paramLine = i;
                            }
                        }
                    }
                }
            }
            ++i;
        }
        FastStringBuffer buf = new FastStringBuffer();
        boolean isGoogleStyle = docstringStyle.equals(Character.toString('G'));
        int paramsSize = params.size();
        if (isGoogleStyle) {
            Object useIndent = null;
            int paramI = 0;
            while (paramI < paramsSize) {
                ParamInfo foundInfo;
                paramName = params.get(paramI);
                if (PySelection.isIdentifier(paramName) && (foundInfo = (ParamInfo)paramInfos.get(paramName)) != null && foundInfo.paramLine >= 0) {
                    String lineContents = (String)splitted.get(foundInfo.paramLine);
                    useIndent = PySelection.getIndentationFromLine((String)lineContents);
                    break;
                }
                ++paramI;
            }
            if (useIndent == null) {
                ParamInfo foundInfo = (ParamInfo)paramInfos.get("Args");
                if (foundInfo == null) {
                    foundInfo = (ParamInfo)paramInfos.get("Returns");
                }
                if (foundInfo != null && foundInfo.paramLine >= 0) {
                    String lineContents = (String)splitted.get(foundInfo.paramLine);
                    useIndent = PySelection.getIndentationFromLine((String)lineContents) + "    ";
                }
            }
            if (useIndent != null) {
                indent = useIndent;
            } else {
                buf.clear();
                splitted.add(buf.append((String)indent).append("Args:").toString());
                indent = (String)indent + "    ";
            }
        }
        int paramI = 0;
        while (paramI < paramsSize) {
            String paramName5 = params.get(paramI);
            if (PySelection.isIdentifier(paramName5)) {
                boolean hasType;
                buf.clear();
                ParamInfo existingInfo = (ParamInfo)paramInfos.get(paramName5);
                boolean hasParam = existingInfo != null && existingInfo.paramLine != -1;
                boolean addTypeForParam = DocstringPreferences.getTypeTagShouldBeGenerated(paramName5);
                if (addTypeForParam && paramsWithTypeInline.contains(paramName5)) {
                    addTypeForParam = false;
                }
                boolean bl = hasType = existingInfo != null && existingInfo.typeLine != -1;
                if (!hasParam || !hasType) {
                    if (!hasParam && !hasType) {
                        ParamInfo newParamInfo = null;
                        if (existingInfo == null) {
                            newParamInfo = new ParamInfo();
                        }
                        int addIndex = AssistDocString.getAddIndex(paramName5, params, paramI, paramInfos, otherMatches, splitted);
                        if (isGoogleStyle) {
                            splitted.add(addIndex, buf.append((String)indent).append(paramName5).append(":").toString());
                        } else {
                            splitted.add(addIndex, buf.append((String)indent).append(docstringStyle).append("param ").append(paramName5).append(":").toString());
                        }
                        buf.clear();
                        AssistDocString.incrementExistingLines(paramInfos, otherMatches, addIndex);
                        if (newParamInfo != null) {
                            newParamInfo.paramLine = addIndex;
                        }
                        if (addTypeForParam) {
                            splitted.add(addIndex + 1, buf.append((String)indent).append(docstringStyle).append("type ").append(paramName5).append(":").toString());
                            buf.clear();
                            AssistDocString.incrementExistingLines(paramInfos, otherMatches, addIndex);
                            if (newParamInfo != null) {
                                newParamInfo.typeLine = addIndex + 1;
                            }
                        }
                        paramInfos.put(paramName5, newParamInfo);
                    } else if (hasParam) {
                        if (addTypeForParam) {
                            int addIndex = existingInfo.paramLine + 1;
                            if (!isGoogleStyle) {
                                splitted.add(addIndex, buf.append((String)indent).append(docstringStyle).append("type ").append(paramName5).append(":").toString());
                            }
                            buf.clear();
                            AssistDocString.incrementExistingLines(paramInfos, otherMatches, addIndex);
                            existingInfo.typeLine = addIndex;
                        }
                    } else {
                        int addIndex = existingInfo.typeLine;
                        splitted.add(addIndex, buf.append((String)indent).append(docstringStyle).append("param ").append(paramName5).append(":").toString());
                        buf.clear();
                        AssistDocString.incrementExistingLines(paramInfos, otherMatches, addIndex);
                        existingInfo.paramLine = addIndex;
                    }
                }
            }
            ++paramI;
        }
        buf.append(docStringStartEnd);
        buf.append(StringUtils.join((String)delimiter, (Collection)splitted));
        String lastLine = (String)splitted.get(splitted.size() - 1);
        if (!lastIndent.equals(lastLine)) {
            buf.append(delimiter).append(lastIndent);
        }
        buf.append(docStringStartEnd);
        return buf.toString();
    }

    private static void incrementExistingLines(Map<String, ParamInfo> paramInfos, Set<Integer> otherMatches, int index) {
        Set<Map.Entry<String, ParamInfo>> entrySet = paramInfos.entrySet();
        for (Map.Entry<String, ParamInfo> entry : entrySet) {
            ParamInfo paramInfo = entry.getValue();
            if (paramInfo.paramLine >= index) {
                ++paramInfo.paramLine;
            }
            if (paramInfo.typeLine < index) continue;
            ++paramInfo.typeLine;
        }
        HashSet<Integer> newOtherMatches = new HashSet<Integer>();
        for (Integer i : otherMatches) {
            if (i >= index) {
                newOtherMatches.add(i + 1);
                continue;
            }
            newOtherMatches.add(i);
        }
        otherMatches.clear();
        otherMatches.addAll(newOtherMatches);
    }

    private static int getAddIndex(String paramName, List<String> params, int paramI, Map<String, ParamInfo> paramInfos, Set<Integer> otherMatches, List<String> splitted) {
        if (paramI == 0) {
            int min = splitted.size();
            if (paramInfos.size() > 0) {
                Set<Map.Entry<String, ParamInfo>> entrySet = paramInfos.entrySet();
                for (Map.Entry<String, ParamInfo> entry : entrySet) {
                    ParamInfo paramInfo = entry.getValue();
                    if (paramInfo.paramLine != -1) {
                        min = Math.min(paramInfo.paramLine, min);
                    }
                    if (paramInfo.typeLine == -1) continue;
                    min = Math.min(paramInfo.typeLine, min);
                }
            }
            for (Integer i : otherMatches) {
                min = Math.min(i, min);
            }
            return min;
        }
        String prevParam = params.get(paramI - 1);
        ParamInfo paramInfo = paramInfos.get(prevParam);
        if (paramInfo.typeLine != -1) {
            return paramInfo.typeLine + 1;
        }
        return paramInfo.paramLine + 1;
    }

    private static ParamInfo getParamInfo(Map<String, ParamInfo> paramInfos, String paramName) {
        ParamInfo paramInfo = paramInfos.get(paramName);
        if (paramInfo == null) {
            paramInfo = new ParamInfo();
            paramInfos.put(paramName, paramInfo);
        }
        return paramInfo;
    }

    private static class ParamInfo {
        public int paramLine = -1;
        public int typeLine = -1;
    }
}

