/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docstrings;

import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.ReplaceEdit;
import org.python.pydev.core.docstrings.AssistDocString;
import org.python.pydev.core.docstrings.DocstringPreferences;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class AssistDocstringProposalCore {
    private final String initial;
    private final String delimiter;
    private final String docStringMarker;
    private final String delimiterAndIndent;
    private final String preferredDocstringStyle2;
    private final boolean inFunctionLine;
    private final PySelection.DocstringInfo finalDocstringFromFunction;
    private final String indentation;
    private final FastStringBuffer buf;
    private final List<String> params;
    public String fReplacementString;
    public int fReplacementOffset;
    public int fReplacementLength;
    public int fCursorPosition;

    public AssistDocstringProposalCore(String initial, String delimiter, String docStringMarker, String delimiterAndIndent, String preferredDocstringStyle2, boolean inFunctionLine, PySelection.DocstringInfo finalDocstringFromFunction, String indentation, FastStringBuffer buf, List<String> params, String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
        this.initial = initial;
        this.delimiter = delimiter;
        this.docStringMarker = docStringMarker;
        this.delimiterAndIndent = delimiterAndIndent;
        this.preferredDocstringStyle2 = preferredDocstringStyle2;
        this.inFunctionLine = inFunctionLine;
        this.finalDocstringFromFunction = finalDocstringFromFunction;
        this.indentation = indentation;
        this.buf = buf;
        this.params = params;
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
    }

    public ReplaceEdit createTextEdit(IDocument document) {
        int iNextLine;
        PySelection ps;
        String nextLine;
        String comp;
        if (this.inFunctionLine) {
            String updatedDocstring = null;
            if (this.finalDocstringFromFunction != null) {
                updatedDocstring = AssistDocString.updatedDocstring(this.finalDocstringFromFunction.string, this.params, this.delimiter, this.initial + this.indentation, this.preferredDocstringStyle2);
            }
            if (updatedDocstring != null) {
                this.fReplacementOffset = this.finalDocstringFromFunction.startLiteralOffset;
                this.fReplacementLength = this.finalDocstringFromFunction.endLiteralOffset - this.finalDocstringFromFunction.startLiteralOffset;
                int initialLen = this.buf.length();
                this.buf.clear();
                this.fCursorPosition -= initialLen - this.buf.length();
                this.buf.append(updatedDocstring);
            } else {
                for (String paramName : this.params) {
                    if (!PySelection.isIdentifier(paramName)) continue;
                    if (this.preferredDocstringStyle2.equals("G")) {
                        this.buf.append(this.delimiterAndIndent).append(this.indentation).append(paramName).append(":");
                    } else {
                        this.buf.append(this.delimiterAndIndent).append(this.preferredDocstringStyle2).append("param ").append(paramName).append(":");
                    }
                    if (!DocstringPreferences.getTypeTagShouldBeGenerated(paramName)) continue;
                    this.buf.append(this.delimiterAndIndent).append(this.preferredDocstringStyle2).append("type ").append(paramName).append(":");
                }
            }
        }
        if (this.finalDocstringFromFunction == null) {
            this.buf.append(this.delimiterAndIndent).append(this.docStringMarker);
        }
        this.fReplacementString = comp = this.buf.toString();
        if (this.finalDocstringFromFunction == null && (nextLine = (ps = new PySelection(document, this.fReplacementOffset)).getLine(iNextLine = ps.getCursorLine() + 1)).trim().equals("pass")) {
            try {
                IRegion lineInformation = document.getLineInformation(iNextLine);
                int offset = lineInformation.getOffset();
                int length = -1;
                if (document.getNumberOfLines() > iNextLine) {
                    int nextLineOffset = document.getLineInformation(iNextLine + 1).getOffset();
                    length = nextLineOffset - offset;
                } else {
                    length = lineInformation.getLength();
                }
                if (length > -1) {
                    int endOffset = offset + nextLine.length();
                    this.fReplacementLength = endOffset - this.fReplacementOffset;
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        ReplaceEdit replaceEdit = new ReplaceEdit(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        return replaceEdit;
    }
}

