/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.docutils.ImportNotRecognizedException;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class ImportHandle {
    public final IDocument doc;
    public final String importFound;
    public final int startFoundLine;
    public int endFoundLine;
    private final List<ImportHandleInfo> importInfo;
    private final boolean allowBadInput;
    private static Pattern CHARS_NOT_CONSIDERED_IN_IMPORT_INFO = Pattern.compile("\\s|\\\\");

    public ImportHandle(IDocument doc, String importFound, int startFoundLine, int endFoundLine, boolean allowBadInput) throws ImportNotRecognizedException {
        this.doc = doc;
        this.importFound = importFound;
        this.startFoundLine = startFoundLine;
        this.endFoundLine = endFoundLine;
        this.importInfo = new ArrayList<ImportHandleInfo>();
        this.allowBadInput = allowBadInput;
        int line = startFoundLine;
        boolean startedInMiddle = false;
        FastStringBuffer imp = new FastStringBuffer();
        ImportHandleInfo found = null;
        int length = importFound.length();
        int i = 0;
        while (i < length) {
            char c = importFound.charAt(i);
            switch (c) {
                case '#': {
                    i = ParsingUtils.create(importFound).eatComments(imp, i);
                    break;
                }
                case ';': {
                    String impStr = imp.toString();
                    int endLine = line + StringUtils.countLineBreaks((String)impStr);
                    found = new ImportHandleInfo(impStr, line, endLine, startedInMiddle, allowBadInput);
                    this.importInfo.add(found);
                    line = endLine;
                    imp = imp.clear();
                    startedInMiddle = true;
                    break;
                }
                case '\n': 
                case '\r': {
                    if (imp.length() <= 0 || imp.lastChar() != '\\') {
                        startedInMiddle = false;
                    }
                }
                default: {
                    imp.append(c);
                }
            }
            ++i;
        }
        String impStr = imp.toString();
        if (impStr.trim().length() > 0) {
            this.importInfo.add(new ImportHandleInfo(impStr, line, line + StringUtils.countLineBreaks((String)impStr), startedInMiddle, allowBadInput));
        }
    }

    public ImportHandle(IDocument doc, String importFound, int startFoundLine, int endFoundLine) throws ImportNotRecognizedException {
        this(doc, importFound, startFoundLine, endFoundLine, false);
    }

    public boolean contains(ImportHandleInfo otherImportInfo) throws ImportNotRecognizedException {
        List<ImportHandleInfo> importHandleInfo = this.getImportInfo();
        for (ImportHandleInfo info : importHandleInfo) {
            if (info.fromStr != otherImportInfo.fromStr) {
                String thisFromStr = info.getFromImportStrWithoutUnwantedChars();
                String otherImportInfoFromStr = otherImportInfo.getFromImportStrWithoutUnwantedChars();
                if (otherImportInfoFromStr == null || thisFromStr == null || !otherImportInfoFromStr.equals(thisFromStr)) continue;
            }
            if (otherImportInfo.importedStr.size() != 1 || !info.importedStr.contains(otherImportInfo.importedStr.get(0))) continue;
            return true;
        }
        return false;
    }

    public List<ImportHandleInfo> getImportInfo() {
        return this.importInfo;
    }

    public static class ImportHandleInfo {
        private static final Pattern FromImportPattern = Pattern.compile("(from\\s+)(\\.|\\w|\\\\)+((\\\\|\\s)+import(\\\\|\\s|$)+)");
        private static final Pattern BadFromPattern = Pattern.compile("(from\\s+)(\\.|\\w|\\\\)+(\\\\|\\s?)+import");
        private static final Pattern BadFromPatternOnlyFrom = Pattern.compile("(from\\s+)");
        private static final Pattern BadFromPatternNoImport = Pattern.compile("(from\\s+)(\\.|\\w|\\\\)+");
        private static final Pattern ImportPattern = Pattern.compile("(import\\s+)");
        private String fromStr;
        private List<String> importedStr;
        private List<String> importedStrComments;
        private int startLine;
        private int endLine;
        private boolean startedInMiddleOfLine;
        private boolean foundFrom = false;
        private boolean foundImport = false;

        public boolean getFoundFrom() {
            return this.foundFrom;
        }

        public boolean getFoundImport() {
            return this.foundImport;
        }

        public ImportHandleInfo(String importFound) throws ImportNotRecognizedException {
            this(importFound, -1, -1, false, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ImportHandleInfo(String importFound, int lineStart, int lineEnd, boolean startedInMiddleOfLine, boolean allowBadInput) throws ImportNotRecognizedException {
            int slashIndex = importFound.indexOf(92);
            if (slashIndex >= 0) {
                FastStringBuffer buf = new FastStringBuffer(importFound, 0);
                boolean changed = false;
                while (slashIndex >= 0) {
                    try {
                        char c = buf.charAt(slashIndex + 1);
                        int deleteTo = -1;
                        if (c == '\n') {
                            deleteTo = slashIndex + 2;
                        } else {
                            if (c != '\r') break;
                            deleteTo = buf.charAt(slashIndex + 2) == '\n' ? slashIndex + 3 : slashIndex + 2;
                        }
                        if (deleteTo == -1) continue;
                        try {
                            c = buf.charAt(deleteTo);
                            while (c == ' ' || c == '\t') {
                                c = buf.charAt(++deleteTo);
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            // empty catch block
                        }
                        buf.delete(slashIndex, deleteTo);
                        changed = true;
                        slashIndex = buf.indexOf('\\');
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        break;
                    }
                }
                if (changed) {
                    importFound = buf.toString();
                }
            }
            this.startLine = lineStart;
            this.endLine = lineEnd;
            this.startedInMiddleOfLine = startedInMiddleOfLine;
            if ((importFound = importFound.stripLeading()).length() == 0) {
                throw new ImportNotRecognizedException("Could not recognize empty string as import");
            }
            char firstChar = importFound.charAt(0);
            if (firstChar == 'f') {
                Matcher matcher = FromImportPattern.matcher(importFound);
                if (matcher.find()) {
                    this.fromStr = importFound.substring(matcher.end(1), matcher.end(2)).trim();
                    this.foundFrom = true;
                    this.foundImport = true;
                    String importedStr = importFound.substring(matcher.end(3), importFound.length()).trim();
                    this.buildImportedList(importedStr);
                    return;
                }
                if (!allowBadInput) throw new ImportNotRecognizedException("Could not recognize import: " + importFound);
                matcher = BadFromPatternOnlyFrom.matcher(importFound);
                if (matcher.matches()) {
                    this.foundFrom = true;
                    this.foundImport = false;
                    this.dummyImportList();
                    return;
                }
                matcher = BadFromPattern.matcher(importFound);
                if (matcher.find()) {
                    this.foundFrom = true;
                    this.foundImport = true;
                    this.fromStr = importFound.substring(matcher.end(1), matcher.end(2)).trim();
                    this.dummyImportList();
                    return;
                }
                matcher = BadFromPatternNoImport.matcher(importFound);
                if (!matcher.matches()) throw new ImportNotRecognizedException("Could not recognize import: " + importFound);
                this.foundFrom = true;
                this.foundImport = false;
                this.fromStr = importFound.substring(matcher.end(1), matcher.end(2)).trim();
                this.dummyImportList();
                return;
            }
            if (firstChar != 'i') throw new ImportNotRecognizedException("Could not recognize import: " + importFound);
            Matcher matcher = ImportPattern.matcher(importFound);
            if (matcher.find()) {
                String importedStr = importFound.substring(matcher.end(1), importFound.length()).trim();
                this.foundFrom = false;
                this.foundImport = true;
                this.buildImportedList(importedStr);
                return;
            }
            if (!allowBadInput) throw new ImportNotRecognizedException("Could not recognize import: " + importFound);
            if (!"import".equals(importFound)) throw new ImportNotRecognizedException("Could not recognize import: " + importFound);
            this.foundFrom = false;
            this.foundImport = true;
            this.dummyImportList();
        }

        private void dummyImportList() {
            this.importedStrComments = Arrays.asList(new String[0]);
            this.importedStr = this.importedStrComments;
        }

        private void buildImportedList(String importedStr) {
            ArrayList<String> lst = new ArrayList<String>();
            ArrayList<String> importComments = new ArrayList<String>();
            FastStringBuffer alias = new FastStringBuffer();
            FastStringBuffer comments = new FastStringBuffer();
            int i = 0;
            while (i < importedStr.length()) {
                char c = importedStr.charAt(i);
                if (c == '#') {
                    comments = comments.clear();
                    i = ParsingUtils.create(importedStr).eatComments(comments, i);
                    this.addImportAlias(lst, importComments, alias, comments.toString());
                    alias = alias.clear();
                } else if (c == ',' || c == '\r' || c == '\n') {
                    this.addImportAlias(lst, importComments, alias, "");
                    alias = alias.clear();
                } else if (c != '(' && c != ')' && c != '\\') {
                    alias.append(c);
                }
                ++i;
            }
            if (alias.length() > 0) {
                this.addImportAlias(lst, importComments, alias, "");
            }
            this.importedStrComments = importComments;
            this.importedStr = lst;
        }

        private void addImportAlias(ArrayList<String> lst, ArrayList<String> importComments, FastStringBuffer alias, String importComment) {
            String aliasStr = alias.toString().trim();
            importComment = importComment.trim();
            if (aliasStr.length() > 0) {
                lst.add(aliasStr);
                importComments.add(importComment);
            } else if (importComment.length() > 0 && importComments.size() > 0) {
                importComments.set(importComments.size() - 1, importComment);
            }
        }

        public String getFromImportStr() {
            return this.fromStr;
        }

        public String getFromImportStrWithoutUnwantedChars() {
            if (this.fromStr != null) {
                return CHARS_NOT_CONSIDERED_IN_IMPORT_INFO.matcher(this.fromStr).replaceAll("");
            }
            return this.fromStr;
        }

        public List<String> getImportedStr() {
            return this.importedStr;
        }

        public List<String> getCommentsForImports() {
            return this.importedStrComments;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public boolean getStartedInMiddleOfLine() {
            return this.startedInMiddleOfLine;
        }

        public List<Tuple<String, String>> getImportedStrAndComments() {
            ArrayList<Tuple<String, String>> lst = new ArrayList<Tuple<String, String>>();
            int i = 0;
            while (i < this.importedStr.size()) {
                lst.add((Tuple<String, String>)new Tuple((Object)this.importedStr.get(i), (Object)this.importedStrComments.get(i)));
                ++i;
            }
            return lst;
        }
    }
}

