/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.formatter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.formatter.FormatStd;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.FastStack;

public class PyFormatStdManageBlankLines {
    private final boolean DEBUG = false;
    private final FormatStd std;
    private final IDocument doc;
    private final FastStringBuffer initialFormatting;
    private final String delimiter;
    private final ParsingUtils parsingUtils;
    private final char[] cs;
    private final FastStringBuffer tempBuf;
    private final int length;
    private int offset = 0;
    private int matchI = -1;
    private boolean onlyWhitespacesFound = true;
    private boolean onlyCommentsFound = false;
    private int decoratorState = 0;
    private int currLogicLine = 0;
    private int currRealLine = 0;
    private final FastStack<Integer> nextScopeStartRealLineTopLevel = new FastStack(2);
    private final FastStack<Integer> nextScopeStartRealLineInnerLevel = new FastStack(10);
    private final List<LineOffsetAndInfo> logicalLinesInfo = new ArrayList<LineOffsetAndInfo>();

    private PyFormatStdManageBlankLines(FormatStd std, FastStringBuffer initialFormatting, String delimiter) {
        this.std = std;
        this.doc = new Document(initialFormatting.toString());
        this.initialFormatting = initialFormatting;
        this.delimiter = delimiter;
        this.parsingUtils = ParsingUtils.create(initialFormatting);
        this.cs = initialFormatting.getInternalCharsArray();
        this.tempBuf = new FastStringBuffer();
        this.length = initialFormatting.length();
    }

    public static List<LineOffsetAndInfo> computeBlankLinesAmongMethodsAndClasses(FormatStd std, FastStringBuffer initialFormatting, String delimiter) throws SyntaxErrorException {
        PyFormatStdManageBlankLines fmt = new PyFormatStdManageBlankLines(std, initialFormatting, delimiter);
        List<LineOffsetAndInfo> computed = fmt.computeBlankLinesAmongMethodsAndClassesInternal();
        int size = computed.size();
        LineOffsetAndInfo prev = null;
        int i = 0;
        while (i < size) {
            LineOffsetAndInfo curr = computed.get(i);
            if (prev != null && prev.onlyWhitespacesFound && !curr.onlyWhitespacesFound && curr.addBlankLines > 0) {
                if (prev.delete) {
                    prev.delete = false;
                    --curr.addBlankLines;
                }
                if (curr.addBlankLines > 0) {
                    prev.addBlankLines += curr.addBlankLines;
                    curr.addBlankLines = 0;
                }
            }
            prev = curr;
            ++i;
        }
        return computed;
    }

    private List<LineOffsetAndInfo> computeBlankLinesAmongMethodsAndClassesInternal() throws SyntaxErrorException {
        this.logicalLinesInfo.add(new LineOffsetAndInfo(0, 0, 0));
        while (this.offset < this.length) {
            char c = this.cs[this.offset];
            if (c == '\r' || c == '\n') {
                boolean sameLogicLine;
                boolean bl = sameLogicLine = this.offset > 0 && this.cs[this.offset - 1] == '\\';
                if (c == '\r' && this.offset + 1 < this.length && this.cs[this.offset + 1] == '\n') {
                    ++this.offset;
                }
                ++this.currRealLine;
                if (!sameLogicLine) {
                    ++this.currLogicLine;
                    if (this.onlyWhitespacesFound && this.logicalLinesInfo.size() > 2 && this.logicalLinesInfo.get((int)(this.logicalLinesInfo.size() - 2)).onlyWhitespacesFound) {
                        this.logicalLinesInfo.get((int)(this.logicalLinesInfo.size() - 2)).delete = true;
                    }
                    LineOffsetAndInfo currLineOffsetAndInfo = this.logicalLinesInfo.get(this.logicalLinesInfo.size() - 1);
                    currLineOffsetAndInfo.onlyWhitespacesFound = this.onlyWhitespacesFound;
                    currLineOffsetAndInfo.onlyCommentsFound = this.onlyCommentsFound;
                    this.logicalLinesInfo.add(new LineOffsetAndInfo(this.offset + 1, this.currLogicLine, this.currRealLine));
                    this.onlyWhitespacesFound = true;
                    this.onlyCommentsFound = false;
                }
            } else if (!Character.isWhitespace(c)) {
                if (c == '#') {
                    if (this.onlyWhitespacesFound) {
                        this.onlyCommentsFound = true;
                    }
                    this.onlyWhitespacesFound = false;
                    this.offset = this.parsingUtils.eatComments(null, this.offset, false);
                } else {
                    if (c == '@' && this.onlyWhitespacesFound && this.decoratorState == 0) {
                        this.decoratorState = 1;
                    }
                    boolean onlyWhitespacesFoundInCurrLine = this.onlyWhitespacesFound;
                    this.onlyWhitespacesFound = false;
                    this.matchI = -1;
                    switch (c) {
                        case '\"': 
                        case '\'': {
                            this.offset = this.parsingUtils.eatLiterals(this.tempBuf.clear(), this.offset);
                            int count = this.tempBuf.countNewLines();
                            this.currLogicLine += count;
                            this.currRealLine += count;
                            break;
                        }
                        case '@': 
                        case 'a': 
                        case 'c': 
                        case 'd': {
                            if (!onlyWhitespacesFoundInCurrLine) break;
                            switch (c) {
                                case 'a': {
                                    int matchOffset = ParsingUtils.matchAsyncFunction(this.offset, this.cs, this.length);
                                    this.onMatchDefinition(matchOffset);
                                }
                                case 'c': {
                                    int matchOffset = ParsingUtils.matchClass(this.offset, this.cs, this.length);
                                    this.onMatchDefinition(matchOffset);
                                    break;
                                }
                                case 'd': {
                                    int matchOffset = ParsingUtils.matchFunction(this.offset, this.cs, this.length);
                                    this.onMatchDefinition(matchOffset);
                                    break;
                                }
                                case '@': {
                                    this.matchI = -1;
                                    if (this.decoratorState == 2 || this.decoratorState != 1) break;
                                    this.matchI = this.offset + 1;
                                    this.decoratorState = 2;
                                    break;
                                }
                                default: {
                                    throw new RuntimeException("Error, should not get here.");
                                }
                            }
                            if (this.matchI <= 0 || this.offset <= 0) break;
                            int blankLinesNeeded = this.std.blankLinesInner;
                            if (this.cs[this.offset - 1] == '\n' || this.cs[this.offset - 1] == '\r') {
                                blankLinesNeeded = this.std.blankLinesTopLevel;
                            }
                            this.markBlankLinesNeededAt(this.currLogicLine, blankLinesNeeded, "on declaration found");
                            this.offset = this.matchI - 1;
                        }
                    }
                    if (!this.nextScopeStartRealLineTopLevel.empty() && this.currRealLine == (Integer)this.nextScopeStartRealLineTopLevel.peek()) {
                        this.nextScopeStartRealLineTopLevel.pop();
                        this.nextScopeStartRealLineInnerLevel.clear();
                        this.markBlankLinesNeededAt(this.currLogicLine, this.std.blankLinesTopLevel, "on top level");
                    } else if (!this.nextScopeStartRealLineInnerLevel.empty() && this.currRealLine >= (Integer)this.nextScopeStartRealLineInnerLevel.peek()) {
                        int endsAtRealLine = (Integer)this.nextScopeStartRealLineInnerLevel.pop();
                        while (!this.nextScopeStartRealLineInnerLevel.empty() && (Integer)this.nextScopeStartRealLineInnerLevel.peek() <= endsAtRealLine) {
                            this.nextScopeStartRealLineInnerLevel.pop();
                        }
                        this.markBlankLinesNeededAt(this.currLogicLine, this.std.blankLinesInner, "on declaration end");
                    }
                }
            }
            ++this.offset;
        }
        return this.logicalLinesInfo;
    }

    private void onMatchDefinition(int matchOffset) {
        if (matchOffset > 0) {
            try {
                int endLine = PySelection.getEndLineOfCurrentDeclaration(this.doc, this.offset) + 1;
                if (this.offset == 0 || this.cs[this.offset - 1] == '\n' || this.cs[this.offset - 1] == '\r') {
                    this.nextScopeStartRealLineTopLevel.push((Object)endLine);
                } else {
                    this.nextScopeStartRealLineInnerLevel.push((Object)endLine);
                }
            }
            catch (BadLocationException e) {
                Log.log(e);
            }
            if (this.decoratorState > 0) {
                this.decoratorState = 0;
                this.matchI = -1;
                if (this.logicalLinesInfo.size() > 1) {
                    int reverseI = this.logicalLinesInfo.size() - 2;
                    while (reverseI >= 0) {
                        LineOffsetAndInfo lineOffsetAndInfo = this.logicalLinesInfo.get(reverseI);
                        if (lineOffsetAndInfo.onlyWhitespacesFound) {
                            lineOffsetAndInfo.delete = true;
                            --reverseI;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.matchI = matchOffset;
            }
        }
    }

    private void markBlankLinesNeededAt(int currLogicLine, int blankLinesNeeded, String debugInfo) {
        if (this.logicalLinesInfo.size() > 1) {
            int reverseI = this.logicalLinesInfo.size() - 2;
            int foundAt = this.logicalLinesInfo.size() - 1;
            int foundAtLine = currLogicLine;
            LineOffsetAndInfo currLineOffsetAndInfo = this.logicalLinesInfo.get(foundAt);
            while (reverseI >= 0) {
                LineOffsetAndInfo prev = this.logicalLinesInfo.get(reverseI);
                if (prev.infoFromLogicalLine != foundAtLine - 1) break;
                --foundAtLine;
                if (!prev.onlyCommentsFound) break;
                currLineOffsetAndInfo = prev;
                foundAt = reverseI--;
            }
            if (reverseI >= 0) {
                LineOffsetAndInfo info;
                int tempLine = this.logicalLinesInfo.get((int)reverseI).infoFromLogicalLine;
                int k = reverseI;
                while (k >= 0 && blankLinesNeeded > 0) {
                    info = this.logicalLinesInfo.get(k);
                    if (info.infoFromLogicalLine != tempLine) break;
                    --tempLine;
                    if (!info.onlyWhitespacesFound) break;
                    if (!info.delete) {
                        blankLinesNeeded -= 1 + info.addBlankLines;
                    }
                    --k;
                }
                if (blankLinesNeeded > 0) {
                    tempLine = this.logicalLinesInfo.get((int)reverseI).infoFromLogicalLine;
                    k = reverseI;
                    while (k >= 0 && blankLinesNeeded > 0) {
                        info = this.logicalLinesInfo.get(k);
                        if (info.infoFromLogicalLine != tempLine) break;
                        --tempLine;
                        if (!info.onlyWhitespacesFound) break;
                        if (info.delete) {
                            info.delete = false;
                            blankLinesNeeded -= 1 + info.addBlankLines;
                        }
                        --k;
                    }
                    if (blankLinesNeeded > 0) {
                        currLineOffsetAndInfo.addBlankLines = Math.max(currLineOffsetAndInfo.addBlankLines, blankLinesNeeded);
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static FastStringBuffer fixBlankLinesAmongMethodsAndClasses(List<LineOffsetAndInfo> computed, FormatStd std, IDocument doc, FastStringBuffer initialFormatting, String delimiter) {
        cs = initialFormatting.getInternalCharsArray();
        length = initialFormatting.length();
        it = computed.iterator();
        currInfo = it.next();
        newBuf = new FastStringBuffer(length + 20);
        i = 0;
        while (i < length) {
            if (i > currInfo.offset && it.hasNext()) {
                currInfo = it.next();
            }
            c = cs[i];
            if (i != currInfo.offset) ** GOTO lbl-1000
            j = 0;
            while (j < currInfo.addBlankLines) {
                newBuf.append(delimiter);
                ++j;
            }
            if (currInfo.delete) {
                while (c != '\r' && c != '\n' && i < length) {
                    c = cs[++i];
                }
                if (c == '\r' && i + 1 < length && cs[i + 1] == '\n') {
                    ++i;
                }
            } else lbl-1000:
            // 2 sources

            {
                newBuf.append(c);
            }
            ++i;
        }
        return newBuf;
    }

    public static class LineOffsetAndInfo {
        public boolean delete;
        public int offset;
        public boolean onlyWhitespacesFound = false;
        public boolean onlyCommentsFound = false;
        public int addBlankLines;
        public final int infoFromRealLine;
        public final int infoFromLogicalLine;

        public LineOffsetAndInfo(int offset, int currLogicalLine, int currRealLine) {
            this.offset = offset;
            Assert.isTrue((currRealLine >= currLogicalLine ? 1 : 0) != 0);
            this.infoFromLogicalLine = currLogicalLine;
            this.infoFromRealLine = currRealLine;
        }

        public String toString() {
            return StringUtils.join((String)", ", (Object[])new Object[]{"offset: " + this.offset, "delete: " + this.delete, "logic line: " + this.infoFromLogicalLine, "real line: " + this.infoFromRealLine, "addBlankLines: " + this.addBlankLines, "onlyWhitespacesFound: " + this.onlyWhitespacesFound, "onlyCommentsFound: " + this.onlyCommentsFound + "\n"});
        }
    }
}

