/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.imports;

import java.util.Optional;
import org.eclipse.core.runtime.IAdaptable;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.preferences.PyScopedPreferences;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.process.ProcessUtils;

public class ImportPreferences {
    public static final String IMPORT_ENGINE = "IMPORT_ENGINE";
    public static final String IMPORT_ENGINE_REGULAR_SORT = "IMPORT_ENGINE_REGULAR_SORT";
    public static final String IMPORT_ENGINE_PEP_8 = "IMPORT_ENGINE_PEP_8";
    public static final String IMPORT_ENGINE_ISORT = "IMPORT_ENGINE_ISORT";
    public static final String DEFAULT_IMPORT_ENGINE = "IMPORT_ENGINE_PEP_8";
    public static final String GROUP_IMPORTS = "GROUP_IMPORTS";
    public static final boolean DEFAULT_GROUP_IMPORTS = true;
    public static final String MULTILINE_IMPORTS = "MULTILINE_IMPORTS";
    public static final boolean DEFAULT_MULTILINE_IMPORTS = true;
    public static final String FROM_IMPORTS_FIRST = "FROM_IMPORTS_FIRST";
    public static final boolean DEFAULT_FROM_IMPORTS_FIRST = false;
    public static final String SORT_NAMES_GROUPED = "SORT_NAMES_GROUPED";
    public static final boolean DEFAULT_SORT_NAMES_GROUPED = false;
    public static final String DELETE_UNUSED_IMPORTS = "DELETE_UNUSED_IMPORTS";
    public static final boolean DEFAULT_DELETE_UNUSED_IMPORTS = false;
    public static final String BREAK_IMPORTS_MODE = "BREAK_IMPORTS_MODE";
    public static final String BREAK_IMPORTS_MODE_ESCAPE = "ESCAPE";
    public static final String BREAK_IMPORTS_MODE_PARENTHESIS = "PARENTHESIS";
    public static final String DEFAULT_BREAK_IMPORTS_MODE = "PARENTHESIS";
    public static final String LOCATION_SEARCH = "LOCATION_SEARCH";
    public static final String LOCATION_SPECIFY = "LOCATION_SPECIFY";
    public static final String ISORT_LOCATION_OPTION = "ISORT_LOCATION_OPTION";
    public static final String DEFAULT_ISORT_LOCATION_OPTION = "LOCATION_SEARCH";
    public static final String ISORT_FILE_LOCATION = "ISORT_FILE_LOCATION";
    public static final String ISORT_PARAMETERS = "ISORT_PARAMETERS";
    public static boolean pep8ImportsForTests = true;
    public static boolean deleteUnusedImportsForTests = true;
    public static String breakImportModeForTests = "PARENTHESIS";
    public static boolean sortNamesGroupedForTests = false;
    public static boolean multilineImportsForTests = true;
    public static boolean sortFromImportsFirstForTests = true;
    public static boolean groupImportsForTests = true;

    public static String getImportEngine(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            if (pep8ImportsForTests) {
                return "IMPORT_ENGINE_PEP_8";
            }
            return IMPORT_ENGINE_REGULAR_SORT;
        }
        String importEngine = PyScopedPreferences.getString(IMPORT_ENGINE, projectAdaptable);
        if (importEngine == null) {
            importEngine = "IMPORT_ENGINE_PEP_8";
        }
        switch (importEngine) {
            case "IMPORT_ENGINE_ISORT": 
            case "IMPORT_ENGINE_PEP_8": 
            case "IMPORT_ENGINE_REGULAR_SORT": {
                return importEngine;
            }
        }
        return "IMPORT_ENGINE_PEP_8";
    }

    public static Optional<String> getISortExecutable(IAdaptable projectAdaptable) {
        String isortFileLocation;
        String locationOption = PyScopedPreferences.getString(ISORT_LOCATION_OPTION, projectAdaptable);
        if (LOCATION_SPECIFY.equals(locationOption) && (isortFileLocation = PyScopedPreferences.getString(ISORT_FILE_LOCATION, projectAdaptable)) != null && isortFileLocation.length() > 0) {
            return Optional.of(isortFileLocation);
        }
        return Optional.empty();
    }

    public static String[] getISortArguments(IAdaptable projectAdaptable) {
        String parameters = PyScopedPreferences.getString(ISORT_PARAMETERS, projectAdaptable);
        if (parameters != null && parameters.length() > 0) {
            return ProcessUtils.parseArguments((String)parameters);
        }
        return new String[0];
    }

    public static boolean getDeleteUnusedImports(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return deleteUnusedImportsForTests;
        }
        return PyScopedPreferences.getBoolean(DELETE_UNUSED_IMPORTS, projectAdaptable);
    }

    public static String getBreakImportMode(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return breakImportModeForTests;
        }
        return PyScopedPreferences.getString(BREAK_IMPORTS_MODE, projectAdaptable);
    }

    public static boolean getSortNamesGrouped(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return sortNamesGroupedForTests;
        }
        return PyScopedPreferences.getBoolean(SORT_NAMES_GROUPED, projectAdaptable);
    }

    public static boolean getMultilineImports(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return multilineImportsForTests;
        }
        return PyScopedPreferences.getBoolean(MULTILINE_IMPORTS, projectAdaptable);
    }

    public static boolean getSortFromImportsFirst(IAdaptable projectAdaptable) {
        if (CorePlugin.getDefault() == null) {
            return sortFromImportsFirstForTests;
        }
        return PyScopedPreferences.getBoolean(FROM_IMPORTS_FIRST, projectAdaptable);
    }

    public static boolean getGroupImports(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return groupImportsForTests;
        }
        return PyScopedPreferences.getBoolean(GROUP_IMPORTS, projectAdaptable);
    }
}

