/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.nature;

import java.io.File;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.resources.IResource;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.io.FileUtils;

public abstract class AbstractPythonNature
implements IPythonNature {
    private final Stack<IModulesManager> modulesManagerStack = new Stack();
    private final Object modulesManagerStackLock = new Object();
    private AtomicLong mtime = new AtomicLong();

    @Override
    public boolean isResourceInPythonpath(IResource resource) throws MisconfigurationException {
        return this.resolveModule(resource) != null;
    }

    @Override
    public boolean isResourceInPythonpath(String absPath) throws MisconfigurationException {
        return this.resolveModule(absPath) != null;
    }

    @Override
    public String resolveModule(IResource resource) throws MisconfigurationException {
        String resourceOSString = SharedCorePlugin.getIResourceOSString((IResource)resource);
        if (resourceOSString == null) {
            return null;
        }
        return this.resolveModule(resourceOSString);
    }

    @Override
    public String resolveModule(File file) throws MisconfigurationException {
        return this.resolveModule(FileUtils.getFileAbsolutePath((File)file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startRequests() {
        ICodeCompletionASTManager astManager = this.getAstManager();
        if (astManager == null) {
            return false;
        }
        IModulesManager modulesManager = astManager.getModulesManager();
        if (modulesManager == null) {
            return false;
        }
        Object object = this.modulesManagerStackLock;
        synchronized (object) {
            this.modulesManagerStack.push(modulesManager);
            return modulesManager.startCompletionCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endRequests() {
        Object object = this.modulesManagerStackLock;
        synchronized (object) {
            try {
                IModulesManager modulesManager = this.modulesManagerStack.pop();
                modulesManager.endCompletionCache();
            }
            catch (EmptyStackException e) {
                Log.log(e);
            }
        }
    }

    @Override
    public void updateMtime() {
        this.mtime.incrementAndGet();
    }

    @Override
    public long getMtime() {
        return this.mtime.get();
    }
}

