/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.partition;

import java.util.ArrayList;
import java.util.List;
import org.python.pydev.shared_core.partitioner.IChangeTokenRule;
import org.python.pydev.shared_core.partitioner.ICharacterScanner;
import org.python.pydev.shared_core.partitioner.IMarkScanner;
import org.python.pydev.shared_core.partitioner.IPredicateRule;
import org.python.pydev.shared_core.partitioner.IToken;
import org.python.pydev.shared_core.partitioner.Token;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class MultiLineRuleWithMultipleStarts
implements IPredicateRule,
IChangeTokenRule {
    protected IToken fToken;
    protected final List<char[]> fStartSequences;
    protected final char[] fEndSequence;
    protected final char fEscapeCharacter;

    public void setToken(IToken token) {
        this.fToken = token;
    }

    public MultiLineRuleWithMultipleStarts(String[] startSequences, String end, IToken token, char escapeCharacter) {
        ArrayList<char[]> lst = new ArrayList<char[]>(startSequences.length);
        String[] stringArray = startSequences;
        int n = startSequences.length;
        int n2 = 0;
        while (n2 < n) {
            String start = stringArray[n2];
            lst.add(start.toCharArray());
            ++n2;
        }
        this.fStartSequences = lst;
        this.fEndSequence = end.toCharArray();
        this.fToken = token;
        this.fEscapeCharacter = escapeCharacter;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public IToken getSuccessToken() {
        return this.fToken;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        int c;
        if (resume) {
            return Token.UNDEFINED;
        }
        IMarkScanner markScanner = (IMarkScanner)scanner;
        int mark = markScanner.getMark();
        int size = this.fStartSequences.size();
        int j = 0;
        while (j < size) {
            boolean found = true;
            char[] startSequence = this.fStartSequences.get(j);
            int i = 0;
            while (i < startSequence.length) {
                c = scanner.read();
                if (c != startSequence[i]) {
                    found = false;
                    markScanner.setMark(mark);
                    break;
                }
                ++i;
            }
            if (found) break;
            if (j == size - 1) {
                return Token.UNDEFINED;
            }
            ++j;
        }
        while (true) {
            if ((c = scanner.read()) == -1) {
                return this.fToken;
            }
            if (c == this.fEscapeCharacter) {
                c = scanner.read();
                if (c != -1) continue;
                return this.fToken;
            }
            mark = markScanner.getMark();
            boolean matched = true;
            int i = 0;
            while (true) {
                if (c != this.fEndSequence[i]) {
                    markScanner.setMark(mark);
                    matched = false;
                    break;
                }
                if (i + 1 >= this.fEndSequence.length) break;
                c = scanner.read();
                ++i;
            }
            if (matched) break;
        }
        return this.fToken;
    }

    public String toString() {
        FastStringBuffer buf = new FastStringBuffer("MultiLineRuleWithMultipleStarts(", this.fEndSequence.length + 40);
        buf.append("start: ");
        for (char[] chars : this.fStartSequences) {
            buf.append(chars).append(",\n");
        }
        buf.append("end: ").append(this.fEndSequence).append(")");
        return buf.toString();
    }
}

